/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.base.manager.impl;

import eu.thesimplecloud.api.cachelist.ICacheList;
import eu.thesimplecloud.api.service.ICloudService;
import eu.thesimplecloud.api.service.start.configuration.IServiceStartConfiguration;
import eu.thesimplecloud.api.service.start.future.IServiceStartPromise;
import eu.thesimplecloud.api.service.start.future.ServiceStartPromise;
import eu.thesimplecloud.api.servicegroup.ICloudServiceGroup;
import eu.thesimplecloud.api.servicegroup.impl.AbstractCloudServiceGroupManager;
import eu.thesimplecloud.base.manager.startup.Manager;
import eu.thesimplecloud.clientserverapi.lib.promise.CommunicationPromise;
import eu.thesimplecloud.clientserverapi.lib.promise.ICommunicationPromise;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0005H\u0016J\u001e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u00042\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J&\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u00042\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000bH\u0016\u00a8\u0006\u0012"}, d2={"Leu/thesimplecloud/base/manager/impl/CloudServiceGroupManagerImpl;", "Leu/thesimplecloud/api/servicegroup/impl/AbstractCloudServiceGroupManager;", "()V", "createServiceGroup", "Leu/thesimplecloud/clientserverapi/lib/promise/ICommunicationPromise;", "Leu/thesimplecloud/api/servicegroup/ICloudServiceGroup;", "cloudServiceGroup", "delete", "", "value", "fromPacket", "", "startNewService", "Leu/thesimplecloud/api/service/start/future/IServiceStartPromise;", "serviceStartConfiguration", "Leu/thesimplecloud/api/service/start/configuration/IServiceStartConfiguration;", "update", "isCalledFromDelete", "simplecloud-base"})
public final class CloudServiceGroupManagerImpl
extends AbstractCloudServiceGroupManager {
    @NotNull
    public ICommunicationPromise<ICloudServiceGroup> createServiceGroup(@NotNull ICloudServiceGroup cloudServiceGroup) {
        Intrinsics.checkNotNullParameter((Object)cloudServiceGroup, (String)"cloudServiceGroup");
        CommunicationPromise promise = new CommunicationPromise(0L, false, 3, null);
        if (this.getServiceGroupByName(cloudServiceGroup.getName()) == null) {
            ICacheList.DefaultImpls.update$default((ICacheList)this, (Object)cloudServiceGroup, (boolean)false, (boolean)false, (int)6, null);
            promise.trySuccess((Object)cloudServiceGroup);
        } else {
            promise.setFailure((Throwable)new IllegalArgumentException("The name of the specified group is already in use"));
        }
        return (ICommunicationPromise)promise;
    }

    @NotNull
    public ICommunicationPromise<Unit> update(@NotNull ICloudServiceGroup value, boolean fromPacket, boolean isCalledFromDelete) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Manager.Companion.getInstance().getCloudServiceGroupFileHandler().save(value);
        return super.update((Object)value, fromPacket, isCalledFromDelete);
    }

    @NotNull
    public IServiceStartPromise startNewService(@NotNull IServiceStartConfiguration serviceStartConfiguration) {
        ICloudService iCloudService;
        Intrinsics.checkNotNullParameter((Object)serviceStartConfiguration, (String)"serviceStartConfiguration");
        try {
            iCloudService = Manager.Companion.getInstance().getServiceHandler().startService(serviceStartConfiguration);
        }
        catch (IllegalArgumentException ex) {
            return (IServiceStartPromise)new ServiceStartPromise(CommunicationPromise.Companion.failed((Throwable)ex));
        }
        ICloudService service = iCloudService;
        return (IServiceStartPromise)new ServiceStartPromise(CommunicationPromise.Companion.of((Object)service));
    }

    @NotNull
    public ICommunicationPromise<Unit> delete(@NotNull ICloudServiceGroup value, boolean fromPacket) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Manager.Companion.getInstance().getCloudServiceGroupFileHandler().delete(value);
        return super.delete(value, fromPacket);
    }
}

