/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.base.manager.network.packets.player;

import eu.thesimplecloud.api.CloudAPI;
import eu.thesimplecloud.api.exception.NoSuchPlayerException;
import eu.thesimplecloud.api.exception.NoSuchServiceException;
import eu.thesimplecloud.api.location.SimpleLocation;
import eu.thesimplecloud.api.player.ICloudPlayer;
import eu.thesimplecloud.api.service.ICloudService;
import eu.thesimplecloud.clientserverapi.lib.connection.IConnection;
import eu.thesimplecloud.clientserverapi.lib.packet.packettype.JsonPacket;
import eu.thesimplecloud.clientserverapi.lib.promise.ICommunicationPromise;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\b\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\t"}, d2={"Leu/thesimplecloud/base/manager/network/packets/player/PacketInTeleportOtherService;", "Leu/thesimplecloud/clientserverapi/lib/packet/packettype/JsonPacket;", "()V", "handle", "Leu/thesimplecloud/clientserverapi/lib/promise/ICommunicationPromise;", "", "connection", "Leu/thesimplecloud/clientserverapi/lib/connection/IConnection;", "(Leu/thesimplecloud/clientserverapi/lib/connection/IConnection;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "simplecloud-base"})
public final class PacketInTeleportOtherService
extends JsonPacket {
    @Nullable
    public Object handle(@NotNull IConnection connection, @NotNull Continuation<? super ICommunicationPromise<? extends Object>> $completion) {
        UUID uUID = (UUID)this.getJsonLib().getObject("playerUniqueId", UUID.class);
        if (uUID == null) {
            return this.contentException("playerUniqueId");
        }
        UUID playerUniqueId = uUID;
        String string = this.getJsonLib().getString("serviceName");
        if (string == null) {
            return this.contentException("serviceName");
        }
        String serviceName = string;
        SimpleLocation simpleLocation = (SimpleLocation)this.getJsonLib().getObject("simpleLocation", SimpleLocation.class);
        if (simpleLocation == null) {
            return this.contentException("simpleLocation");
        }
        SimpleLocation simpleLocation2 = simpleLocation;
        ICloudPlayer iCloudPlayer = CloudAPI.Companion.getInstance().getCloudPlayerManager().getCachedCloudPlayer(playerUniqueId);
        if (iCloudPlayer == null) {
            return this.failure((Throwable)new NoSuchPlayerException("Player cannot be found"));
        }
        ICloudPlayer cloudPlayer = iCloudPlayer;
        ICloudService iCloudService = CloudAPI.Companion.getInstance().getCloudServiceManager().getCloudServiceByName(serviceName);
        if (iCloudService == null) {
            return this.failure((Throwable)new NoSuchServiceException("Service cannot be found"));
        }
        ICloudService service = iCloudService;
        if (service.isProxy()) {
            return this.failure(new IllegalArgumentException("Cannot connect a player to a proxy service."));
        }
        return cloudPlayer.teleport(simpleLocation2.toServiceLocation(serviceName));
    }
}

