/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.base.manager.service;

import eu.thesimplecloud.api.CloudAPI;
import eu.thesimplecloud.api.cachelist.ICacheList;
import eu.thesimplecloud.api.network.packets.service.PacketIOWrapperStartService;
import eu.thesimplecloud.api.service.ICloudService;
import eu.thesimplecloud.api.service.ServiceState;
import eu.thesimplecloud.api.service.impl.DefaultCloudService;
import eu.thesimplecloud.api.service.start.configuration.IServiceStartConfiguration;
import eu.thesimplecloud.api.service.start.configuration.ServiceStartConfiguration;
import eu.thesimplecloud.api.servicegroup.ICloudServiceGroup;
import eu.thesimplecloud.api.utils.time.Timestamp;
import eu.thesimplecloud.api.wrapper.IWrapperInfo;
import eu.thesimplecloud.api.wrapper.IWrapperManager;
import eu.thesimplecloud.base.manager.service.IServiceHandler;
import eu.thesimplecloud.base.manager.service.ServiceMinimumCountCalculator;
import eu.thesimplecloud.base.manager.startup.Manager;
import eu.thesimplecloud.clientserverapi.lib.packet.IPacket;
import eu.thesimplecloud.clientserverapi.lib.packet.packetsender.IPacketSender;
import eu.thesimplecloud.clientserverapi.server.client.connectedclient.IConnectedClient;
import eu.thesimplecloud.clientserverapi.server.client.connectedclient.IConnectedClientValue;
import eu.thesimplecloud.launcher.startup.Launcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.concurrent.ThreadsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007H\u0002J\u0010\u0010\u000b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007H\u0002J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u000fH\u0002J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\n\u001a\u00020\u0007H\u0002J\u0010\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0007H\u0016J\b\u0010\u0016\u001a\u00020\tH\u0002J\u0010\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u001e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00070\u001b2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\rH\u0016J\u0006\u0010\u001d\u001a\u00020\tJ\b\u0010\u001e\u001a\u00020\tH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Leu/thesimplecloud/base/manager/service/ServiceHandler;", "Leu/thesimplecloud/base/manager/service/IServiceHandler;", "()V", "serviceMinimumCountCalculator", "Leu/thesimplecloud/base/manager/service/ServiceMinimumCountCalculator;", "serviceQueue", "", "Leu/thesimplecloud/api/service/ICloudService;", "addServiceToQueue", "", "service", "executeStart", "getMinimumServiceCount", "", "group", "Leu/thesimplecloud/api/servicegroup/ICloudServiceGroup;", "getNumberForNewService", "cloudServiceGroup", "getWrapperForService", "Leu/thesimplecloud/api/wrapper/IWrapperInfo;", "removeServiceFromQueue", "cloudService", "startMinServices", "startService", "startConfiguration", "Leu/thesimplecloud/api/service/start/configuration/IServiceStartConfiguration;", "startServicesByGroup", "", "count", "startThread", "stopRedundantServices", "simplecloud-base"})
public final class ServiceHandler
implements IServiceHandler {
    private final ServiceMinimumCountCalculator serviceMinimumCountCalculator = new ServiceMinimumCountCalculator();
    private List<ICloudService> serviceQueue = new ArrayList();

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<ICloudService> startServicesByGroup(@NotNull ICloudServiceGroup cloudServiceGroup, int count) {
        Intrinsics.checkNotNullParameter((Object)cloudServiceGroup, (String)"cloudServiceGroup");
        boolean bl = count >= 1;
        int n = 0;
        int n2 = 0;
        if (!bl) {
            boolean bl2 = false;
            String string = "Count must be positive";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        ArrayList<ICloudService> list = new ArrayList<ICloudService>();
        n = 0;
        n2 = count;
        while (n < n2) {
            void i;
            list.add(this.startService((IServiceStartConfiguration)new ServiceStartConfiguration(cloudServiceGroup)));
            ++i;
        }
        return list;
    }

    @Override
    @NotNull
    public ICloudService startService(@NotNull IServiceStartConfiguration startConfiguration) {
        Intrinsics.checkNotNullParameter((Object)startConfiguration, (String)"startConfiguration");
        ServiceStartConfiguration cfr_ignored_0 = (ServiceStartConfiguration)startConfiguration;
        ICloudServiceGroup cloudServiceGroup = startConfiguration.getServiceGroup();
        Integer n = ((ServiceStartConfiguration)startConfiguration).getServiceNumber();
        int serviceNumber = n != null ? n.intValue() : this.getNumberForNewService(cloudServiceGroup);
        String serviceName = cloudServiceGroup.getName() + "-" + serviceNumber;
        ICloudService runningService = CloudAPI.Companion.getInstance().getCloudServiceManager().getCloudServiceByName(serviceName);
        if (runningService != null) {
            throw (Throwable)new IllegalArgumentException("Service to start (" + serviceName + ") is already registered");
        }
        String string = cloudServiceGroup.getName();
        UUID uUID = UUID.randomUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"UUID.randomUUID()");
        DefaultCloudService service = new DefaultCloudService(string, serviceNumber, uUID, ((ServiceStartConfiguration)startConfiguration).getTemplate(), cloudServiceGroup.getWrapperName(), -1, ((ServiceStartConfiguration)startConfiguration).getMaxMemory(), ((ServiceStartConfiguration)startConfiguration).getMaxPlayers(), "Cloud-Service", cloudServiceGroup.getServiceVersion());
        ICacheList.DefaultImpls.update$default((ICacheList)((ICacheList)CloudAPI.Companion.getInstance().getCloudServiceManager()), (Object)service, (boolean)false, (boolean)false, (int)6, null).awaitUninterruptibly();
        this.addServiceToQueue((ICloudService)service);
        return (ICloudService)service;
    }

    @Override
    public void removeServiceFromQueue(@NotNull ICloudService cloudService) {
        Intrinsics.checkNotNullParameter((Object)cloudService, (String)"cloudService");
        this.serviceQueue.remove(cloudService);
    }

    private final void addServiceToQueue(ICloudService service) {
        if (this.serviceQueue.contains(service)) {
            return;
        }
        this.serviceQueue.add(service);
        Launcher.Companion.getInstance().getConsoleSender().sendProperty("manager.service.queued", new String[]{service.getName()});
    }

    private final int getNumberForNewService(ICloudServiceGroup cloudServiceGroup) {
        int number = 1;
        while (CloudAPI.Companion.getInstance().getCloudServiceManager().getCloudServiceByName(cloudServiceGroup.getName() + "-" + number) != null) {
            ++number;
        }
        return number;
    }

    /*
     * WARNING - void declaration
     */
    private final void startMinServices() {
        for (ICloudServiceGroup serviceGroup : CloudAPI.Companion.getInstance().getCloudServiceGroupManager().getAllCachedObjects()) {
            void $this$filterTo$iv$iv;
            void $this$filterTo$iv$iv2;
            List allServices = serviceGroup.getAllServices();
            Iterable $this$filter$iv = allServices;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Iterable destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                ICloudService it = (ICloudService)element$iv$iv;
                boolean bl = false;
                if (!(it.getState() != ServiceState.INVISIBLE)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List inLobbyServices = (List)destination$iv$iv;
            Iterable $this$filter$iv2 = inLobbyServices;
            boolean $i$f$filter2 = false;
            destination$iv$iv = $this$filter$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                ICloudService it = (ICloudService)element$iv$iv;
                boolean bl = false;
                if (!(it.getOnlinePercentage() < (double)serviceGroup.getPercentToStartNewService() / (double)100)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List inLobbyServicesWithFewPlayers = (List)destination$iv$iv2;
            int minimumServiceCount = this.getMinimumServiceCount(serviceGroup);
            int newServicesAmount = minimumServiceCount - inLobbyServicesWithFewPlayers.size();
            if (serviceGroup.getMaximumOnlineServiceCount() != -1 && newServicesAmount + inLobbyServices.size() > serviceGroup.getMaximumOnlineServiceCount()) {
                newServicesAmount = serviceGroup.getMaximumOnlineServiceCount() - inLobbyServices.size();
            }
            if (newServicesAmount <= 0) continue;
            this.startServicesByGroup(serviceGroup, newServicesAmount);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void stopRedundantServices() {
        for (ICloudServiceGroup serviceGroup : CloudAPI.Companion.getInstance().getCloudServiceGroupManager().getAllCachedObjects()) {
            void $this$filterTo$iv$iv3;
            ICloudService it;
            Iterable $this$filterTo$iv$iv2;
            List allServices = serviceGroup.getAllServices();
            Iterable $this$filter$iv = allServices;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Iterable destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                it = (ICloudService)element$iv$iv;
                boolean bl = false;
                if (!(it.getState() == ServiceState.VISIBLE)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$filter = false;
            $this$filterTo$iv$iv2 = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                it = (ICloudService)element$iv$iv;
                boolean bl = false;
                if (!(it.getOnlinePercentage() * (double)100 < (double)serviceGroup.getPercentToStartNewService())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$filter = false;
            $this$filterTo$iv$iv2 = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                it = (ICloudService)element$iv$iv;
                boolean bl = false;
                if (!it.getLastPlayerUpdate().hasTimePassed(TimeUnit.MINUTES.toMillis(3L))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List redundantServices = (List)destination$iv$iv;
            Iterable $this$filter$iv2 = redundantServices;
            boolean $i$f$filter2 = false;
            destination$iv$iv = $this$filter$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            int $i$f$filterTo2 = 0;
            for (Object element$iv$iv : $this$filterTo$iv$iv3) {
                ICloudService it2 = (ICloudService)element$iv$iv;
                boolean bl = false;
                if (!(it2.getOnlineCount() <= 0)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List stoppableServices = (List)destination$iv$iv2;
            int minimumServiceCount = this.getMinimumServiceCount(serviceGroup);
            if (redundantServices.size() <= minimumServiceCount) continue;
            int amountToStop = redundantServices.size() - minimumServiceCount;
            int $this$filterTo$iv$iv3 = 0;
            $i$f$filterTo2 = stoppableServices.size();
            boolean bl = false;
            int n = Math.min(amountToStop, $i$f$filterTo2);
            while ($this$filterTo$iv$iv3 < n) {
                void i;
                ICloudService service = (ICloudService)stoppableServices.get((int)i);
                service.setState(ServiceState.INVISIBLE);
                service.update().awaitUninterruptibly();
                service.shutdown();
                ++i;
            }
        }
    }

    public final void startThread() {
        ThreadsKt.thread$default((boolean)true, (boolean)true, null, null, (int)0, (Function0)((Function0)new Function0<Unit>(this){
            final /* synthetic */ ServiceHandler this$0;

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                while (true) {
                    void $this$groupByTo$iv$iv;
                    Iterable $this$sortedByDescending$iv = ServiceHandler.access$getServiceQueue$p(this.this$0);
                    boolean $i$f$sortedByDescending = false;
                    boolean bl = false;
                    ServiceHandler.access$setServiceQueue$p(this.this$0, CollectionsKt.toMutableList((Collection)CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator<T>(){

                        public final int compare(T a, T b) {
                            boolean bl = false;
                            ICloudService it = (ICloudService)b;
                            boolean bl2 = false;
                            Comparable comparable = Integer.valueOf(it.getServiceGroup().getStartPriority());
                            it = (ICloudService)a;
                            Comparable comparable2 = comparable;
                            bl2 = false;
                            Integer n = it.getServiceGroup().getStartPriority();
                            return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
                        }
                    })));
                    ServiceHandler.access$startMinServices(this.this$0);
                    ServiceHandler.access$stopRedundantServices(this.this$0);
                    Iterable $this$groupBy$iv = ServiceHandler.access$getServiceQueue$p(this.this$0);
                    int $i$f$groupBy = 0;
                    Iterable iterable = $this$groupBy$iv;
                    Map destination$iv$iv = new LinkedHashMap<K, V>();
                    boolean $i$f$groupByTo = false;
                    for (T element$iv$iv : $this$groupByTo$iv$iv) {
                        Object object;
                        ICloudService it = (ICloudService)element$iv$iv;
                        boolean bl2 = false;
                        Integer key$iv$iv = it.getServiceGroup().getStartPriority();
                        Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                        boolean $i$f$getOrPut = false;
                        V value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                        if (value$iv$iv$iv == null) {
                            boolean bl3 = false;
                            List answer$iv$iv$iv = new ArrayList<E>();
                            $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                            object = answer$iv$iv$iv;
                        } else {
                            object = value$iv$iv$iv;
                        }
                        List list$iv$iv = (List)object;
                        list$iv$iv.add(element$iv$iv);
                    }
                    Map priorityToServices = destination$iv$iv;
                    Integer maxPriority = (Integer)CollectionsKt.maxOrNull((Iterable)priorityToServices.keySet());
                    if (maxPriority != null) {
                        $i$f$groupBy = maxPriority;
                        boolean bl4 = false;
                        while ($i$f$groupBy >= 0) {
                            void priority;
                            List list = (List)priorityToServices.get((int)priority);
                            if (list == null) {
                                list = CollectionsKt.emptyList();
                            }
                            List services = list;
                            Iterable $this$sortedBy$iv = services;
                            boolean $i$f$sortedBy = false;
                            boolean bl5 = false;
                            List sortedServices = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

                                public final int compare(T a, T b) {
                                    boolean bl = false;
                                    ICloudService it = (ICloudService)a;
                                    boolean bl2 = false;
                                    boolean bl3 = it.getWrapperName() == null;
                                    it = (ICloudService)b;
                                    Comparable comparable = Boolean.valueOf(bl3);
                                    bl2 = false;
                                    Boolean bl4 = it.getWrapperName() == null;
                                    return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)bl4);
                                }
                            });
                            for (ICloudService service : sortedServices) {
                                ServiceHandler.access$executeStart(this.this$0, service);
                            }
                            --priority;
                        }
                    }
                    Thread.sleep(300L);
                }
            }
            {
                this.this$0 = serviceHandler;
                super(0);
            }
        }), (int)28, null);
    }

    private final void executeStart(ICloudService service) {
        IWrapperInfo iWrapperInfo = this.getWrapperForService(service);
        if (iWrapperInfo == null) {
            return;
        }
        IWrapperInfo wrapper = iWrapperInfo;
        IConnectedClient wrapperClient = Manager.Companion.getInstance().getCommunicationServer().getClientManager().getClientByClientValue((IConnectedClientValue)wrapper);
        if (wrapperClient == null) {
            return;
        }
        ICloudService iCloudService = service;
        if (iCloudService == null) {
            throw new NullPointerException("null cannot be cast to non-null type eu.thesimplecloud.api.service.impl.DefaultCloudService");
        }
        DefaultCloudService cfr_ignored_0 = (DefaultCloudService)iCloudService;
        ((DefaultCloudService)service).setWrapperName(wrapper.getName());
        service.setLastPlayerUpdate(new Timestamp(0L, 1, null));
        service.update().awaitUninterruptibly();
        IPacketSender.DefaultImpls.sendUnitQuery$default((IPacketSender)((IPacketSender)wrapperClient), (IPacket)((IPacket)new PacketIOWrapperStartService(service.getName())), (long)0L, (int)2, null).awaitUninterruptibly();
        Launcher.Companion.getInstance().getConsoleSender().sendProperty("manager.service.start", new String[]{wrapper.getName(), service.getName()});
        this.serviceQueue.remove(service);
    }

    private final IWrapperInfo getWrapperForService(ICloudService service) {
        if (service.getWrapperName() == null) {
            return CloudAPI.Companion.getInstance().getWrapperManager().getWrapperByUnusedMemory(service.getMaxMemory());
        }
        IWrapperManager iWrapperManager = CloudAPI.Companion.getInstance().getWrapperManager();
        String string = service.getWrapperName();
        Intrinsics.checkNotNull((Object)string);
        IWrapperInfo iWrapperInfo = iWrapperManager.getWrapperByName(string);
        if (iWrapperInfo == null) {
            return null;
        }
        IWrapperInfo requiredWrapper = iWrapperInfo;
        if (requiredWrapper.hasEnoughMemory(service.getMaxMemory()) && requiredWrapper.isAuthenticated() && requiredWrapper.hasTemplatesReceived() && requiredWrapper.getCurrentlyStartingServices() != requiredWrapper.getMaxSimultaneouslyStartingServices()) {
            return requiredWrapper;
        }
        return null;
    }

    public final int getMinimumServiceCount(@NotNull ICloudServiceGroup group) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        int n = group.getMinimumOnlineServiceCount();
        int n2 = this.serviceMinimumCountCalculator.getCalculatedMinimumServiceCount(group);
        boolean bl = false;
        return Math.max(n, n2);
    }

    public static final /* synthetic */ List access$getServiceQueue$p(ServiceHandler $this) {
        return $this.serviceQueue;
    }

    public static final /* synthetic */ void access$setServiceQueue$p(ServiceHandler $this, List list) {
        $this.serviceQueue = list;
    }

    public static final /* synthetic */ void access$startMinServices(ServiceHandler $this) {
        $this.startMinServices();
    }

    public static final /* synthetic */ void access$stopRedundantServices(ServiceHandler $this) {
        $this.stopRedundantServices();
    }

    public static final /* synthetic */ void access$executeStart(ServiceHandler $this, ICloudService service) {
        $this.executeStart(service);
    }
}

