/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.base.manager.setup;

import eu.thesimplecloud.api.CloudAPI;
import eu.thesimplecloud.api.cachelist.ICacheList;
import eu.thesimplecloud.api.wrapper.impl.DefaultWrapperInfo;
import eu.thesimplecloud.launcher.console.ConsoleSender;
import eu.thesimplecloud.launcher.console.setup.ISetup;
import eu.thesimplecloud.launcher.console.setup.annotations.SetupFinished;
import eu.thesimplecloud.launcher.console.setup.annotations.SetupQuestion;
import eu.thesimplecloud.launcher.startup.Launcher;
import eu.thesimplecloud.launcher.utils.IpValidator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\nH\u0007J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0003\u001a\u00020\u0004H\u0007J\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\u0006H\u0007J\u0010\u0010\u000e\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\u0004H\u0007J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Leu/thesimplecloud/base/manager/setup/WrapperSetup;", "Leu/thesimplecloud/launcher/console/setup/ISetup;", "()V", "host", "", "maxSimultaneouslyStartingServices", "", "memory", "name", "finished", "", "hostSetup", "", "memorySetup", "nameSetup", "simultaneouslySetup", "simplecloud-base"})
public final class WrapperSetup
implements ISetup {
    private int maxSimultaneouslyStartingServices;
    private int memory;
    private String host;
    private String name;

    @SetupQuestion(number=0, property="manager.setup.wrapper.question.name")
    public final boolean nameSetup(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (name.length() > 16) {
            Launcher.Companion.getInstance().getConsoleSender().sendPropertyInSetup("manager.setup.wrapper.question.name.too-long", new String[0]);
            return false;
        }
        this.name = name;
        Launcher.Companion.getInstance().getConsoleSender().sendPropertyInSetup("manager.setup.wrapper.question.name.success", new String[0]);
        return true;
    }

    @SetupQuestion(number=1, property="manager.setup.wrapper.question.host")
    public final boolean hostSetup(@NotNull String host) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        if (StringsKt.equals((String)host, (String)"this", (boolean)true)) {
            this.host = Launcher.Companion.getInstance().getLauncherConfig().getHost();
            Launcher.Companion.getInstance().getConsoleSender().sendPropertyInSetup("manager.setup.wrapper.question.host.success", new String[0]);
            return true;
        }
        if (!new IpValidator().validate(host)) {
            Launcher.Companion.getInstance().getConsoleSender().sendPropertyInSetup("manager.setup.wrapper.question.host.invalid", new String[0]);
            return false;
        }
        this.host = host;
        Launcher.Companion.getInstance().getConsoleSender().sendPropertyInSetup("manager.setup.wrapper.question.host.success", new String[0]);
        return true;
    }

    @SetupQuestion(number=2, property="manager.setup.wrapper.question.memory")
    public final boolean memorySetup(int memory) {
        if (memory < 1024) {
            Launcher.Companion.getInstance().getConsoleSender().sendPropertyInSetup("manager.setup.wrapper.question.memory.too-low", new String[0]);
            return false;
        }
        this.memory = memory;
        Launcher.Companion.getInstance().getConsoleSender().sendPropertyInSetup("manager.setup.wrapper.question.memory.success", new String[0]);
        return true;
    }

    @SetupQuestion(number=3, property="manager.setup.wrapper.question.start-services")
    public final boolean simultaneouslySetup(int maxSimultaneouslyStartingServices) {
        if (maxSimultaneouslyStartingServices < 1) {
            Launcher.Companion.getInstance().getConsoleSender().sendPropertyInSetup("manager.setup.wrapper.question.start-services.too-low", new String[0]);
            return false;
        }
        this.maxSimultaneouslyStartingServices = maxSimultaneouslyStartingServices;
        Launcher.Companion.getInstance().getConsoleSender().sendPropertyInSetup("manager.setup.wrapper.question.start-services.success", new String[0]);
        return true;
    }

    @SetupFinished
    public final void finished() {
        String string = this.name;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"name");
        }
        String string2 = this.host;
        if (string2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"host");
        }
        DefaultWrapperInfo wrapperInfo = new DefaultWrapperInfo(string, string2, this.maxSimultaneouslyStartingServices, this.memory);
        ICacheList.DefaultImpls.update$default((ICacheList)((ICacheList)CloudAPI.Companion.getInstance().getWrapperManager()), (Object)wrapperInfo, (boolean)false, (boolean)false, (int)6, null);
        ConsoleSender consoleSender = Launcher.Companion.getInstance().getConsoleSender();
        String[] stringArray = new String[1];
        String string3 = this.name;
        if (string3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"name");
        }
        stringArray[0] = string3;
        consoleSender.sendPropertyInSetup("manager.setup.wrapper.finished", stringArray);
    }
}

