/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.base.manager.update.converter;

import eu.thesimplecloud.api.directorypaths.DirectoryPaths;
import eu.thesimplecloud.base.manager.update.converter.IVersionConverter;
import eu.thesimplecloud.base.manager.update.converter.converter_1_2_to_1_3.Converter_1_2_to_1_3;
import eu.thesimplecloud.jsonlib.JsonLib;
import eu.thesimplecloud.launcher.startup.Launcher;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.text.StringsKt;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\b\u001a\u00020\tJ\u0006\u0010\n\u001a\u00020\tJ\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u000f\u001a\u0012\u0012\u0004\u0012\u00020\f0\u0010j\b\u0012\u0004\u0012\u00020\f`\u0011H\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0013H\u0002J\b\u0010\u0016\u001a\u00020\tH\u0002J\u0006\u0010\u0017\u001a\u00020\tR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Leu/thesimplecloud/base/manager/update/converter/VersionConversionManager;", "", "()V", "converters", "", "Leu/thesimplecloud/base/manager/update/converter/converter_1_2_to_1_3/Converter_1_2_to_1_3;", "lastStartedVersionFile", "Ljava/io/File;", "convertBeforeModuleLoad", "", "convertIfNecessary", "getConverterByToVersion", "Leu/thesimplecloud/base/manager/update/converter/IVersionConverter;", "version", "", "getConvertersToExecute", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "getLastStartedVersion", "", "getMinorVersionFromVersionString", "versionString", "writeLastStartedVersion", "writeLastStartedVersionIfFileDoesNotExist", "simplecloud-base"})
public final class VersionConversionManager {
    private final List<Converter_1_2_to_1_3> converters = CollectionsKt.listOf((Object)new Converter_1_2_to_1_3());
    private final File lastStartedVersionFile = new File(DirectoryPaths.Companion.getPaths().getStoragePath() + "versions/lastStartedVersion.json");

    public final void convertBeforeModuleLoad() {
        Iterable $this$forEach$iv = this.getConvertersToExecute();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IVersionConverter version = (IVersionConverter)element$iv;
            boolean bl = false;
            version.convertBeforeModuleLoad();
        }
    }

    public final void convertIfNecessary() {
        String lastStartedVersion = this.getLastStartedVersion();
        String currentVersion = Launcher.Companion.getInstance().getCurrentVersion();
        Iterable $this$forEach$iv = this.getConvertersToExecute();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IVersionConverter version = (IVersionConverter)element$iv;
            boolean bl = false;
            Launcher.Companion.getInstance().getConsoleSender().sendProperty("manager.converting", new String[]{lastStartedVersion, currentVersion});
            version.convertAfterModuleLoad();
            Launcher.Companion.getInstance().getConsoleSender().sendProperty("manager.converted", new String[]{lastStartedVersion, currentVersion});
        }
        this.writeLastStartedVersion();
    }

    /*
     * WARNING - void declaration
     */
    private final ArrayList<IVersionConverter> getConvertersToExecute() {
        String lastStartedVersion = this.getLastStartedVersion();
        String currentVersion = Launcher.Companion.getInstance().getCurrentVersion();
        int lastMinorVersion = this.getMinorVersionFromVersionString(lastStartedVersion);
        int currentMinorVersion = this.getMinorVersionFromVersionString(currentVersion);
        ArrayList<IVersionConverter> list = new ArrayList<IVersionConverter>();
        int n = lastMinorVersion;
        int n2 = currentMinorVersion;
        while (n < n2) {
            void i;
            IVersionConverter version = this.getConverterByToVersion((int)(i + true));
            if (version != null) {
                IVersionConverter iVersionConverter;
                boolean bl = false;
                boolean bl2 = false;
                IVersionConverter it = iVersionConverter;
                boolean bl3 = false;
                list.add(version);
            }
            ++i;
        }
        return list;
    }

    private final IVersionConverter getConverterByToVersion(int version) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = this.converters;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Converter_1_2_to_1_3 it = (Converter_1_2_to_1_3)element$iv;
                boolean bl = false;
                if (!(it.getTargetMinorVersion() == version)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private final int getMinorVersionFromVersionString(String versionString) {
        String string = (String)StringsKt.split$default((CharSequence)versionString, (String[])new String[]{"."}, (boolean)false, (int)0, (int)6, null).get(1);
        boolean bl = false;
        return Integer.parseInt(string);
    }

    private final String getLastStartedVersion() {
        this.lastStartedVersionFile.getParentFile().mkdirs();
        JsonLib jsonLib = JsonLib.Companion.fromJsonFile$default((JsonLib.Companion)JsonLib.Companion, (File)this.lastStartedVersionFile, null, (int)2, null);
        if (jsonLib == null) {
            return "1.2.0-BETA";
        }
        JsonLib config = jsonLib;
        return (String)config.getObject(String.class);
    }

    private final void writeLastStartedVersion() {
        JsonLib.Companion.fromObject((Object)Launcher.Companion.getInstance().getCurrentVersion()).saveAsFile(this.lastStartedVersionFile);
    }

    public final void writeLastStartedVersionIfFileDoesNotExist() {
        if (!this.lastStartedVersionFile.exists()) {
            this.writeLastStartedVersion();
        }
    }
}

