/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.base.wrapper.impl;

import eu.thesimplecloud.api.event.service.CloudServiceConnectedEvent;
import eu.thesimplecloud.api.event.service.CloudServiceUnregisteredEvent;
import eu.thesimplecloud.api.listenerextension.AdvancedListener;
import eu.thesimplecloud.api.network.packets.service.PacketIOCopyService;
import eu.thesimplecloud.api.network.packets.service.PacketIOStopCloudService;
import eu.thesimplecloud.api.service.ICloudService;
import eu.thesimplecloud.api.service.ServiceState;
import eu.thesimplecloud.api.service.impl.AbstractCloudServiceManager;
import eu.thesimplecloud.api.wrapper.IWrapperInfo;
import eu.thesimplecloud.base.wrapper.process.ICloudServiceProcess;
import eu.thesimplecloud.base.wrapper.process.ProcessCopier;
import eu.thesimplecloud.base.wrapper.process.queue.CloudServiceProcessQueue;
import eu.thesimplecloud.base.wrapper.startup.Wrapper;
import eu.thesimplecloud.clientserverapi.lib.packet.IPacket;
import eu.thesimplecloud.clientserverapi.lib.packet.packetsender.IPacketSender;
import eu.thesimplecloud.clientserverapi.lib.promise.CommunicationPromise;
import eu.thesimplecloud.clientserverapi.lib.promise.ICommunicationPromise;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\f"}, d2={"Leu/thesimplecloud/base/wrapper/impl/CloudServiceManagerImpl;", "Leu/thesimplecloud/api/service/impl/AbstractCloudServiceManager;", "()V", "copyService", "Leu/thesimplecloud/clientserverapi/lib/promise/ICommunicationPromise;", "", "cloudService", "Leu/thesimplecloud/api/service/ICloudService;", "path", "", "startService", "stopService", "simplecloud-base"})
public final class CloudServiceManagerImpl
extends AbstractCloudServiceManager {
    @NotNull
    public ICommunicationPromise<Unit> stopService(@NotNull ICloudService cloudService) {
        Intrinsics.checkNotNullParameter((Object)cloudService, (String)"cloudService");
        if (Intrinsics.areEqual((Object)cloudService.getWrapperName(), (Object)Wrapper.Companion.getInstance().getThisWrapperName())) {
            if (cloudService.getState() == ServiceState.PREPARED) {
                CloudServiceProcessQueue cloudServiceProcessQueue = Wrapper.Companion.getInstance().getProcessQueue();
                if (cloudServiceProcessQueue != null) {
                    cloudServiceProcessQueue.removeFromQueue(cloudService);
                }
            } else {
                ICloudServiceProcess cloudServiceProcess;
                ICloudServiceProcess iCloudServiceProcess = cloudServiceProcess = Wrapper.Companion.getInstance().getCloudServiceProcessManager().getCloudServiceProcessByServiceName(cloudService.getName());
                if (iCloudServiceProcess != null) {
                    iCloudServiceProcess.shutdown();
                }
            }
        } else {
            IPacketSender.DefaultImpls.sendUnitQuery$default((IPacketSender)((IPacketSender)Wrapper.Companion.getInstance().getConnectionToManager()), (IPacket)((IPacket)new PacketIOStopCloudService(cloudService.getName())), (long)0L, (int)2, null);
        }
        boolean autoUnregister$iv = true;
        long unregisterTimeInSeconds$iv = 300L;
        boolean $i$f$cloudListener = false;
        return new AdvancedListener(CloudServiceUnregisteredEvent.class, autoUnregister$iv, unregisterTimeInSeconds$iv).addCondition((Function1)new Function1<CloudServiceUnregisteredEvent, Boolean>(cloudService){
            final /* synthetic */ ICloudService $cloudService;

            public final boolean invoke(@NotNull CloudServiceUnregisteredEvent it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return Intrinsics.areEqual((Object)it.getCloudService(), (Object)this.$cloudService);
            }
            {
                this.$cloudService = iCloudService;
                super(1);
            }
        }).toUnitPromise();
    }

    @NotNull
    public ICommunicationPromise<Unit> copyService(@NotNull ICloudService cloudService, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)cloudService, (String)"cloudService");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        IWrapperInfo selfWrapper = Wrapper.Companion.getInstance().getThisWrapper();
        if (Intrinsics.areEqual((Object)selfWrapper, (Object)cloudService.getWrapper()) ^ true) {
            return Wrapper.Companion.getInstance().getConnectionToManager().sendUnitQuery((IPacket)new PacketIOCopyService(cloudService, path), 20000L);
        }
        ICloudServiceProcess serviceProcess = Wrapper.Companion.getInstance().getCloudServiceProcessManager().getCloudServiceProcessByServiceName(cloudService.getName());
        if (serviceProcess == null) {
            return CommunicationPromise.Companion.failed((Throwable)new IllegalStateException("Cannot copy inactive service"));
        }
        return new ProcessCopier(cloudService).copy(path);
    }

    @NotNull
    public ICommunicationPromise<Unit> startService(@NotNull ICloudService cloudService) {
        Intrinsics.checkNotNullParameter((Object)cloudService, (String)"cloudService");
        CloudServiceProcessQueue processQueue = Wrapper.Companion.getInstance().getProcessQueue();
        boolean bl = false;
        boolean bl2 = false;
        if (processQueue == null) {
            boolean bl3 = false;
            String string = "Process-Queue was null while trying to add a service to the queue.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        processQueue.addToQueue(cloudService);
        boolean autoUnregister$iv = true;
        long unregisterTimeInSeconds$iv = 300L;
        boolean $i$f$cloudListener = false;
        return new AdvancedListener(CloudServiceConnectedEvent.class, autoUnregister$iv, unregisterTimeInSeconds$iv).addCondition((Function1)new Function1<CloudServiceConnectedEvent, Boolean>(cloudService){
            final /* synthetic */ ICloudService $cloudService;

            public final boolean invoke(@NotNull CloudServiceConnectedEvent it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return Intrinsics.areEqual((Object)it.getCloudService(), (Object)this.$cloudService);
            }
            {
                this.$cloudService = iCloudService;
                super(1);
            }
        }).toUnitPromise();
    }
}

