/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.base.wrapper.process;

import eu.thesimplecloud.api.CloudAPI;
import eu.thesimplecloud.api.cachelist.ICacheList;
import eu.thesimplecloud.api.client.NetworkComponentType;
import eu.thesimplecloud.api.event.service.CloudServiceUnregisteredEvent;
import eu.thesimplecloud.api.listenerextension.AdvancedListener;
import eu.thesimplecloud.api.screen.ICommandExecutable;
import eu.thesimplecloud.api.service.ICloudService;
import eu.thesimplecloud.api.service.ServiceState;
import eu.thesimplecloud.api.service.impl.DefaultCloudService;
import eu.thesimplecloud.api.servicegroup.ICloudServiceGroup;
import eu.thesimplecloud.api.servicegroup.grouptype.ICloudProxyGroup;
import eu.thesimplecloud.api.utils.ManifestLoader;
import eu.thesimplecloud.base.core.jvm.JvmArgument;
import eu.thesimplecloud.base.wrapper.process.ICloudServiceProcess;
import eu.thesimplecloud.base.wrapper.process.filehandler.ServiceDirectory;
import eu.thesimplecloud.base.wrapper.process.serviceconfigurator.IServiceConfigurator;
import eu.thesimplecloud.base.wrapper.startup.PortManager;
import eu.thesimplecloud.base.wrapper.startup.Wrapper;
import eu.thesimplecloud.client.packets.PacketOutScreenMessage;
import eu.thesimplecloud.clientserverapi.lib.packet.IPacket;
import eu.thesimplecloud.clientserverapi.lib.packet.packetsender.IPacketSender;
import eu.thesimplecloud.clientserverapi.lib.promise.CommunicationPromise;
import eu.thesimplecloud.clientserverapi.lib.promise.ICommunicationPromise;
import eu.thesimplecloud.launcher.dependency.DependencyLoader;
import eu.thesimplecloud.launcher.dependency.LauncherCloudDependency;
import eu.thesimplecloud.launcher.startup.Launcher;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u000eH\u0016J\b\u0010\u0013\u001a\u00020\u0003H\u0016J\u001b\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00110\u00152\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a2\u0006\u0002\u0010\u0016J\b\u0010\u0017\u001a\u00020\fH\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u000eH\u0002J\b\u0010\u001b\u001a\u00020\u000eH\u0002J\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001dH\u0016J\u000e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001dH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Leu/thesimplecloud/base/wrapper/process/CloudServiceProcess;", "Leu/thesimplecloud/base/wrapper/process/ICloudServiceProcess;", "cloudService", "Leu/thesimplecloud/api/service/ICloudService;", "(Leu/thesimplecloud/api/service/ICloudService;)V", "process", "Ljava/lang/Process;", "serviceDirectory", "Leu/thesimplecloud/base/wrapper/process/filehandler/ServiceDirectory;", "createProcessBuilder", "Ljava/lang/ProcessBuilder;", "jarFile", "Ljava/io/File;", "deleteTemporaryFiles", "", "executeCommand", "command", "", "forceStop", "getCloudService", "getStartCommandArgs", "", "(Ljava/io/File;)[Ljava/lang/String;", "getTempDirectory", "isActive", "", "printErrorStream", "processStopped", "shutdown", "Leu/thesimplecloud/clientserverapi/lib/promise/ICommunicationPromise;", "start", "simplecloud-base"})
public final class CloudServiceProcess
implements ICloudServiceProcess {
    private Process process;
    private final ServiceDirectory serviceDirectory;
    private final ICloudService cloudService;

    @NotNull
    public ICommunicationPromise<Unit> start() {
        Process process;
        Launcher.Companion.getInstance().getConsoleSender().sendProperty("wrapper.service.starting", new String[]{this.cloudService.getName()});
        ICloudService iCloudService = this.cloudService;
        if (iCloudService == null) {
            throw new NullPointerException("null cannot be cast to non-null type eu.thesimplecloud.api.service.impl.DefaultCloudService");
        }
        DefaultCloudService cfr_ignored_0 = (DefaultCloudService)iCloudService;
        if (this.cloudService.getServiceType().isProxy()) {
            ICloudServiceGroup proxyGroup;
            ICloudServiceGroup iCloudServiceGroup = proxyGroup = this.cloudService.getServiceGroup();
            if (iCloudServiceGroup == null) {
                throw new NullPointerException("null cannot be cast to non-null type eu.thesimplecloud.api.servicegroup.grouptype.ICloudProxyGroup");
            }
            ICloudProxyGroup cfr_ignored_1 = (ICloudProxyGroup)iCloudServiceGroup;
            ((DefaultCloudService)this.cloudService).setPort(Wrapper.Companion.getInstance().getPortManager().getUnusedPort(((ICloudProxyGroup)proxyGroup).getStartPort()));
        } else {
            ((DefaultCloudService)this.cloudService).setPort(PortManager.getUnusedPort$default(Wrapper.Companion.getInstance().getPortManager(), 0, 1, null));
        }
        this.cloudService.setState(ServiceState.STARTING);
        this.cloudService.update().awaitUninterruptibly();
        this.serviceDirectory.copyTemplateFilesAndModules();
        IServiceConfigurator serviceConfigurator = Wrapper.Companion.getInstance().getServiceConfigurationManager().getServiceConfigurator(this.cloudService.getServiceVersion().getServiceAPIType());
        if (serviceConfigurator == null) {
            throw (Throwable)new IllegalStateException("No ServiceConfiguration found by api type: " + this.cloudService.getServiceVersion().getServiceAPIType());
        }
        serviceConfigurator.configureService(this.cloudService, this.serviceDirectory.getServiceTmpDirectory());
        File jarFile = Wrapper.Companion.getInstance().getServiceVersionLoader().loadVersionFile(this.cloudService.getServiceVersion());
        ProcessBuilder processBuilder = this.createProcessBuilder(jarFile).directory(this.serviceDirectory.getServiceTmpDirectory());
        this.process = process = processBuilder.start();
        Process process2 = process;
        Intrinsics.checkNotNullExpressionValue((Object)process2, (String)"process");
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process2.getInputStream()));
        while (process.isAlive()) {
            try {
                String s;
                if (bufferedReader.readLine() == null) {
                    continue;
                }
                if (StringsKt.equals((String)s, (String)"", (boolean)true) || StringsKt.equals((String)s, (String)" ", (boolean)true) || StringsKt.equals((String)s, (String)">", (boolean)true) || StringsKt.equals((String)s, (String)" >", (boolean)true) || StringsKt.contains$default((CharSequence)s, (CharSequence)"InitialHandler has pinged", (boolean)false, (int)2, null)) continue;
                IPacketSender.DefaultImpls.sendUnitQuery$default((IPacketSender)((IPacketSender)Wrapper.Companion.getInstance().getConnectionToManager()), (IPacket)((IPacket)new PacketOutScreenMessage(NetworkComponentType.SERVICE, (ICommandExecutable)this.getCloudService(), s)), (long)0L, (int)2, null);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        bufferedReader.close();
        this.printErrorStream();
        this.processStopped();
        return CommunicationPromise.Companion.of((Object)Unit.INSTANCE);
    }

    private final void printErrorStream() {
        Process process = this.process;
        Intrinsics.checkNotNull((Object)process);
        InputStream errorStream = process.getErrorStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(errorStream));
        while (reader.ready()) {
            String line;
            if (reader.readLine() == null) {
                continue;
            }
            Launcher.Companion.getInstance().getLogger().warning('[' + this.cloudService.getName() + ']' + line);
        }
        reader.close();
    }

    private final void processStopped() {
        Launcher.Companion.getInstance().getConsoleSender().sendProperty("wrapper.service.stopped", new String[]{this.cloudService.getName()});
        Wrapper.Companion.getInstance().getCloudServiceProcessManager().unregisterServiceProcess(this);
        this.deleteTemporaryFiles();
        if (Wrapper.Companion.getInstance().getConnectionToManager().isOpen()) {
            int tries = 0;
            while (this.cloudService.isAuthenticated()) {
                Thread.sleep(100L);
                if (++tries != 30) continue;
                break;
            }
            this.cloudService.setOnlineCount(0);
            this.cloudService.setState(ServiceState.CLOSED);
            ICacheList.DefaultImpls.delete$default((ICacheList)((ICacheList)CloudAPI.Companion.getInstance().getCloudServiceManager()), (Object)this.cloudService, (boolean)false, (int)2, null).awaitUninterruptibly();
            Wrapper.Companion.getInstance().updateWrapperData();
        }
        Wrapper.Companion.getInstance().getPortManager().setPortUnused(this.cloudService.getPort());
    }

    private final void deleteTemporaryFiles() {
        while (true) {
            try {
                if (this.cloudService.isStatic()) {
                    this.serviceDirectory.deleteTemporaryModuleFiles();
                    break;
                }
                this.serviceDirectory.deleteServiceDirectoryUnsafe();
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
    }

    private final ProcessBuilder createProcessBuilder(File jarFile) {
        String[] stringArray = this.getStartCommandArgs(jarFile);
        return new ProcessBuilder(Arrays.copyOf(stringArray, stringArray.length));
    }

    /*
     * WARNING - void declaration
     */
    private final String[] getStartCommandArgs(File jarFile) {
        void $this$filterTo$iv$iv;
        void $this$mapTo$iv$iv;
        Object it;
        Iterable $this$filterTo$iv$iv2;
        Iterable $this$filter$iv = DependencyLoader.Companion.getINSTANCE().getInstalledDependencies();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            it = (LauncherCloudDependency)element$iv$iv;
            boolean bl = false;
            if (!(Intrinsics.areEqual((Object)it.getGroupId(), (Object)"org.slf4j") ^ true)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterTo$iv$iv2 = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            it = (LauncherCloudDependency)element$iv$iv;
            boolean bl = false;
            if (!(Intrinsics.areEqual((Object)it.getGroupId(), (Object)"eu.thesimplecloud.clientserverapi") ^ true)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv2 = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (LauncherCloudDependency)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getDownloadedFile().getAbsolutePath();
            collection.add(string);
        }
        List allDependencyPaths = (List)destination$iv$iv;
        Set classPathValueList = CollectionsKt.union((Iterable)CollectionsKt.listOf((Object)jarFile.getAbsolutePath()), (Iterable)allDependencyPaths);
        String separator = CloudAPI.Companion.getInstance().isWindows() ? ";" : ":";
        String beginAndEnd = CloudAPI.Companion.getInstance().isWindows() ? "\"" : "";
        String classPathValue = beginAndEnd + CollectionsKt.joinToString$default((Iterable)classPathValueList, (CharSequence)separator, null, null, (int)0, null, null, (int)62, null) + beginAndEnd;
        Iterable $this$filter$iv2 = Wrapper.Companion.getInstance().getJvmArgumentsConfig().getJvmArguments();
        boolean $i$f$filter2 = false;
        it = $this$filter$iv2;
        Object destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            JvmArgument it2 = (JvmArgument)element$iv$iv;
            boolean bl = false;
            if (!(it2.getGroups().contains("all") || it2.getGroups().contains(this.cloudService.getGroupName()))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List jvmArguments = (List)destination$iv$iv2;
        List commands = CollectionsKt.mutableListOf((Object[])new String[]{"java"});
        Iterable $this$forEach$iv = jvmArguments;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JvmArgument it3 = (JvmArgument)element$iv;
            boolean bl = false;
            commands.addAll((Collection)it3.getArguments());
        }
        ArrayList startArguments = CollectionsKt.arrayListOf((Object[])new String[]{"-Dcom.mojang.eula.agree=true", "-Djline.terminal=jline.UnsupportedTerminal", "-Xms" + this.cloudService.getMaxMemory() + "M", "-Xmx" + this.cloudService.getMaxMemory() + "M", "-cp", classPathValue, ManifestLoader.Companion.getMainClassFromManifestFile(jarFile)});
        commands.addAll(startArguments);
        destination$iv$iv2 = this.cloudService.getServiceVersion().getName();
        boolean element$iv = false;
        Object object = destination$iv$iv2;
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string = ((String)object).toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"(this as java.lang.String).toLowerCase()");
        String lowerCaseName = string;
        if (StringsKt.contains$default((CharSequence)lowerCaseName, (CharSequence)"spigot", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)lowerCaseName, (CharSequence)"paper", (boolean)false, (int)2, null)) {
            commands.add("nogui");
        }
        Collection $this$toTypedArray$iv = commands;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return stringArray;
    }

    @Override
    public void forceStop() {
        block0: {
            Process process = this.process;
            if (process == null) break block0;
            process.destroyForcibly();
        }
    }

    @Override
    @NotNull
    public File getTempDirectory() {
        return this.serviceDirectory.getServiceTmpDirectory();
    }

    public boolean isActive() {
        Process process = this.process;
        return process != null ? process.isAlive() : false;
    }

    @NotNull
    public ICommunicationPromise<Unit> shutdown() {
        if (this.isActive()) {
            if (this.cloudService.getServiceType().isProxy()) {
                this.executeCommand("end");
            } else {
                this.executeCommand("stop");
            }
            Launcher.Companion.getInstance().getScheduler().schedule(new Runnable(this){
                final /* synthetic */ CloudServiceProcess this$0;

                public final void run() {
                    if (this.this$0.isActive()) {
                        this.this$0.forceStop();
                    }
                }
                {
                    this.this$0 = cloudServiceProcess;
                }
            }, 7L, TimeUnit.SECONDS);
        }
        boolean autoUnregister$iv = true;
        long unregisterTimeInSeconds$iv = 300L;
        boolean $i$f$cloudListener = false;
        return new AdvancedListener(CloudServiceUnregisteredEvent.class, autoUnregister$iv, unregisterTimeInSeconds$iv).addCondition((Function1)new Function1<CloudServiceUnregisteredEvent, Boolean>(this){
            final /* synthetic */ CloudServiceProcess this$0;

            public final boolean invoke(@NotNull CloudServiceUnregisteredEvent it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return Intrinsics.areEqual((Object)it.getCloudService(), (Object)CloudServiceProcess.access$getCloudService$p(this.this$0));
            }
            {
                this.this$0 = cloudServiceProcess;
                super(1);
            }
        }).toUnitPromise();
    }

    @Override
    public void executeCommand(@NotNull String command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        String command2 = command + "\n";
        try {
            if (this.process != null) {
                Process process = this.process;
                if ((process != null ? process.getOutputStream() : null) != null) {
                    Object object;
                    Object object2 = this.process;
                    if (object2 != null && (object2 = ((Process)object2).getOutputStream()) != null) {
                        String string = command2;
                        Charset charset = Charsets.UTF_8;
                        boolean bl = false;
                        String string2 = string;
                        if (string2 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                        }
                        byte[] byArray = string2.getBytes(charset);
                        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                        ((OutputStream)object2).write(byArray);
                    }
                    if ((object = this.process) != null && (object = ((Process)object).getOutputStream()) != null) {
                        ((OutputStream)object).flush();
                    }
                }
            }
        }
        catch (IOException e) {
            Launcher.Companion.getInstance().getLogger().warning("[" + this.cloudService.getName() + "]" + " Outputstream is closed.");
        }
    }

    @Override
    @NotNull
    public ICloudService getCloudService() {
        return this.cloudService;
    }

    public CloudServiceProcess(@NotNull ICloudService cloudService) {
        Intrinsics.checkNotNullParameter((Object)cloudService, (String)"cloudService");
        this.cloudService = cloudService;
        this.serviceDirectory = new ServiceDirectory(this.cloudService);
    }

    public static final /* synthetic */ ICloudService access$getCloudService$p(CloudServiceProcess $this) {
        return $this.cloudService;
    }
}

