/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.base.wrapper.process;

import eu.thesimplecloud.api.directorypaths.DirectoryPaths;
import eu.thesimplecloud.api.service.ICloudService;
import eu.thesimplecloud.api.utils.FileFinder;
import eu.thesimplecloud.base.wrapper.process.ICloudServiceProcess;
import eu.thesimplecloud.base.wrapper.startup.Wrapper;
import eu.thesimplecloud.clientserverapi.lib.connection.IConnection;
import eu.thesimplecloud.clientserverapi.lib.defaultpackets.PacketIODeleteFile;
import eu.thesimplecloud.clientserverapi.lib.defaultpackets.PacketIOUnzipZipFile;
import eu.thesimplecloud.clientserverapi.lib.packet.IPacket;
import eu.thesimplecloud.clientserverapi.lib.packet.packetsender.IPacketSender;
import eu.thesimplecloud.clientserverapi.lib.promise.CommunicationPromise;
import eu.thesimplecloud.clientserverapi.lib.promise.CommunicationPromiseExtensionKt;
import eu.thesimplecloud.clientserverapi.lib.promise.ICommunicationPromise;
import eu.thesimplecloud.clientserverapi.lib.util.ZipUtils;
import java.io.File;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bJ\u001e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002J\u001e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Leu/thesimplecloud/base/wrapper/process/ProcessCopier;", "", "cloudService", "Leu/thesimplecloud/api/service/ICloudService;", "(Leu/thesimplecloud/api/service/ICloudService;)V", "getCloudService", "()Leu/thesimplecloud/api/service/ICloudService;", "copy", "Leu/thesimplecloud/clientserverapi/lib/promise/ICommunicationPromise;", "", "path", "", "copyUsingFiles", "dirToCopy", "Ljava/io/File;", "tempDirectory", "copyUsingNetty", "simplecloud-base"})
public final class ProcessCopier {
    @NotNull
    private final ICloudService cloudService;

    @NotNull
    public final ICommunicationPromise<Unit> copy(@NotNull String path) {
        File dirToCopy;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        ICloudServiceProcess serviceProcess = Wrapper.Companion.getInstance().getCloudServiceProcessManager().getCloudServiceProcessByServiceName(this.cloudService.getName());
        if (serviceProcess == null) {
            return CommunicationPromise.Companion.failed((Throwable)new IllegalStateException("Cannot copy inactive service"));
        }
        File tempDirectory = serviceProcess.getTempDirectory();
        File file = dirToCopy = Intrinsics.areEqual((Object)path, (Object)".") ? tempDirectory : new File(tempDirectory, path);
        if (!dirToCopy.exists()) {
            return CommunicationPromise.Companion.failed((Throwable)new IllegalArgumentException("Directory does not exist"));
        }
        if (!dirToCopy.isDirectory()) {
            return CommunicationPromise.Companion.failed((Throwable)new IllegalArgumentException("The specified file must be a directory"));
        }
        return Wrapper.Companion.getInstance().isStartedInManagerDirectory() ? this.copyUsingFiles(dirToCopy, tempDirectory) : this.copyUsingNetty(dirToCopy, tempDirectory);
    }

    private final ICommunicationPromise<Unit> copyUsingNetty(File dirToCopy, File tempDirectory) {
        File zippedTemplatesDir = new File(DirectoryPaths.Companion.getPaths().getZippedTemplatesPath());
        File zipFile = new File(zippedTemplatesDir, this.cloudService.getName() + ".zip");
        zipFile.getParentFile().mkdirs();
        ZipUtils.Companion.zipFiles(zipFile, FileFinder.INSTANCE.getAllFiles(dirToCopy), tempDirectory.getPath() + "/");
        String savePath = DirectoryPaths.Companion.getPaths().getZippedTemplatesPath() + "T-" + this.cloudService.getName() + ".zip";
        String dirToUnzip = this.cloudService.getTemplate().getDirectory().getPath();
        return CommunicationPromiseExtensionKt.flatten$default((ICommunicationPromise)CommunicationPromiseExtensionKt.flatten$default((ICommunicationPromise)Wrapper.Companion.getInstance().getConnectionToManager().sendFile(zipFile, savePath, 20000L).thenDelayed(1200L, TimeUnit.MILLISECONDS, (Function1)new Function1<Unit, ICommunicationPromise<? extends Unit>>(dirToCopy, tempDirectory, dirToUnzip){
            final /* synthetic */ File $dirToCopy;
            final /* synthetic */ File $tempDirectory;
            final /* synthetic */ String $dirToUnzip;

            @Nullable
            public final ICommunicationPromise<Unit> invoke(@NotNull Unit it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                String string = this.$dirToCopy.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"dirToCopy.path");
                String string2 = this.$tempDirectory.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"tempDirectory.path");
                String relativePathInTemplate = StringsKt.replace$default((String)string, (String)string2, (String)"", (boolean)false, (int)4, null);
                String dirToReplace = this.$dirToUnzip + (Intrinsics.areEqual((Object)relativePathInTemplate, (Object)"/.") ? "" : relativePathInTemplate);
                return IPacketSender.DefaultImpls.sendUnitQuery$default((IPacketSender)((IPacketSender)Wrapper.Companion.getInstance().getConnectionToManager()), (IPacket)((IPacket)new PacketIODeleteFile(dirToReplace)), (long)0L, (int)2, null);
            }
            {
                this.$dirToCopy = file;
                this.$tempDirectory = file2;
                this.$dirToUnzip = string;
                super(1);
            }
        }), (long)10000L, (boolean)false, (int)2, null).thenDelayed(1000L, TimeUnit.MILLISECONDS, (Function1)new Function1<Unit, ICommunicationPromise<? extends Unit>>(savePath, dirToUnzip){
            final /* synthetic */ String $savePath;
            final /* synthetic */ String $dirToUnzip;

            @Nullable
            public final ICommunicationPromise<Unit> invoke(@NotNull Unit it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                IConnection iConnection = Wrapper.Companion.getInstance().getConnectionToManager();
                String string = this.$dirToUnzip;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"dirToUnzip");
                return iConnection.sendUnitQuery((IPacket)new PacketIOUnzipZipFile(this.$savePath, string), 10000L);
            }
            {
                this.$savePath = string;
                this.$dirToUnzip = string2;
                super(1);
            }
        }), (long)0L, (boolean)false, (int)3, null).throwFailure();
    }

    private final ICommunicationPromise<Unit> copyUsingFiles(File dirToCopy, File tempDirectory) {
        File templateDir = this.cloudService.getTemplate().getDirectory();
        String string = dirToCopy.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"dirToCopy.path");
        String string2 = tempDirectory.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"tempDirectory.path");
        String relativePathInTemplate = StringsKt.replace$default((String)string, (String)string2, (String)"", (boolean)false, (int)4, null);
        File dirToCopyTo = new File(templateDir, relativePathInTemplate);
        FileUtils.copyDirectory((File)dirToCopy, (File)dirToCopyTo);
        return CommunicationPromise.Companion.of((Object)Unit.INSTANCE);
    }

    @NotNull
    public final ICloudService getCloudService() {
        return this.cloudService;
    }

    public ProcessCopier(@NotNull ICloudService cloudService) {
        Intrinsics.checkNotNullParameter((Object)cloudService, (String)"cloudService");
        this.cloudService = cloudService;
    }
}

