/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.base.wrapper.process.filehandler;

import eu.thesimplecloud.api.CloudAPI;
import eu.thesimplecloud.api.directorypaths.DirectoryPaths;
import eu.thesimplecloud.api.service.ICloudService;
import eu.thesimplecloud.api.service.ServiceType;
import eu.thesimplecloud.api.template.ITemplate;
import eu.thesimplecloud.base.wrapper.process.filehandler.ServiceDirectory;
import eu.thesimplecloud.base.wrapper.startup.Wrapper;
import eu.thesimplecloud.clientserverapi.client.INettyClient;
import eu.thesimplecloud.clientserverapi.client.NettyClient;
import eu.thesimplecloud.jsonlib.JsonLib;
import eu.thesimplecloud.launcher.external.module.LoadedModuleFileContent;
import eu.thesimplecloud.launcher.external.module.ModuleCopyType;
import eu.thesimplecloud.launcher.utils.FileCopier;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010\r\u001a\u00020\fH\u0002J\u0006\u0010\u000e\u001a\u00020\fJ\u0006\u0010\u000f\u001a\u00020\fJ\u0006\u0010\u0010\u001a\u00020\fJ\b\u0010\u0011\u001a\u00020\fH\u0002J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00070\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u0006H\u0002J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\t\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001b"}, d2={"Leu/thesimplecloud/base/wrapper/process/filehandler/ServiceDirectory;", "", "cloudService", "Leu/thesimplecloud/api/service/ICloudService;", "(Leu/thesimplecloud/api/service/ICloudService;)V", "copiedModulesAsPlugins", "", "Ljava/io/File;", "serviceTmpDirectory", "getServiceTmpDirectory", "()Ljava/io/File;", "copyModules", "", "copyTemplateFiles", "copyTemplateFilesAndModules", "deleteServiceDirectoryUnsafe", "deleteTemporaryModuleFiles", "generateServiceFile", "getDirectoriesOfTemplateAndSubTemplates", "", "template", "Leu/thesimplecloud/api/template/ITemplate;", "getModuleFilesInService", "getModulesForService", "Leu/thesimplecloud/launcher/external/module/LoadedModuleFileContent;", "getModulesToCopyOfTemplateAndSubTemplates", "", "simplecloud-base"})
public final class ServiceDirectory {
    private List<? extends File> copiedModulesAsPlugins;
    @NotNull
    private final File serviceTmpDirectory;
    private final ICloudService cloudService;

    @NotNull
    public final File getServiceTmpDirectory() {
        return this.serviceTmpDirectory;
    }

    public final void copyTemplateFilesAndModules() {
        this.copyTemplateFiles();
        this.copyModules();
    }

    public final void deleteTemporaryModuleFiles() {
        Iterable $this$forEach$iv = this.copiedModulesAsPlugins;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it = (File)element$iv;
            boolean bl = false;
            it.delete();
        }
    }

    public final void deleteServiceDirectoryUnsafe() throws IOException {
        FileUtils.deleteDirectory((File)this.serviceTmpDirectory);
    }

    /*
     * WARNING - void declaration
     */
    private final void copyTemplateFiles() {
        File destServerIconFile;
        boolean dontCopyTemplates;
        ITemplate template = this.cloudService.getTemplate();
        File everyDir = new File(DirectoryPaths.Companion.getPaths().getTemplatesPath() + "EVERY");
        File everyTypeDir = this.cloudService.getServiceType() == ServiceType.PROXY ? new File(DirectoryPaths.Companion.getPaths().getTemplatesPath() + "EVERY_PROXY") : new File(DirectoryPaths.Companion.getPaths().getTemplatesPath() + "EVERY_SERVER");
        Set<File> templateDirectories = this.getDirectoriesOfTemplateAndSubTemplates(template);
        boolean bl = dontCopyTemplates = this.cloudService.isStatic() && this.serviceTmpDirectory.exists();
        if (!dontCopyTemplates) {
            void $this$filterTo$iv$iv;
            if (everyDir.exists()) {
                FileUtils.copyDirectory((File)everyDir, (File)this.serviceTmpDirectory);
            }
            if (everyTypeDir.exists()) {
                FileUtils.copyDirectory((File)everyTypeDir, (File)this.serviceTmpDirectory);
            }
            Iterable $this$filter$iv = templateDirectories;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                File it = (File)element$iv$iv;
                boolean bl2 = false;
                if (!it.exists()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$forEach$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                File it = (File)element$iv;
                boolean bl3 = false;
                FileUtils.copyDirectory((File)it, (File)this.serviceTmpDirectory);
            }
        }
        if (this.cloudService.getServiceType() == ServiceType.PROXY && !(destServerIconFile = new File(this.serviceTmpDirectory, "/server-icon.png")).exists()) {
            FileCopier.Companion.copyFileOutOfJar(destServerIconFile, "/files/server-icon.png");
        }
        File cloudPluginFile = new File(this.serviceTmpDirectory, "/plugins/SimpleCloud-Plugin.jar");
        FileCopier.Companion.copyFileOutOfJar(cloudPluginFile, "/SimpleCloud-Plugin.jar");
        this.generateServiceFile();
    }

    private final void copyModules() {
        List<LoadedModuleFileContent> modulesForService = this.getModulesForService();
        Iterable $this$forEach$iv = modulesForService;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LoadedModuleFileContent it = (LoadedModuleFileContent)element$iv;
            boolean bl = false;
            FileUtils.copyFile((File)it.getFile(), (File)new File(this.serviceTmpDirectory, "/plugins/" + it.getFile().getName()));
        }
        this.copiedModulesAsPlugins = this.getModuleFilesInService();
    }

    private final File getServiceTmpDirectory(ICloudService cloudService) {
        return cloudService.isStatic() ? new File(DirectoryPaths.Companion.getPaths().getStaticPath() + cloudService.getName()) : new File(DirectoryPaths.Companion.getPaths().getTempPath() + cloudService.getName());
    }

    /*
     * WARNING - void declaration
     */
    private final List<LoadedModuleFileContent> getModulesForService() {
        void $this$filterTo$iv$iv;
        void $this$filterTo$iv$iv2;
        Iterable $this$filter$iv = Wrapper.Companion.getInstance().getExistingModules();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo22 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            LoadedModuleFileContent it = (LoadedModuleFileContent)element$iv$iv;
            boolean bl = false;
            if (!(it.getContent().getModuleCopyType() != ModuleCopyType.NONE)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List modulesByCopyType = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
        if (!this.cloudService.isLobby()) {
            modulesByCopyType.removeIf(getModulesForService.1.INSTANCE);
        }
        if (!this.cloudService.isProxy()) {
            modulesByCopyType.removeIf(getModulesForService.2.INSTANCE);
        }
        if (this.cloudService.isProxy()) {
            modulesByCopyType.removeIf(getModulesForService.3.INSTANCE);
        }
        Set<String> moduleNamesToCopy = this.getModulesToCopyOfTemplateAndSubTemplates(this.cloudService.getTemplate());
        Iterable $this$filter$iv2 = Wrapper.Companion.getInstance().getExistingModules();
        boolean $i$f$filter2 = false;
        Iterable $i$f$filterTo22 = $this$filter$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            LoadedModuleFileContent it = (LoadedModuleFileContent)element$iv$iv;
            boolean bl = false;
            if (!moduleNamesToCopy.contains(it.getContent().getName())) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List modulesByName = (List)destination$iv$iv2;
        Iterable $this$distinctBy$iv = CollectionsKt.union((Iterable)modulesByCopyType, (Iterable)modulesByName);
        boolean $i$f$distinctBy = false;
        HashSet<String> set$iv = new HashSet<String>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            LoadedModuleFileContent it = (LoadedModuleFileContent)e$iv;
            boolean bl = false;
            String key$iv = it.getContent().getName();
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        return list$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<File> getModuleFilesInService() {
        void $this$mapTo$iv$iv;
        List<LoadedModuleFileContent> modulesForService = this.getModulesForService();
        Iterable $this$map$iv = modulesForService;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            LoadedModuleFileContent loadedModuleFileContent = (LoadedModuleFileContent)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            File file = new File(this.serviceTmpDirectory, "/plugins/" + it.getFile().getName());
            collection.add(file);
        }
        return (List)destination$iv$iv;
    }

    private final void generateServiceFile() {
        INettyClient communicationClient;
        INettyClient iNettyClient = communicationClient = Wrapper.Companion.getInstance().getCommunicationClient();
        if (iNettyClient == null) {
            throw new NullPointerException("null cannot be cast to non-null type eu.thesimplecloud.clientserverapi.client.NettyClient");
        }
        NettyClient cfr_ignored_0 = (NettyClient)iNettyClient;
        JsonLib.Companion.empty().append("managerHost", communicationClient.getHost()).append("managerPort", (Number)communicationClient.getPort()).append("serviceName", this.cloudService.getName()).saveAsFile(new File(this.serviceTmpDirectory, "SIMPLE-CLOUD.json"));
    }

    private final Set<File> getDirectoriesOfTemplateAndSubTemplates(ITemplate template) {
        HashSet<File> set = new HashSet<File>();
        for (String templateName : template.getInheritedTemplateNames()) {
            ITemplate iTemplate;
            ITemplate subTemplate = CloudAPI.Companion.getInstance().getTemplateManager().getTemplateByName(templateName);
            if (subTemplate == null) continue;
            boolean bl = false;
            boolean bl2 = false;
            ITemplate it = iTemplate;
            boolean bl3 = false;
            set.addAll((Collection)this.getDirectoriesOfTemplateAndSubTemplates(it));
        }
        set.add(template.getDirectory());
        return set;
    }

    private final Set<String> getModulesToCopyOfTemplateAndSubTemplates(ITemplate template) {
        HashSet set = new HashSet();
        for (String templateName : template.getInheritedTemplateNames()) {
            ITemplate iTemplate;
            ITemplate subTemplate = CloudAPI.Companion.getInstance().getTemplateManager().getTemplateByName(templateName);
            if (subTemplate == null) continue;
            boolean bl = false;
            boolean bl2 = false;
            ITemplate it = iTemplate;
            boolean bl3 = false;
            set.addAll(this.getModulesToCopyOfTemplateAndSubTemplates(it));
        }
        set.addAll(template.getModuleNamesToCopy());
        return set;
    }

    public ServiceDirectory(@NotNull ICloudService cloudService) {
        Intrinsics.checkNotNullParameter((Object)cloudService, (String)"cloudService");
        this.cloudService = cloudService;
        this.copiedModulesAsPlugins = CollectionsKt.emptyList();
        this.serviceTmpDirectory = this.getServiceTmpDirectory(this.cloudService);
    }
}

