/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.base.wrapper.process.filehandler;

import eu.thesimplecloud.api.directorypaths.DirectoryPaths;
import eu.thesimplecloud.api.service.version.ServiceVersion;
import eu.thesimplecloud.api.utils.Downloader;
import eu.thesimplecloud.api.utils.ZipUtils;
import java.io.File;
import java.io.FileNotFoundException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Leu/thesimplecloud/base/wrapper/process/filehandler/ServiceVersionJarLoader;", "", "()V", "loadVersionFile", "Ljava/io/File;", "serviceVersion", "Leu/thesimplecloud/api/service/version/ServiceVersion;", "simplecloud-base"})
public final class ServiceVersionJarLoader {
    @NotNull
    public final synchronized File loadVersionFile(@NotNull ServiceVersion serviceVersion) {
        Intrinsics.checkNotNullParameter((Object)serviceVersion, (String)"serviceVersion");
        File file = new File(DirectoryPaths.Companion.getPaths().getMinecraftJarsPath() + serviceVersion.getName() + ".jar");
        if (!file.exists()) {
            if (StringsKt.isBlank((CharSequence)serviceVersion.getDownloadURL()) || StringsKt.equals((String)serviceVersion.getDownloadURL(), (String)"noDownload", (boolean)true)) {
                throw (Throwable)new FileNotFoundException("Service version " + serviceVersion.getName() + " is set to no download but does not exist in minecraftJars folder.");
            }
            new Downloader().userAgentDownload(serviceVersion.getDownloadURL(), file);
            new ZipUtils().deletePath(file, "com/google/gson/");
            Thread.sleep(200L);
        }
        return file;
    }
}

