/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.base.wrapper.process.queue;

import eu.thesimplecloud.api.service.ICloudService;
import eu.thesimplecloud.base.wrapper.process.CloudServiceProcess;
import eu.thesimplecloud.base.wrapper.process.CloudServiceProcessManager;
import eu.thesimplecloud.base.wrapper.process.ICloudServiceProcess;
import eu.thesimplecloud.base.wrapper.process.queue.CloudServiceProcessQueue;
import eu.thesimplecloud.base.wrapper.startup.Wrapper;
import eu.thesimplecloud.launcher.startup.Launcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.LinkedBlockingQueue;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.concurrent.ThreadsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u000e\u001a\u00020\u000bJ\b\u0010\u000f\u001a\u00020\u0010H\u0002J\u0006\u0010\u0011\u001a\u00020\u0010J\u000e\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u0013\u001a\u00020\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Leu/thesimplecloud/base/wrapper/process/queue/CloudServiceProcessQueue;", "", "()V", "cloudServiceProcessManager", "Leu/thesimplecloud/base/wrapper/process/CloudServiceProcessManager;", "queue", "Ljava/util/concurrent/LinkedBlockingQueue;", "Leu/thesimplecloud/base/wrapper/process/ICloudServiceProcess;", "startingServices", "Ljava/util/ArrayList;", "addToQueue", "", "cloudService", "Leu/thesimplecloud/api/service/ICloudService;", "clearQueue", "getMaxSimultaneouslyStartingServices", "", "getStartingOrQueuedServiceAmount", "removeFromQueue", "startThread", "simplecloud-base"})
public final class CloudServiceProcessQueue {
    private final CloudServiceProcessManager cloudServiceProcessManager = Wrapper.Companion.getInstance().getCloudServiceProcessManager();
    private final LinkedBlockingQueue<ICloudServiceProcess> queue = new LinkedBlockingQueue();
    private final ArrayList<ICloudServiceProcess> startingServices = new ArrayList();

    private final int getMaxSimultaneouslyStartingServices() {
        return Wrapper.Companion.getInstance().getThisWrapper().getMaxSimultaneouslyStartingServices();
    }

    public final void addToQueue(@NotNull ICloudService cloudService) {
        Intrinsics.checkNotNullParameter((Object)cloudService, (String)"cloudService");
        Launcher.Companion.getInstance().getConsoleSender().sendProperty("wrapper.service.queued", new String[]{cloudService.getName()});
        CloudServiceProcess cloudServiceProcess = new CloudServiceProcess(cloudService);
        this.queue.add(cloudServiceProcess);
        Wrapper.Companion.getInstance().getCloudServiceProcessManager().registerServiceProcess(cloudServiceProcess);
        Wrapper.Companion.getInstance().updateWrapperData();
    }

    public final int getStartingOrQueuedServiceAmount() {
        return this.startingServices.size() + this.queue.size();
    }

    public final void startThread() {
        ThreadsKt.thread$default((boolean)true, (boolean)true, null, null, (int)0, (Function0)((Function0)new Function0<Unit>(this){
            final /* synthetic */ CloudServiceProcessQueue this$0;

            public final void invoke() {
                while (true) {
                    boolean canStartService;
                    boolean startingServicesRemoved2 = CloudServiceProcessQueue.access$getStartingServices$p(this.this$0).removeIf(startThread.startingServicesRemoved.1.INSTANCE);
                    Collection collection = CloudServiceProcessQueue.access$getQueue$p(this.this$0);
                    boolean bl = false;
                    boolean bl2 = canStartService = !collection.isEmpty() && CloudServiceProcessQueue.access$getStartingServices$p(this.this$0).size() < CloudServiceProcessQueue.access$getMaxSimultaneouslyStartingServices(this.this$0);
                    if (canStartService) {
                        ICloudServiceProcess cloudServiceProcess = (ICloudServiceProcess)CloudServiceProcessQueue.access$getQueue$p(this.this$0).poll();
                        ThreadsKt.thread$default((boolean)false, (boolean)false, null, null, (int)0, (Function0)((Function0)new Function0<Unit>(cloudServiceProcess){
                            final /* synthetic */ ICloudServiceProcess $cloudServiceProcess;

                            public final void invoke() {
                                this.$cloudServiceProcess.start();
                            }
                            {
                                this.$cloudServiceProcess = iCloudServiceProcess;
                                super(0);
                            }
                        }), (int)31, null);
                        CloudServiceProcessQueue.access$getStartingServices$p(this.this$0).add(cloudServiceProcess);
                    }
                    if (startingServicesRemoved2 || canStartService) {
                        Wrapper.Companion.getInstance().updateWrapperData();
                    }
                    Thread.sleep(200L);
                }
            }
            {
                this.this$0 = cloudServiceProcessQueue;
                super(0);
            }
        }), (int)28, null);
    }

    public final void removeFromQueue(@NotNull ICloudService cloudService) {
        ICloudServiceProcess cloudServiceProcess;
        Intrinsics.checkNotNullParameter((Object)cloudService, (String)"cloudService");
        ICloudServiceProcess iCloudServiceProcess = cloudServiceProcess = this.cloudServiceProcessManager.getCloudServiceProcessByService(cloudService);
        if (iCloudServiceProcess != null) {
            ICloudServiceProcess iCloudServiceProcess2 = iCloudServiceProcess;
            boolean bl = false;
            boolean bl2 = false;
            ICloudServiceProcess it = iCloudServiceProcess2;
            boolean bl3 = false;
            this.queue.remove(cloudServiceProcess);
            this.cloudServiceProcessManager.unregisterServiceProcess(cloudServiceProcess);
        }
        Wrapper.Companion.getInstance().updateWrapperData();
    }

    public final void clearQueue() {
        Iterable $this$forEach$iv = this.queue;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ICloudServiceProcess it = (ICloudServiceProcess)element$iv;
            boolean bl = false;
            CloudServiceProcessManager cloudServiceProcessManager = Wrapper.Companion.getInstance().getCloudServiceProcessManager();
            ICloudServiceProcess iCloudServiceProcess = it;
            Intrinsics.checkNotNullExpressionValue((Object)iCloudServiceProcess, (String)"it");
            cloudServiceProcessManager.unregisterServiceProcess(iCloudServiceProcess);
        }
        this.queue.clear();
    }

    public static final /* synthetic */ ArrayList access$getStartingServices$p(CloudServiceProcessQueue $this) {
        return $this.startingServices;
    }

    public static final /* synthetic */ int access$getMaxSimultaneouslyStartingServices(CloudServiceProcessQueue $this) {
        return $this.getMaxSimultaneouslyStartingServices();
    }

    public static final /* synthetic */ LinkedBlockingQueue access$getQueue$p(CloudServiceProcessQueue $this) {
        return $this.queue;
    }
}

