/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.base.wrapper.process.serviceconfigurator.configurators;

import eu.thesimplecloud.api.service.ICloudService;
import eu.thesimplecloud.api.utils.FileEditor;
import eu.thesimplecloud.base.wrapper.process.serviceconfigurator.IServiceConfigurator;
import eu.thesimplecloud.launcher.utils.FileCopier;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Leu/thesimplecloud/base/wrapper/process/serviceconfigurator/configurators/DefaultBungeeConfigurator;", "Leu/thesimplecloud/base/wrapper/process/serviceconfigurator/IServiceConfigurator;", "()V", "configureService", "", "cloudService", "Leu/thesimplecloud/api/service/ICloudService;", "serviceTmpDirectory", "Ljava/io/File;", "simplecloud-base"})
public final class DefaultBungeeConfigurator
implements IServiceConfigurator {
    @Override
    public void configureService(@NotNull ICloudService cloudService, @NotNull File serviceTmpDirectory) {
        Intrinsics.checkNotNullParameter((Object)cloudService, (String)"cloudService");
        Intrinsics.checkNotNullParameter((Object)serviceTmpDirectory, (String)"serviceTmpDirectory");
        File bungeeConfigFile = new File(serviceTmpDirectory, "config.yml");
        if (!bungeeConfigFile.exists()) {
            FileCopier.Companion.copyFileOutOfJar(bungeeConfigFile, "/files/config.yml");
        }
        FileEditor fileEditor = new FileEditor(bungeeConfigFile);
        fileEditor.replaceLine("  host: 0.0.0.0:25565", "  host: 0.0.0.0:" + cloudService.getPort());
        fileEditor.replaceLine("  max_players: 1", "  max_players: " + cloudService.getMaxPlayers());
        fileEditor.save(bungeeConfigFile);
    }
}

