/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.api.network.packets.player;

import eu.thesimplecloud.api.CloudAPI;
import eu.thesimplecloud.api.exception.UnreachableComponentException;
import eu.thesimplecloud.api.player.ICloudPlayer;
import eu.thesimplecloud.api.player.connection.ConnectionResponse;
import eu.thesimplecloud.api.service.ICloudService;
import eu.thesimplecloud.clientserverapi.lib.connection.IConnection;
import eu.thesimplecloud.clientserverapi.lib.packet.packettype.JsonPacket;
import eu.thesimplecloud.clientserverapi.lib.promise.ICommunicationPromise;
import java.util.NoSuchElementException;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0005\u00a2\u0006\u0002\u0010\u0007J\u001f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\r\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u000e"}, d2={"Leu/thesimplecloud/api/network/packets/player/PacketIOConnectCloudPlayer;", "Leu/thesimplecloud/clientserverapi/lib/packet/packettype/JsonPacket;", "cloudPlayer", "Leu/thesimplecloud/api/player/ICloudPlayer;", "service", "Leu/thesimplecloud/api/service/ICloudService;", "(Leu/thesimplecloud/api/player/ICloudPlayer;Leu/thesimplecloud/api/service/ICloudService;)V", "()V", "handle", "Leu/thesimplecloud/clientserverapi/lib/promise/ICommunicationPromise;", "Leu/thesimplecloud/api/player/connection/ConnectionResponse;", "connection", "Leu/thesimplecloud/clientserverapi/lib/connection/IConnection;", "(Leu/thesimplecloud/clientserverapi/lib/connection/IConnection;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "simplecloud-api"})
public final class PacketIOConnectCloudPlayer
extends JsonPacket {
    public PacketIOConnectCloudPlayer() {
    }

    public PacketIOConnectCloudPlayer(@NotNull ICloudPlayer cloudPlayer, @NotNull ICloudService service) {
        Intrinsics.checkNotNullParameter((Object)cloudPlayer, (String)"cloudPlayer");
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        this();
        this.getJsonLib().append("playerUniqueId", (Object)cloudPlayer.getUniqueId()).append("serviceName", service.getName());
    }

    @Nullable
    public Object handle(@NotNull IConnection connection, @NotNull Continuation<? super ICommunicationPromise<ConnectionResponse>> $completion) {
        UUID uUID = (UUID)this.getJsonLib().getObject("playerUniqueId", UUID.class);
        if (uUID == null) {
            return this.contentException("playerUniqueId");
        }
        UUID playerUniqueId = uUID;
        String string = this.getJsonLib().getString("serviceName");
        if (string == null) {
            return this.contentException("serviceName");
        }
        String serviceName = string;
        ICloudService iCloudService = CloudAPI.Companion.getInstance().getCloudServiceManager().getCloudServiceByName(serviceName);
        if (iCloudService == null) {
            return this.failure(new UnreachableComponentException(""));
        }
        ICloudService cloudService = iCloudService;
        ICommunicationPromise<ConnectionResponse> iCommunicationPromise = CloudAPI.Companion.getInstance().getCloudPlayerManager().getCachedCloudPlayer(playerUniqueId);
        if (iCommunicationPromise == null || (iCommunicationPromise = iCommunicationPromise.connect(cloudService)) == null) {
            return this.failure(new NoSuchElementException("Player not found"));
        }
        return iCommunicationPromise;
    }
}

