/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.api.utils;

import eu.thesimplecloud.api.utils.ConfigurationFileEditor;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u001b\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\b\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tJ \u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\bH\u0002J\u0010\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0005H\u0002J\"\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00182\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\bH\u0002J\u0010\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0005H\u0002J\u0010\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u0013H\u0002J\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0010\u001a\u00020\u0005J\u0010\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u0005H\u0002J\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010\u0002\u001a\u00020\u0003J\u0016\u0010!\u001a\u00020 2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0005RJ\u0010\n\u001a>\u0012\f\u0012\n \f*\u0004\u0018\u00010\u00050\u0005\u0012\f\u0012\n \f*\u0004\u0018\u00010\u00050\u00050\u000bj\u001e\u0012\f\u0012\n \f*\u0004\u0018\u00010\u00050\u0005\u0012\f\u0012\n \f*\u0004\u0018\u00010\u00050\u0005`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Leu/thesimplecloud/api/utils/ConfigurationFileEditor;", "", "file", "Ljava/io/File;", "keyValueSplitter", "", "(Ljava/io/File;Ljava/lang/String;)V", "linesWithSpaces", "", "(Ljava/util/List;Ljava/lang/String;)V", "keyToValues", "Ljava/util/HashMap;", "kotlin.jvm.PlatformType", "Lkotlin/collections/HashMap;", "lines", "constructNewLine", "key", "value", "lineIndex", "", "generateNewLines", "getAmountOfStartSpacesInLine", "line", "getKeyToValueMapByLines", "", "getLineIndexByKey", "getStringWithSpaces", "amount", "getValue", "removeFirstSpaces", "string", "saveToFile", "", "setValue", "Companion", "simplecloud-api"})
@SourceDebugExtension(value={"SMAP\nConfigurationFileEditor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigurationFileEditor.kt\neu/thesimplecloud/api/utils/ConfigurationFileEditor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,118:1\n1549#2:119\n1620#2,3:120\n766#2:123\n857#2,2:124\n1549#2:126\n1620#2,3:127\n1549#2:130\n1620#2,3:131\n288#2,2:134\n*S KotlinDebug\n*F\n+ 1 ConfigurationFileEditor.kt\neu/thesimplecloud/api/utils/ConfigurationFileEditor\n*L\n46#1:119\n46#1:120,3\n51#1:123\n51#1:124,2\n51#1:126\n51#1:127,3\n52#1:130\n52#1:131,3\n107#1:134,2\n*E\n"})
public final class ConfigurationFileEditor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<String> linesWithSpaces;
    @NotNull
    private final String keyValueSplitter;
    @NotNull
    private final List<String> lines;
    @NotNull
    private final HashMap<String, String> keyToValues;
    @NotNull
    public static final String YAML_SPLITTER = ": ";
    @NotNull
    public static final String PROPERTIES_SPLITTER = "=";
    @NotNull
    public static final String TOML_SPLITTER = " = ";

    /*
     * WARNING - void declaration
     */
    public ConfigurationFileEditor(@NotNull List<String> linesWithSpaces, @NotNull String keyValueSplitter) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(linesWithSpaces, (String)"linesWithSpaces");
        Intrinsics.checkNotNullParameter((Object)keyValueSplitter, (String)"keyValueSplitter");
        this.linesWithSpaces = linesWithSpaces;
        this.keyValueSplitter = keyValueSplitter;
        Iterable iterable = this.linesWithSpaces;
        ConfigurationFileEditor configurationFileEditor = this;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.removeFirstSpaces((String)it));
        }
        configurationFileEditor.lines = (List)destination$iv$iv;
        this.keyToValues = new HashMap<String, String>(this.getKeyToValueMapByLines(this.lines));
    }

    public ConfigurationFileEditor(@NotNull File file, @NotNull String keyValueSplitter) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)keyValueSplitter, (String)"keyValueSplitter");
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        this(FilesKt.readLines((File)file, (Charset)charset), keyValueSplitter);
    }

    private final Map<String, String> getKeyToValueMapByLines(List<String> lines) {
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Object it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = lines;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            if (!StringsKt.contains$default((CharSequence)((CharSequence)it), (CharSequence)this.keyValueSplitter, (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String[] stringArray = new String[]{this.keyValueSplitter};
            collection.add(StringsKt.split$default((CharSequence)((CharSequence)it), (String[])stringArray, (boolean)false, (int)0, (int)6, null));
        }
        List keyValueSplitArrays = (List)destination$iv$iv;
        $this$map$iv = keyValueSplitArrays;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (List)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Object e = it.get(0);
            String string = (String)CollectionsKt.getOrNull((List)it, (int)1);
            if (string == null) {
                string = "";
            }
            collection.add(TuplesKt.to(e, (Object)string));
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    @Nullable
    public final String getValue(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.keyToValues.get(key);
    }

    public final void setValue(@NotNull String key, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (!this.keyToValues.containsKey(key)) {
            throw new IllegalStateException("Key '" + key + "' does not exist");
        }
        ((Map)this.keyToValues).put(key, value);
    }

    public final void saveToFile(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        List<String> linesToSave = this.generateNewLines();
        FilesKt.writeText$default((File)file, (String)CollectionsKt.joinToString$default((Iterable)linesToSave, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null), null, (int)2, null);
    }

    private final List<String> generateNewLines() {
        ArrayList<String> mutableLines = new ArrayList<String>((Collection)this.linesWithSpaces);
        for (Map.Entry entry : ((Map)this.keyToValues).entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
            int lineIndex = this.getLineIndexByKey(key);
            Intrinsics.checkNotNullExpressionValue((Object)value, (String)"value");
            String newLine = this.constructNewLine(key, value, lineIndex);
            mutableLines.set(lineIndex, newLine);
        }
        return mutableLines;
    }

    private final String constructNewLine(String key, String value, int lineIndex) {
        String lineWithoutSpaces = key + this.keyValueSplitter + value;
        int amountOfStartSpaces = this.getAmountOfStartSpacesInLine(this.linesWithSpaces.get(lineIndex));
        String spacesString = this.getStringWithSpaces(amountOfStartSpaces);
        return spacesString + lineWithoutSpaces;
    }

    private final String getStringWithSpaces(int amount) {
        return CollectionsKt.joinToString$default((Iterable)((Iterable)RangesKt.until((int)0, (int)amount)), (CharSequence)"", null, null, (int)0, null, (Function1)getStringWithSpaces.1.INSTANCE, (int)30, null);
    }

    private final String removeFirstSpaces(String string) {
        int amountOfSpaces = this.getAmountOfStartSpacesInLine(string);
        return StringsKt.drop((String)string, (int)amountOfSpaces);
    }

    private final int getAmountOfStartSpacesInLine(String line) {
        String line2 = line;
        int amountOfSPaces = 0;
        while (StringsKt.startsWith$default((String)line2, (String)" ", (boolean)false, (int)2, null)) {
            line2 = StringsKt.drop((String)line2, (int)1);
            ++amountOfSPaces;
        }
        return amountOfSPaces;
    }

    private final int getLineIndexByKey(String key) {
        Object v0;
        block2: {
            String lineStart = key + this.keyValueSplitter;
            Iterable $this$firstOrNull$iv = this.lines;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                if (!StringsKt.startsWith$default((String)it, (String)lineStart, (boolean)false, (int)2, null)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        String string = v0;
        if (string == null) {
            return -1;
        }
        String line = string;
        return this.lines.indexOf(line);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Leu/thesimplecloud/api/utils/ConfigurationFileEditor$Companion;", "", "()V", "PROPERTIES_SPLITTER", "", "TOML_SPLITTER", "YAML_SPLITTER", "simplecloud-api"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

