/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.launcher.application;

import eu.thesimplecloud.api.directorypaths.DirectoryPaths;
import eu.thesimplecloud.api.external.ICloudModule;
import eu.thesimplecloud.launcher.application.ApplicationClassLoader;
import eu.thesimplecloud.launcher.application.CloudApplicationType;
import eu.thesimplecloud.launcher.application.ICloudApplication;
import eu.thesimplecloud.launcher.console.ConsoleSender;
import eu.thesimplecloud.launcher.external.module.LoadedModule;
import eu.thesimplecloud.launcher.external.module.LoadedModuleFileContent;
import eu.thesimplecloud.launcher.external.module.ModuleFileContent;
import eu.thesimplecloud.launcher.external.module.handler.ModuleHandler;
import eu.thesimplecloud.launcher.external.module.handler.UnsafeModuleLoader;
import eu.thesimplecloud.launcher.startup.Launcher;
import eu.thesimplecloud.launcher.updater.BaseUpdater;
import eu.thesimplecloud.launcher.updater.UpdateExecutor;
import java.io.File;
import java.net.URL;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Leu/thesimplecloud/launcher/application/ApplicationStarter;", "", "()V", "startApplication", "", "applicationType", "Leu/thesimplecloud/launcher/application/CloudApplicationType;", "simplecloud-launcher"})
public final class ApplicationStarter {
    public final void startApplication(@NotNull CloudApplicationType applicationType) {
        Intrinsics.checkNotNullParameter((Object)((Object)applicationType), (String)"applicationType");
        ClassLoader launcherClassLoader = Launcher.Companion.getInstance().getCurrentClassLoader();
        Thread.currentThread().setContextClassLoader(launcherClassLoader);
        ModuleHandler moduleHandler = new ModuleHandler(null, null, null, false, null, 31, null);
        Function2 createClassLoaderFunction2 = (Function2)new Function2<URL[], String, ApplicationClassLoader>(launcherClassLoader, moduleHandler){
            final /* synthetic */ ClassLoader $launcherClassLoader;
            final /* synthetic */ ModuleHandler $moduleHandler;
            {
                this.$launcherClassLoader = $launcherClassLoader;
                this.$moduleHandler = $moduleHandler;
                super(2);
            }

            @NotNull
            public final ApplicationClassLoader invoke(@NotNull URL[] urls, @NotNull String name) {
                Intrinsics.checkNotNullParameter((Object)urls, (String)"urls");
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                return new ApplicationClassLoader(urls, this.$launcherClassLoader, name, this.$moduleHandler);
            }
        };
        StringBuilder stringBuilder = new StringBuilder();
        String string = applicationType.name().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        String moduleFileName = stringBuilder.append(string).append(".json").toString();
        File file = new File(DirectoryPaths.Companion.getPaths().getStoragePath() + "base.jar");
        if (!Launcher.Companion.getInstance().getLauncherStartArguments().getDisableAutoUpdater() || !file.exists()) {
            Launcher.Companion.getInstance().getConsoleSender().sendMessage("Checking for base updates...");
            BaseUpdater updater2 = new BaseUpdater();
            if (updater2.isUpdateAvailable()) {
                ConsoleSender consoleSender = Launcher.Companion.getInstance().getConsoleSender();
                StringBuilder stringBuilder2 = new StringBuilder().append("Base update found: ");
                String string2 = updater2.getVersionToInstall();
                Intrinsics.checkNotNull((Object)string2);
                consoleSender.sendMessage(stringBuilder2.append(string2).append(" (current: ").append(updater2.getCurrentVersion()).append(')').toString());
                Launcher.Companion.getInstance().getConsoleSender().sendMessage("Downloading base update...");
                new UpdateExecutor().executeUpdate(updater2);
            } else {
                Launcher.Companion.getInstance().getConsoleSender().sendMessage("You are running the latest version of SimpleCloud.");
            }
        }
        ModuleFileContent moduleFileContent = moduleHandler.loadModuleFileContent(file, moduleFileName);
        LoadedModuleFileContent loadedModuleFileContent = new LoadedModuleFileContent(file, moduleFileContent, null);
        LoadedModule loadedModule = new UnsafeModuleLoader((Function2<? super URL[], ? super String, ? extends ClassLoader>)createClassLoaderFunction2).loadModule(loadedModuleFileContent);
        ICloudModule iCloudModule = loadedModule.getCloudModule();
        Intrinsics.checkNotNull((Object)iCloudModule, (String)"null cannot be cast to non-null type eu.thesimplecloud.launcher.application.ICloudApplication");
        ICloudApplication cloudModule = (ICloudApplication)iCloudModule;
        cloudModule.onEnable();
        Launcher.Companion.getInstance().setActiveApplication(cloudModule);
    }
}

