/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.launcher.console;

import eu.thesimplecloud.launcher.console.ConsoleCompleter;
import eu.thesimplecloud.launcher.console.ConsoleSender;
import eu.thesimplecloud.launcher.console.IConsoleManager;
import eu.thesimplecloud.launcher.console.command.CommandManager;
import eu.thesimplecloud.launcher.logging.LogType;
import eu.thesimplecloud.launcher.screens.IScreen;
import eu.thesimplecloud.launcher.screens.IScreenManager;
import eu.thesimplecloud.launcher.startup.Launcher;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jline.reader.Completer;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.UserInterruptException;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0017\u001a\u00020\fH\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0010H\u0002J\b\u0010\u001b\u001a\u00020\u0019H\u0016J\b\u0010\u001c\u001a\u00020\u0019H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001d"}, d2={"Leu/thesimplecloud/launcher/console/ConsoleManager;", "Leu/thesimplecloud/launcher/console/IConsoleManager;", "commandManager", "Leu/thesimplecloud/launcher/console/command/CommandManager;", "consoleSender", "Leu/thesimplecloud/launcher/console/ConsoleSender;", "(Leu/thesimplecloud/launcher/console/command/CommandManager;Leu/thesimplecloud/launcher/console/ConsoleSender;)V", "getCommandManager", "()Leu/thesimplecloud/launcher/console/command/CommandManager;", "getConsoleSender", "()Leu/thesimplecloud/launcher/console/ConsoleSender;", "lineReader", "Lorg/jline/reader/LineReader;", "getLineReader", "()Lorg/jline/reader/LineReader;", "prompt", "", "thread", "Ljava/lang/Thread;", "getThread", "()Ljava/lang/Thread;", "setThread", "(Ljava/lang/Thread;)V", "createLineReader", "handleInput", "", "readLine", "startThread", "stopThread", "simplecloud-launcher"})
public final class ConsoleManager
implements IConsoleManager {
    @NotNull
    private final CommandManager commandManager;
    @NotNull
    private final ConsoleSender consoleSender;
    @Nullable
    private Thread thread;
    @NotNull
    private final LineReader lineReader;
    @NotNull
    private final String prompt;

    public ConsoleManager(@NotNull CommandManager commandManager, @NotNull ConsoleSender consoleSender) {
        Intrinsics.checkNotNullParameter((Object)commandManager, (String)"commandManager");
        Intrinsics.checkNotNullParameter((Object)consoleSender, (String)"consoleSender");
        this.commandManager = commandManager;
        this.consoleSender = consoleSender;
        this.lineReader = this.createLineReader();
        this.prompt = Launcher.Companion.getInstance().getLogger().getColoredString("\u00a7bSimpleCloud \u00a77>\u00a7f ", LogType.EMPTY);
    }

    @NotNull
    public final CommandManager getCommandManager() {
        return this.commandManager;
    }

    @NotNull
    public final ConsoleSender getConsoleSender() {
        return this.consoleSender;
    }

    @Nullable
    public final Thread getThread() {
        return this.thread;
    }

    public final void setThread(@Nullable Thread thread) {
        this.thread = thread;
    }

    @NotNull
    public final LineReader getLineReader() {
        return this.lineReader;
    }

    private final LineReader createLineReader() {
        ConsoleCompleter consoleCompleter = new ConsoleCompleter(this);
        Terminal terminal = TerminalBuilder.builder().system(true).streams(System.in, (OutputStream)System.out).encoding(Charsets.UTF_8).dumb(true).build();
        LineReader lineReader = LineReaderBuilder.builder().completer((Completer)consoleCompleter).terminal(terminal).option(LineReader.Option.DISABLE_EVENT_EXPANSION, true).option(LineReader.Option.AUTO_REMOVE_SLASH, false).option(LineReader.Option.INSERT_TAB, false).build();
        Intrinsics.checkNotNullExpressionValue((Object)lineReader, (String)"builder()\n            .c\u2026lse)\n            .build()");
        return lineReader;
    }

    @Override
    public void startThread() {
        block0: {
            Thread thread = this.thread = new Thread(() -> ConsoleManager.startThread$lambda$0(this));
            if (thread == null) break block0;
            thread.start();
        }
    }

    private final void handleInput(String readLine) {
        IScreenManager screenManager = Launcher.Companion.getInstance().getScreenManager();
        if (screenManager.hasActiveScreen()) {
            if (StringsKt.equals((String)readLine, (String)"leave", (boolean)true)) {
                Launcher.Companion.getInstance().getScreenManager().leaveActiveScreen();
                return;
            }
            IScreen iScreen = screenManager.getActiveScreen();
            if (iScreen != null) {
                iScreen.executeCommand(readLine);
            }
            return;
        }
        if (Launcher.Companion.getInstance().getSetupManager().hasActiveSetup()) {
            if (StringsKt.equals((String)readLine, (String)"exit", (boolean)true)) {
                Launcher.Companion.getInstance().getSetupManager().cancelCurrentSetup();
                return;
            }
            Launcher.Companion.getInstance().getSetupManager().onResponse(((Object)StringsKt.trim((CharSequence)readLine)).toString());
            return;
        }
        if (StringsKt.isBlank((CharSequence)readLine)) {
            return;
        }
        try {
            this.commandManager.handleCommand("cloud " + readLine, this.consoleSender);
        }
        catch (Exception e) {
            Launcher.Companion.getInstance().getLogger().exception(e);
        }
    }

    @Override
    public void stopThread() {
        block0: {
            this.lineReader.getTerminal().reader().shutdown();
            this.lineReader.getTerminal().pause();
            Thread thread = this.thread;
            if (thread == null) break block0;
            thread.interrupt();
        }
    }

    private static final void startThread$lambda$0(ConsoleManager this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        String readLine = null;
        try {
            while (!Thread.currentThread().isInterrupted()) {
                String string = this$0.lineReader.readLine(this$0.prompt);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"lineReader.readLine(prompt)");
                readLine = string;
                this$0.handleInput(readLine);
            }
        }
        catch (UserInterruptException userInterruptException) {
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }
}

