/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.launcher.console;

import eu.thesimplecloud.api.CloudAPI;
import eu.thesimplecloud.api.command.ICommandSender;
import eu.thesimplecloud.clientserverapi.lib.promise.CommunicationPromise;
import eu.thesimplecloud.clientserverapi.lib.promise.ICommunicationPromise;
import eu.thesimplecloud.launcher.startup.Launcher;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\u0004H\u0016J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00072\u0006\u0010\u0005\u001a\u00020\u0004H\u0016J'\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u00042\u0012\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u000f\"\u00020\u0004\u00a2\u0006\u0002\u0010\u0010\u00a8\u0006\u0011"}, d2={"Leu/thesimplecloud/launcher/console/ConsoleSender;", "Leu/thesimplecloud/api/command/ICommandSender;", "()V", "filterColorCodes", "", "message", "hasPermission", "Leu/thesimplecloud/clientserverapi/lib/promise/ICommunicationPromise;", "", "permission", "sendMessage", "", "sendPropertyInSetup", "property", "placeholderValues", "", "(Ljava/lang/String;[Ljava/lang/String;)V", "simplecloud-launcher"})
public final class ConsoleSender
implements ICommandSender {
    @Override
    @NotNull
    public ICommunicationPromise<Unit> sendMessage(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (StringsKt.isBlank((CharSequence)message)) {
            return CommunicationPromise.Companion.getUNIT_PROMISE();
        }
        if (StringsKt.startsWith$default((String)message, (String)"\u00a7c", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)message, (String)"&c", (boolean)false, (int)2, null)) {
            Launcher.Companion.getInstance().getLogger().warning(this.filterColorCodes(message));
        } else {
            Launcher.Companion.getInstance().getLogger().console(this.filterColorCodes(message));
        }
        return CommunicationPromise.Companion.getUNIT_PROMISE();
    }

    public final void sendPropertyInSetup(@NotNull String property, String ... placeholderValues) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        Intrinsics.checkNotNullParameter((Object)placeholderValues, (String)"placeholderValues");
        if (CloudAPI.Companion.isAvailable()) {
            String replacedMessage = CloudAPI.Companion.getInstance().getLanguageManager().getMessage(property, Arrays.copyOf(placeholderValues, placeholderValues.length));
            Launcher.Companion.getInstance().getLogger().setup(replacedMessage);
            return;
        }
        Launcher.Companion.getInstance().getLogger().setup(property);
    }

    @Override
    @NotNull
    public ICommunicationPromise<Boolean> hasPermission(@NotNull String permission) {
        Intrinsics.checkNotNullParameter((Object)permission, (String)"permission");
        return CommunicationPromise.Companion.of((Object)true);
    }

    private final String filterColorCodes(String message) {
        String message2 = StringsKt.replace$default((String)message, (String)"$", (String)"&", (boolean)false, (int)4, null);
        StringBuilder builder = new StringBuilder();
        char[] cArray = message2.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"this as java.lang.String).toCharArray()");
        char[] charArray = cArray;
        char lastChar = '0';
        for (char c : charArray) {
            boolean isCharToRemove = c == '&' || lastChar == '&';
            lastChar = c;
            if (isCharToRemove) continue;
            builder.append(c);
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"builder.toString()");
        return string;
    }

    @Override
    public boolean hasPermissionSync(@NotNull String permission) {
        return ICommandSender.DefaultImpls.hasPermissionSync(this, permission);
    }

    @Override
    @NotNull
    public ICommunicationPromise<Unit> sendProperty(@NotNull String property, String ... placeholderValues) {
        return ICommandSender.DefaultImpls.sendProperty(this, property, placeholderValues);
    }
}

