/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.launcher.console.setup;

import eu.thesimplecloud.api.parser.string.StringParser;
import eu.thesimplecloud.api.utils.StringIterableExtensionKt;
import eu.thesimplecloud.clientserverapi.lib.promise.CommunicationPromise;
import eu.thesimplecloud.launcher.console.ConsoleSender;
import eu.thesimplecloud.launcher.console.setup.ISetup;
import eu.thesimplecloud.launcher.console.setup.annotations.SetupCancelled;
import eu.thesimplecloud.launcher.console.setup.annotations.SetupFinished;
import eu.thesimplecloud.launcher.console.setup.annotations.SetupQuestion;
import eu.thesimplecloud.launcher.console.setup.provider.ISetupAnswerProvider;
import eu.thesimplecloud.launcher.extension.IterableExtensionKt;
import eu.thesimplecloud.launcher.logging.LoggerProvider;
import eu.thesimplecloud.launcher.startup.Launcher;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u000289B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010 \u001a\u00020\u001fJ\b\u0010!\u001a\u00020\u001fH\u0002J\u0006\u0010\"\u001a\u00020\u001fJ\u001c\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$2\u0006\u0010&\u001a\u00020%2\u0006\u0010'\u001a\u00020(J\u0006\u0010)\u001a\u00020*J\u0010\u0010+\u001a\u00020*2\u0006\u0010,\u001a\u00020\rH\u0002J\b\u0010-\u001a\u00020\u001fH\u0002J\u000e\u0010.\u001a\u00020\u001f2\u0006\u0010/\u001a\u00020%J\b\u00100\u001a\u00020\u001fH\u0002J\u0018\u00101\u001a\u00020\u001f2\u0006\u00102\u001a\u0002032\b\b\u0002\u00104\u001a\u00020*J\b\u00105\u001a\u00020\u001fH\u0002J\u0010\u00106\u001a\u00020\u001f2\u0006\u0010,\u001a\u00020\rH\u0002J\u0006\u00107\u001a\u00020\u001fR\"\u0010\u0007\u001a\u0004\u0018\u00010\u00062\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\f\u001a\u0004\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R!\u0010\u0018\u001a\u0012\u0012\u0004\u0012\u00020\r0\u0019j\b\u0012\u0004\u0012\u00020\r`\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Leu/thesimplecloud/launcher/console/setup/SetupManager;", "", "launcher", "Leu/thesimplecloud/launcher/startup/Launcher;", "(Leu/thesimplecloud/launcher/startup/Launcher;)V", "<set-?>", "Leu/thesimplecloud/launcher/console/setup/SetupManager$SetupQuestionData;", "currentQuestion", "getCurrentQuestion", "()Leu/thesimplecloud/launcher/console/setup/SetupManager$SetupQuestionData;", "currentQuestionIndex", "", "currentSetup", "Leu/thesimplecloud/launcher/console/setup/SetupManager$SetupData;", "getCurrentSetup", "()Leu/thesimplecloud/launcher/console/setup/SetupManager$SetupData;", "setCurrentSetup", "(Leu/thesimplecloud/launcher/console/setup/SetupManager$SetupData;)V", "getLauncher", "()Leu/thesimplecloud/launcher/startup/Launcher;", "logger", "Leu/thesimplecloud/launcher/logging/LoggerProvider;", "getLogger", "()Leu/thesimplecloud/launcher/logging/LoggerProvider;", "setupQueue", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "getSetupQueue", "()Ljava/util/ArrayList;", "setupsCompletedPromise", "Leu/thesimplecloud/clientserverapi/lib/promise/CommunicationPromise;", "", "cancelCurrentSetup", "checkForNextSetup", "finishCurrentSetup", "getSetupSuggestions", "", "", "userInput", "consoleSender", "Leu/thesimplecloud/launcher/console/ConsoleSender;", "hasActiveSetup", "", "hasNextQuestion", "setupData", "nextQuestion", "onResponse", "response", "printCurrentQuestion", "queueSetup", "setup", "Leu/thesimplecloud/launcher/console/setup/ISetup;", "first", "resetSetup", "startSetup", "waitForAllSetups", "SetupData", "SetupQuestionData", "simplecloud-launcher"})
@SourceDebugExtension(value={"SMAP\nSetupManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SetupManager.kt\neu/thesimplecloud/launcher/console/setup/SetupManager\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,232:1\n3792#2:233\n4307#2,2:234\n3792#2:239\n4307#2,2:240\n3792#2:242\n4307#2,2:243\n1855#3:236\n1856#3:238\n1045#3:245\n766#3:246\n857#3,2:247\n1#4:237\n*S KotlinDebug\n*F\n+ 1 SetupManager.kt\neu/thesimplecloud/launcher/console/setup/SetupManager\n*L\n51#1:233\n51#1:234,2\n62#1:239\n62#1:240,2\n63#1:242\n63#1:243,2\n51#1:236\n51#1:238\n72#1:245\n209#1:246\n209#1:247,2\n*E\n"})
public final class SetupManager {
    @NotNull
    private final Launcher launcher;
    @NotNull
    private final LoggerProvider logger;
    @NotNull
    private final ArrayList<SetupData> setupQueue;
    @Nullable
    private SetupData currentSetup;
    @Nullable
    private SetupQuestionData currentQuestion;
    private int currentQuestionIndex;
    @NotNull
    private CommunicationPromise<Unit> setupsCompletedPromise;

    public SetupManager(@NotNull Launcher launcher) {
        Intrinsics.checkNotNullParameter((Object)launcher, (String)"launcher");
        this.launcher = launcher;
        this.logger = this.launcher.getLogger();
        this.setupQueue = new ArrayList();
        this.setupsCompletedPromise = new CommunicationPromise(false);
    }

    @NotNull
    public final Launcher getLauncher() {
        return this.launcher;
    }

    @NotNull
    public final LoggerProvider getLogger() {
        return this.logger;
    }

    @NotNull
    public final ArrayList<SetupData> getSetupQueue() {
        return this.setupQueue;
    }

    @Nullable
    public final SetupData getCurrentSetup() {
        return this.currentSetup;
    }

    public final void setCurrentSetup(@Nullable SetupData setupData) {
        this.currentSetup = setupData;
    }

    @Nullable
    public final SetupQuestionData getCurrentQuestion() {
        return this.currentQuestion;
    }

    /*
     * WARNING - void declaration
     */
    public final void queueSetup(@NotNull ISetup setup, boolean first) {
        Method it;
        void $this$filterTo$iv$iv;
        void $this$filterTo$iv$iv2;
        int $i$a$-check-SetupManager$queueSetup$2$22;
        Object element$iv2;
        void $this$forEach$iv;
        Iterator $this$filterTo$iv$iv3;
        Intrinsics.checkNotNullParameter((Object)setup, (String)"setup");
        ArrayList<SetupQuestionData> questions = new ArrayList<SetupQuestionData>();
        Method[] methods = setup.getClass().getMethods();
        Intrinsics.checkNotNullExpressionValue((Object)methods, (String)"methods");
        Object $this$filter$iv = methods;
        boolean $i$f$filter = false;
        Method[] methodArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        int n = ((void)$this$filterTo$iv$iv3).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it2 = element$iv$iv = $this$filterTo$iv$iv3[i];
            boolean bl = false;
            if (!it2.isAnnotationPresent(SetupQuestion.class)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv2 : $this$forEach$iv) {
            Method method = (Method)element$iv2;
            boolean bl = false;
            if (!(method.getParameters().length == 1)) {
                $i$a$-check-SetupManager$queueSetup$2$22 = 0;
                String $i$a$-check-SetupManager$queueSetup$2$22 = "Function marked with SetupQuestion must have one parameter.";
                throw new IllegalStateException($i$a$-check-SetupManager$queueSetup$2$22.toString());
            }
            SetupQuestion setupQuestion = method.getAnnotation(SetupQuestion.class);
            Intrinsics.checkNotNullExpressionValue((Object)setupQuestion, (String)"method.getAnnotation(SetupQuestion::class.java)");
            Intrinsics.checkNotNullExpressionValue((Object)method, (String)"method");
            Parameter parameter = method.getParameters()[0];
            Intrinsics.checkNotNullExpressionValue((Object)parameter, (String)"method.parameters[0]");
            questions.add(new SetupQuestionData(setupQuestion, method, parameter));
        }
        Method[] $this$filter$iv2 = methods;
        boolean $i$f$filter2 = false;
        element$iv2 = $this$filter$iv2;
        Method[] destination$iv$iv2 = (Method[])new ArrayList();
        boolean $i$f$filterTo2 = false;
        int element$iv$iv = ((void)$this$filterTo$iv$iv2).length;
        for ($i$a$-check-SetupManager$queueSetup$2$22 = 0; $i$a$-check-SetupManager$queueSetup$2$22 < element$iv$iv; ++$i$a$-check-SetupManager$queueSetup$2$22) {
            void element$iv$iv2;
            void it3 = element$iv$iv2 = $this$filterTo$iv$iv2[$i$a$-check-SetupManager$queueSetup$2$22];
            boolean bl = false;
            if (!it3.isAnnotationPresent(SetupFinished.class)) continue;
            destination$iv$iv2.add(element$iv$iv2);
        }
        List setupFinishedMethods = (List)destination$iv$iv2;
        Method[] $this$filter$iv3 = methods;
        boolean $i$f$filter3 = false;
        destination$iv$iv2 = $this$filter$iv3;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterTo3 = false;
        int n2 = ((void)$this$filterTo$iv$iv).length;
        for (element$iv$iv = 0; element$iv$iv < n2; ++element$iv$iv) {
            void element$iv$iv3;
            void it4 = element$iv$iv3 = $this$filterTo$iv$iv[element$iv$iv];
            boolean bl = false;
            if (!it4.isAnnotationPresent(SetupCancelled.class)) continue;
            destination$iv$iv3.add(element$iv$iv3);
        }
        List setupCancelledMethods = (List)destination$iv$iv3;
        if (!(setupFinishedMethods.size() <= 1)) {
            boolean $i$a$-check-SetupManager$queueSetup$52 = false;
            String $i$a$-check-SetupManager$queueSetup$52 = "Only one function in a setup can be marked with SetupFinished.";
            throw new IllegalStateException($i$a$-check-SetupManager$queueSetup$52.toString());
        }
        if (!(setupCancelledMethods.size() <= 1)) {
            boolean $i$a$-check-SetupManager$queueSetup$62 = false;
            String $i$a$-check-SetupManager$queueSetup$62 = "Only one function in a setup can be marked with SetupCancelled.";
            throw new IllegalStateException($i$a$-check-SetupManager$queueSetup$62.toString());
        }
        Method finishedMethod = (Method)CollectionsKt.firstOrNull((List)setupFinishedMethods);
        Method cancelledMethod = (Method)CollectionsKt.firstOrNull((List)setupCancelledMethods);
        Method method = finishedMethod;
        if (method != null) {
            it = method;
            boolean bl = false;
            Parameter[] parameterArray = it.getParameters();
            Intrinsics.checkNotNullExpressionValue((Object)parameterArray, (String)"it.parameters");
            if (!(((Object[])parameterArray).length == 0)) {
                boolean $i$a$-check-SetupManager$queueSetup$5$22 = false;
                String $i$a$-check-SetupManager$queueSetup$5$22 = "The function marked with SetupFinished must have 0 parameters.";
                throw new IllegalStateException($i$a$-check-SetupManager$queueSetup$5$22.toString());
            }
        }
        Method method2 = cancelledMethod;
        if (method2 != null) {
            it = method2;
            boolean bl = false;
            Parameter[] parameterArray = it.getParameters();
            Intrinsics.checkNotNullExpressionValue((Object)parameterArray, (String)"it.parameters");
            if (!(((Object[])parameterArray).length == 0)) {
                boolean bl2 = false;
                String string = "The function marked with SetupFinished must have 0 parameters.";
                throw new IllegalStateException(string.toString());
            }
        }
        Iterable $this$sortedBy$iv = questions;
        boolean $i$f$sortedBy = false;
        SetupData setupData = new SetupData(setup, cancelledMethod, finishedMethod, CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                SetupQuestionData it = (SetupQuestionData)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getSetupQuestion().number());
                it = (SetupQuestionData)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getSetupQuestion().number()));
            }
        }));
        if (this.currentSetup == null) {
            this.startSetup(setupData);
            return;
        }
        if (first) {
            this.setupQueue.add(0, setupData);
        } else {
            this.setupQueue.add(setupData);
        }
    }

    public static /* synthetic */ void queueSetup$default(SetupManager setupManager, ISetup iSetup, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        setupManager.queueSetup(iSetup, bl);
    }

    public final boolean hasActiveSetup() {
        return this.currentSetup != null;
    }

    private final void startSetup(SetupData setupData) {
        this.currentSetup = setupData;
        this.currentQuestion = setupData.getQuestions().get(this.currentQuestionIndex);
        Launcher.Companion.getInstance().clearConsole();
        Launcher.Companion.getInstance().getLogger().setup("Setup started. Type `exit` to leave the setup.");
        this.printCurrentQuestion();
    }

    private final void printCurrentQuestion() {
        SetupQuestionData setupQuestionData = this.currentQuestion;
        if (setupQuestionData == null) {
            throw new IllegalStateException("There is no setup at the moment");
        }
        SetupQuestionData currentQuestion = setupQuestionData;
        ISetupAnswerProvider suggestionProvider = currentQuestion.getSetupQuestion().answerProvider().newInstance();
        List<String> suggestions = IterableExtensionKt.replace((Iterable)suggestionProvider.getSuggestions(this.launcher.getConsoleSender()), "", "<empty>");
        String suffix = !((Collection)suggestions).isEmpty() ? "\u00a7ePossible answers: " + CollectionsKt.joinToString$default((Iterable)suggestions, null, null, null, (int)0, null, null, (int)63, null) : "";
        if (((CharSequence)suffix).length() == 0) {
            this.launcher.getConsoleSender().sendPropertyInSetup(currentQuestion.getSetupQuestion().property(), new String[0]);
        } else {
            this.launcher.getConsoleSender().sendPropertyInSetup(currentQuestion.getSetupQuestion().property(), new String[0]);
            Launcher.Companion.getInstance().getLogger().setup(suffix);
        }
    }

    public final void onResponse(@NotNull String response) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        SetupQuestionData setupQuestionData = this.currentQuestion;
        if (setupQuestionData == null) {
            return;
        }
        SetupQuestionData currentQuestion = setupQuestionData;
        StringParser stringParser = new StringParser();
        Class<?> clazz = currentQuestion.getParameter().getType();
        Intrinsics.checkNotNullExpressionValue(clazz, (String)"currentQuestion.parameter.type");
        Object parsedValue = stringParser.parseToObject(response, clazz);
        Collection<String> possibleAnswers = currentQuestion.getSetupQuestion().answerProvider().newInstance().getSuggestions(this.launcher.getConsoleSender());
        if (parsedValue instanceof String && !possibleAnswers.isEmpty() && !StringIterableExtensionKt.containsIgnoreCase((Iterable<String>)possibleAnswers, (String)parsedValue)) {
            Launcher.Companion.getInstance().getLogger().setup("Invalid response");
            return;
        }
        try {
            Method method = currentQuestion.getMethod();
            SetupData setupData = this.currentSetup;
            Intrinsics.checkNotNull((Object)setupData);
            object = new Object[]{parsedValue};
            object = method.invoke((Object)setupData.getSource(), object);
        }
        catch (Exception e) {
            Launcher.Companion.getInstance().getLogger().setup("Invalid response");
            return;
        }
        Object invokeResponse = object;
        if (invokeResponse instanceof Boolean && Intrinsics.areEqual((Object)invokeResponse, (Object)false)) {
            return;
        }
        this.nextQuestion();
    }

    private final void nextQuestion() {
        SetupData setupData = this.currentSetup;
        if (setupData == null) {
            return;
        }
        SetupData activeSetup = setupData;
        if (!this.hasNextQuestion(activeSetup)) {
            this.finishCurrentSetup();
            return;
        }
        int n = this.currentQuestionIndex;
        this.currentQuestionIndex = n + 1;
        this.currentQuestion = activeSetup.getQuestions().get(this.currentQuestionIndex);
        this.printCurrentQuestion();
    }

    public final void finishCurrentSetup() {
        Launcher.Companion.getInstance().clearConsole();
        SetupData currentSetupReference = this.currentSetup;
        this.resetSetup();
        if (this.setupQueue.isEmpty()) {
            Launcher.Companion.getInstance().getLogger().printCachedMessages();
        }
        SetupData setupData = currentSetupReference;
        if (setupData != null) {
            setupData.callFinishedMethod();
        }
        this.logger.success("Setup completed.");
        this.checkForNextSetup();
    }

    public final void cancelCurrentSetup() {
        Launcher.Companion.getInstance().clearConsole();
        SetupData currentSetupReference = this.currentSetup;
        this.resetSetup();
        if (this.setupQueue.isEmpty()) {
            Launcher.Companion.getInstance().getLogger().printCachedMessages();
        }
        SetupData setupData = currentSetupReference;
        if (setupData != null) {
            setupData.callCancelledMethod();
        }
        this.logger.warning("Setup cancelled.");
        this.checkForNextSetup();
    }

    private final void checkForNextSetup() {
        if (this.setupQueue.isEmpty()) {
            this.setupsCompletedPromise.trySuccess((Object)Unit.INSTANCE);
            this.setupsCompletedPromise = new CommunicationPromise(false);
        }
        if (!((Collection)this.setupQueue).isEmpty()) {
            SetupData setupData = this.setupQueue.remove(0);
            Intrinsics.checkNotNullExpressionValue((Object)setupData, (String)"this.setupQueue.removeAt(0)");
            this.startSetup(setupData);
        }
    }

    private final void resetSetup() {
        this.currentSetup = null;
        this.currentQuestion = null;
        this.currentQuestionIndex = 0;
    }

    private final boolean hasNextQuestion(SetupData setupData) {
        int n = setupData.getQuestions().size();
        int n2 = this.currentQuestionIndex + 1;
        return 0 <= n2 ? n2 < n : false;
    }

    public final void waitForAllSetups() {
        if (this.currentSetup != null) {
            this.setupsCompletedPromise.awaitUninterruptibly();
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getSetupSuggestions(@NotNull String userInput, @NotNull ConsoleSender consoleSender) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)userInput, (String)"userInput");
        Intrinsics.checkNotNullParameter((Object)consoleSender, (String)"consoleSender");
        if (!this.hasActiveSetup()) {
            throw new IllegalStateException("There is no active setup");
        }
        SetupQuestionData setupQuestionData = this.currentQuestion;
        Intrinsics.checkNotNull((Object)setupQuestionData);
        Collection<String> suggestions = setupQuestionData.getSetupQuestion().answerProvider().newInstance().getSuggestions(consoleSender);
        Iterable $this$filter$iv = suggestions;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            String string = it.toLowerCase();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase()");
            String string2 = userInput.toLowerCase();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase()");
            if (!StringsKt.startsWith$default((String)string, (String)string2, (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\u0013R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0015"}, d2={"Leu/thesimplecloud/launcher/console/setup/SetupManager$SetupData;", "", "source", "Leu/thesimplecloud/launcher/console/setup/ISetup;", "cancelledMethod", "Ljava/lang/reflect/Method;", "finishedMethod", "questions", "", "Leu/thesimplecloud/launcher/console/setup/SetupManager$SetupQuestionData;", "(Leu/thesimplecloud/launcher/console/setup/ISetup;Ljava/lang/reflect/Method;Ljava/lang/reflect/Method;Ljava/util/List;)V", "getCancelledMethod", "()Ljava/lang/reflect/Method;", "getFinishedMethod", "getQuestions", "()Ljava/util/List;", "getSource", "()Leu/thesimplecloud/launcher/console/setup/ISetup;", "callCancelledMethod", "", "callFinishedMethod", "simplecloud-launcher"})
    public static final class SetupData {
        @NotNull
        private final ISetup source;
        @Nullable
        private final Method cancelledMethod;
        @Nullable
        private final Method finishedMethod;
        @NotNull
        private final List<SetupQuestionData> questions;

        public SetupData(@NotNull ISetup source, @Nullable Method cancelledMethod, @Nullable Method finishedMethod, @NotNull List<SetupQuestionData> questions) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            Intrinsics.checkNotNullParameter(questions, (String)"questions");
            this.source = source;
            this.cancelledMethod = cancelledMethod;
            this.finishedMethod = finishedMethod;
            this.questions = questions;
        }

        @NotNull
        public final ISetup getSource() {
            return this.source;
        }

        @Nullable
        public final Method getCancelledMethod() {
            return this.cancelledMethod;
        }

        @Nullable
        public final Method getFinishedMethod() {
            return this.finishedMethod;
        }

        @NotNull
        public final List<SetupQuestionData> getQuestions() {
            return this.questions;
        }

        public final void callFinishedMethod() {
            block0: {
                Method method = this.finishedMethod;
                if (method == null) break block0;
                method.invoke((Object)this.source, new Object[0]);
            }
        }

        public final void callCancelledMethod() {
            block0: {
                Method method = this.cancelledMethod;
                if (method == null) break block0;
                method.invoke((Object)this.source, new Object[0]);
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Leu/thesimplecloud/launcher/console/setup/SetupManager$SetupQuestionData;", "", "setupQuestion", "Leu/thesimplecloud/launcher/console/setup/annotations/SetupQuestion;", "method", "Ljava/lang/reflect/Method;", "parameter", "Ljava/lang/reflect/Parameter;", "(Leu/thesimplecloud/launcher/console/setup/annotations/SetupQuestion;Ljava/lang/reflect/Method;Ljava/lang/reflect/Parameter;)V", "getMethod", "()Ljava/lang/reflect/Method;", "getParameter", "()Ljava/lang/reflect/Parameter;", "getSetupQuestion", "()Leu/thesimplecloud/launcher/console/setup/annotations/SetupQuestion;", "simplecloud-launcher"})
    public static final class SetupQuestionData {
        @NotNull
        private final SetupQuestion setupQuestion;
        @NotNull
        private final Method method;
        @NotNull
        private final Parameter parameter;

        public SetupQuestionData(@NotNull SetupQuestion setupQuestion, @NotNull Method method, @NotNull Parameter parameter) {
            Intrinsics.checkNotNullParameter((Object)setupQuestion, (String)"setupQuestion");
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
            this.setupQuestion = setupQuestion;
            this.method = method;
            this.parameter = parameter;
        }

        @NotNull
        public final SetupQuestion getSetupQuestion() {
            return this.setupQuestion;
        }

        @NotNull
        public final Method getMethod() {
            return this.method;
        }

        @NotNull
        public final Parameter getParameter() {
            return this.parameter;
        }
    }
}

