/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.launcher.external;

import eu.thesimplecloud.launcher.startup.Launcher;
import java.io.File;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.net.URLClassLoader;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J,\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005J)\u0010\u000b\u001a\u00028\u00002\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0002\u0010\f\u00a8\u0006\r"}, d2={"Leu/thesimplecloud/launcher/external/ExtensionLoader;", "C", "", "()V", "loadClass", "Ljava/lang/Class;", "jar", "Ljava/io/File;", "classpath", "", "parentClass", "loadClassInstance", "(Ljava/io/File;Ljava/lang/String;Ljava/lang/Class;)Ljava/lang/Object;", "simplecloud-launcher"})
public final class ExtensionLoader<C> {
    public final C loadClassInstance(@NotNull File jar, @NotNull String classpath, @NotNull Class<C> parentClass) {
        Intrinsics.checkNotNullParameter((Object)jar, (String)"jar");
        Intrinsics.checkNotNullParameter((Object)classpath, (String)"classpath");
        Intrinsics.checkNotNullParameter(parentClass, (String)"parentClass");
        Class<C> newClass = this.loadClass(jar, classpath, parentClass);
        Constructor<C> constructor = newClass.getConstructor(new Class[0]);
        return constructor.newInstance(new Object[0]);
    }

    @NotNull
    public final Class<? extends C> loadClass(@NotNull File jar, @NotNull String classpath, @NotNull Class<C> parentClass) {
        Intrinsics.checkNotNullParameter((Object)jar, (String)"jar");
        Intrinsics.checkNotNullParameter((Object)classpath, (String)"classpath");
        Intrinsics.checkNotNullParameter(parentClass, (String)"parentClass");
        URL[] uRLArray = new URL[]{jar.toURI().toURL()};
        URLClassLoader urlClassLoader = new URLClassLoader(uRLArray, Launcher.Companion.getInstance().getCurrentClassLoader());
        Class<?> clazz = Class.forName(classpath, true, urlClassLoader);
        Class<C> clazz2 = clazz.asSubclass(parentClass);
        Intrinsics.checkNotNullExpressionValue(clazz2, (String)"clazz.asSubclass<C>(parentClass)");
        return clazz2;
    }
}

