/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.launcher.external.module.handler;

import eu.thesimplecloud.api.directorypaths.DirectoryPaths;
import eu.thesimplecloud.api.external.ICloudModule;
import eu.thesimplecloud.jsonlib.JsonLib;
import eu.thesimplecloud.launcher.exception.module.ModuleLoadException;
import eu.thesimplecloud.launcher.external.module.LoadedModule;
import eu.thesimplecloud.launcher.external.module.LoadedModuleFileContent;
import eu.thesimplecloud.launcher.external.module.ModuleClassLoader;
import eu.thesimplecloud.launcher.external.module.ModuleFileContent;
import eu.thesimplecloud.launcher.external.module.handler.IModuleHandler;
import eu.thesimplecloud.launcher.external.module.handler.ModuleLanguageFileLoader;
import eu.thesimplecloud.launcher.external.module.handler.ModuleListLoader;
import eu.thesimplecloud.launcher.external.module.handler.ModuleUpdateInstaller;
import eu.thesimplecloud.launcher.external.module.handler.UnsafeModuleUnloader;
import eu.thesimplecloud.launcher.external.module.update.UpdaterFileContent;
import eu.thesimplecloud.launcher.startup.Launcher;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u0010\u0018\u00002\u00020\u0001BI\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\u0014\b\u0002\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u001a\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020\r2\u0006\u0010!\u001a\u00020\u0016H\u0002J\u0014\u0010\"\u001a\u0006\u0012\u0002\b\u00030#2\u0006\u0010$\u001a\u00020\u0005H\u0016J\u0014\u0010%\u001a\u0006\u0012\u0002\b\u00030#2\u0006\u0010$\u001a\u00020\u0005H\u0016J\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00190\u0007J\u000e\u0010'\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0007H\u0002J\u0012\u0010(\u001a\u0004\u0018\u00010\u00162\u0006\u0010)\u001a\u00020*H\u0016J\u0012\u0010+\u001a\u0004\u0018\u00010\u00162\u0006\u0010$\u001a\u00020\u0005H\u0016J\u000e\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00160\u0007H\u0016J\b\u0010-\u001a\u00020\rH\u0016J*\u0010.\u001a\u0002H/\"\n\b\u0000\u0010/\u0018\u0001*\u0002002\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u00101\u001a\u00020\u0005H\u0082\b\u00a2\u0006\u0002\u00102J\u0010\u00103\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0018\u00103\u001a\u00020\u001f2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u00104\u001a\u00020\u0005H\u0016J\u001c\u00105\u001a\b\u0012\u0004\u0012\u00020\u00160\u00072\f\u00106\u001a\b\u0012\u0004\u0012\u00020\u00190\u0007H\u0016J\u001c\u00107\u001a\b\u0012\u0004\u0012\u00020\u00160\u00072\f\u00108\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0007H\u0016J\u0010\u00109\u001a\u00020\r2\u0006\u0010:\u001a\u00020\u0016H\u0002J(\u0010;\u001a\u00020\r2\u001e\u0010<\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u0011\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00130\u0010H\u0016J\b\u0010=\u001a\u00020\rH\u0016J\b\u0010>\u001a\u00020\rH\u0016J\u0010\u0010?\u001a\u00020\r2\u0006\u0010)\u001a\u00020*H\u0016J\u0010\u0010?\u001a\u00020\r2\u0006\u0010:\u001a\u00020\u0016H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u000f\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u0011\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00130\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Leu/thesimplecloud/launcher/external/module/handler/ModuleHandler;", "Leu/thesimplecloud/launcher/external/module/handler/IModuleHandler;", "parentClassLoader", "Ljava/lang/ClassLoader;", "currentLanguage", "", "modulesWithPermissionToUpdate", "", "checkForUpdates", "", "handleLoadError", "Lkotlin/Function1;", "", "", "(Ljava/lang/ClassLoader;Ljava/lang/String;Ljava/util/List;ZLkotlin/jvm/functions/Function1;)V", "createModuleClassLoaderFunction", "Lkotlin/Function2;", "", "Ljava/net/URL;", "Ljava/net/URLClassLoader;", "loadedModules", "", "Leu/thesimplecloud/launcher/external/module/LoadedModule;", "checkForUpdate", "loadedModuleFileContent", "Leu/thesimplecloud/launcher/external/module/LoadedModuleFileContent;", "checkPermissionAndLoadUpdaterFile", "Leu/thesimplecloud/launcher/external/module/update/UpdaterFileContent;", "file", "Ljava/io/File;", "moduleFileContent", "Leu/thesimplecloud/launcher/external/module/ModuleFileContent;", "enableModule", "module", "findModuleClass", "Ljava/lang/Class;", "name", "findModuleOrSystemClass", "getAllCloudModuleFileContents", "getAllModuleJarFiles", "getLoadedModuleByCloudModule", "cloudModule", "Leu/thesimplecloud/api/external/ICloudModule;", "getLoadedModuleByName", "getLoadedModules", "loadAllUnloadedModules", "loadJsonFileInJar", "T", "", "path", "(Ljava/io/File;Ljava/lang/String;)Ljava/lang/Object;", "loadModuleFileContent", "moduleFileName", "loadModuleList", "modulesToLoad", "loadModuleListFromFiles", "files", "registerLanguageFile", "loadedModule", "setCreateModuleClassLoader", "function", "unloadAllModules", "unloadAllReloadableModules", "unloadModule", "simplecloud-launcher"})
@SourceDebugExtension(value={"SMAP\nModuleHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModuleHandler.kt\neu/thesimplecloud/launcher/external/module/handler/ModuleHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,208:1\n176#1:233\n177#1,11:235\n176#1:259\n177#1,11:261\n288#2,2:209\n288#2,2:211\n1855#2,2:213\n766#2:215\n857#2,2:216\n1855#2,2:218\n1603#2,9:220\n1855#2:229\n1856#2:231\n1612#2:232\n1549#2:246\n1620#2,3:247\n1549#2:250\n1620#2,3:251\n1855#2,2:254\n1855#2,2:256\n1549#2:275\n1620#2,3:276\n1#3:230\n1#3:234\n1#3:258\n1#3:260\n3792#4:272\n4307#4,2:273\n*S KotlinDebug\n*F\n+ 1 ModuleHandler.kt\neu/thesimplecloud/launcher/external/module/handler/ModuleHandler\n*L\n117#1:233\n117#1:235,11\n196#1:259\n196#1:261,11\n62#1:209,2\n66#1:211,2\n76#1:213,2\n80#1:215\n80#1:216,2\n80#1:218,2\n93#1:220,9\n93#1:229\n93#1:231\n93#1:232\n121#1:246\n121#1:247,3\n122#1:250\n122#1:251,3\n146#1:254,2\n147#1:256,2\n204#1:275\n204#1:276,3\n93#1:230\n117#1:234\n196#1:260\n200#1:272\n200#1:273,2\n*E\n"})
public final class ModuleHandler
implements IModuleHandler {
    @NotNull
    private final ClassLoader parentClassLoader;
    @NotNull
    private final String currentLanguage;
    @NotNull
    private final List<String> modulesWithPermissionToUpdate;
    private final boolean checkForUpdates;
    @NotNull
    private final Function1<Throwable, Unit> handleLoadError;
    @NotNull
    private final List<LoadedModule> loadedModules;
    @NotNull
    private Function2<? super URL[], ? super String, ? extends URLClassLoader> createModuleClassLoaderFunction;

    public ModuleHandler(@NotNull ClassLoader parentClassLoader, @NotNull String currentLanguage, @NotNull List<String> modulesWithPermissionToUpdate, boolean checkForUpdates, @NotNull Function1<? super Throwable, Unit> handleLoadError) {
        Intrinsics.checkNotNullParameter((Object)parentClassLoader, (String)"parentClassLoader");
        Intrinsics.checkNotNullParameter((Object)currentLanguage, (String)"currentLanguage");
        Intrinsics.checkNotNullParameter(modulesWithPermissionToUpdate, (String)"modulesWithPermissionToUpdate");
        Intrinsics.checkNotNullParameter(handleLoadError, (String)"handleLoadError");
        this.parentClassLoader = parentClassLoader;
        this.currentLanguage = currentLanguage;
        this.modulesWithPermissionToUpdate = modulesWithPermissionToUpdate;
        this.checkForUpdates = checkForUpdates;
        this.handleLoadError = handleLoadError;
        this.loadedModules = new CopyOnWriteArrayList();
        this.createModuleClassLoaderFunction = (Function2)new Function2<URL[], String, ModuleClassLoader>(this){
            final /* synthetic */ ModuleHandler this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            @NotNull
            public final ModuleClassLoader invoke(@NotNull URL[] args, @NotNull String name) {
                Intrinsics.checkNotNullParameter((Object)args, (String)"args");
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                return new ModuleClassLoader(args, ModuleHandler.access$getParentClassLoader$p(this.this$0), name, this.this$0);
            }
        };
    }

    public /* synthetic */ ModuleHandler(ClassLoader classLoader, String string, List list, boolean bl, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            ClassLoader classLoader2 = ClassLoader.getSystemClassLoader();
            Intrinsics.checkNotNullExpressionValue((Object)classLoader2, (String)"getSystemClassLoader()");
            classLoader = classLoader2;
        }
        if ((n & 2) != 0) {
            string = "en";
        }
        if ((n & 4) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        if ((n & 0x10) != 0) {
            function1 = 1.INSTANCE;
        }
        this(classLoader, string, list, bl, (Function1<? super Throwable, Unit>)function1);
    }

    @Override
    public void loadAllUnloadedModules() {
        this.loadModuleListFromFiles(this.getAllModuleJarFiles());
    }

    @Override
    @Nullable
    public LoadedModule getLoadedModuleByName(@NotNull String name) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Iterable $this$firstOrNull$iv = this.loadedModules;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                LoadedModule it = (LoadedModule)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)name)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @Override
    @Nullable
    public LoadedModule getLoadedModuleByCloudModule(@NotNull ICloudModule cloudModule) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)cloudModule, (String)"cloudModule");
            Iterable $this$firstOrNull$iv = this.loadedModules;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                LoadedModule it = (LoadedModule)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getCloudModule(), (Object)cloudModule)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @Override
    public void unloadModule(@NotNull ICloudModule cloudModule) {
        Intrinsics.checkNotNullParameter((Object)cloudModule, (String)"cloudModule");
        LoadedModule loadedModule = this.getLoadedModuleByCloudModule(cloudModule);
        if (loadedModule == null) {
            throw new IllegalArgumentException("Specified cloud module is not registered");
        }
        LoadedModule loadedModule2 = loadedModule;
        this.unloadModule(loadedModule2);
    }

    @Override
    public void unloadAllModules() {
        Iterable $this$forEach$iv = this.loadedModules;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LoadedModule it = (LoadedModule)element$iv;
            boolean bl = false;
            this.unloadModule(it);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void unloadAllReloadableModules() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.loadedModules;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            LoadedModule it = (LoadedModule)element$iv$iv;
            boolean bl = false;
            if (!it.getCloudModule().isReloadable()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LoadedModule it = (LoadedModule)element$iv;
            boolean bl = false;
            this.unloadModule(it);
        }
    }

    @Override
    @NotNull
    public List<LoadedModule> getLoadedModules() {
        return this.loadedModules;
    }

    private final void unloadModule(LoadedModule loadedModule) {
        new UnsafeModuleUnloader(loadedModule).unload();
        this.loadedModules.remove(loadedModule);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Class<?> findModuleClass(@NotNull String name) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Iterable $this$mapNotNull$iv = this.loadedModules;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Class it$iv$iv;
            Object object;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            LoadedModule it = (LoadedModule)element$iv$iv;
            boolean bl2 = false;
            Object object2 = this;
            try {
                ModuleHandler $this$findModuleClass_u24lambda_u246_u24lambda_u245 = object2;
                boolean bl3 = false;
                ClassLoader classLoader = it.getModuleClassLoader();
                Intrinsics.checkNotNull((Object)classLoader, (String)"null cannot be cast to non-null type eu.thesimplecloud.launcher.external.module.ModuleClassLoader");
                object = Result.constructor-impl(((ModuleClassLoader)classLoader).findClass0(name, false));
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            object2 = object;
            if ((Class)(Result.isFailure-impl((Object)object2) ? null : object2) == null) continue;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List mapNotNull = (List)destination$iv$iv;
        Class clazz = (Class)CollectionsKt.firstOrNull((List)mapNotNull);
        if (clazz == null) {
            throw new ClassNotFoundException(name);
        }
        return clazz;
    }

    @Override
    @NotNull
    public Class<?> findModuleOrSystemClass(@NotNull String name) {
        Class clazz;
        Object $i$a$-runCatching-ModuleHandler$findModuleOrSystemClass$clazz$22;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        try {
            boolean $i$a$-runCatching-ModuleHandler$findModuleOrSystemClass$clazz$22 = false;
            $i$a$-runCatching-ModuleHandler$findModuleOrSystemClass$clazz$22 = Result.constructor-impl(this.findModuleClass(name));
        }
        catch (Throwable throwable) {
            $i$a$-runCatching-ModuleHandler$findModuleOrSystemClass$clazz$22 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        Class clazz2 = clazz = (Class)(Result.isFailure-impl((Object)$i$a$-runCatching-ModuleHandler$findModuleOrSystemClass$clazz$22) ? null : $i$a$-runCatching-ModuleHandler$findModuleOrSystemClass$clazz$22);
        if (clazz2 != null) {
            return clazz2;
        }
        ClassLoader classLoader = Launcher.Companion.getInstance().getCurrentClassLoader();
        Class<?> clazz3 = Class.forName(name, true, classLoader);
        Intrinsics.checkNotNullExpressionValue(clazz3, (String)"forName(name, true, classLoader)");
        return clazz3;
    }

    @Override
    public void setCreateModuleClassLoader(@NotNull Function2<? super URL[], ? super String, ? extends URLClassLoader> function) {
        Intrinsics.checkNotNullParameter(function, (String)"function");
        this.createModuleClassLoaderFunction = function;
    }

    @Override
    @NotNull
    public ModuleFileContent loadModuleFileContent(@NotNull File file, @NotNull String moduleFileName) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)moduleFileName, (String)"moduleFileName");
        ModuleHandler this_$iv = this;
        boolean $i$f$loadJsonFileInJar = false;
        if (!file.exists()) {
            boolean $i$a$-require-ModuleHandler$loadJsonFileInJar$1$iv22 = false;
            String $i$a$-require-ModuleHandler$loadJsonFileInJar$1$iv22 = "Specified file to load " + moduleFileName + " from does not exist: " + file.getPath();
            throw new IllegalArgumentException($i$a$-require-ModuleHandler$loadJsonFileInJar$1$iv22.toString());
        }
        try {
            JarFile jar$iv = new JarFile(file);
            JarEntry jarEntry = jar$iv.getJarEntry(moduleFileName);
            if (jarEntry == null) {
                throw new ModuleLoadException(file.getPath() + ": No '" + moduleFileName + "' found.");
            }
            JarEntry entry$iv = jarEntry;
            InputStream fileStream$iv = jar$iv.getInputStream(entry$iv);
            Intrinsics.checkNotNullExpressionValue((Object)fileStream$iv, (String)"fileStream");
            JsonLib jsonLib$iv = JsonLib.Companion.fromInputStream(fileStream$iv);
            jar$iv.close();
            if (jsonLib$iv.getObjectOrNull(ModuleFileContent.class) == null) {
                throw new ModuleLoadException(file.getPath() + ": Invalid '" + moduleFileName + "'.");
            }
        }
        catch (Exception ex$iv) {
            String string = file.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.path");
            throw new ModuleLoadException(string, ex$iv);
        }
        return (ModuleFileContent)object;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<LoadedModule> loadModuleListFromFiles(@NotNull List<? extends File> files) {
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter(files, (String)"files");
        Iterable $this$map$iv = files;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            File file = (File)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.loadModuleFileContent((File)it));
        }
        List modules = (List)destination$iv$iv;
        Iterable $this$map$iv2 = modules;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            LoadedModuleFileContent bl = (LoadedModuleFileContent)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add(this.checkForUpdates && this.checkForUpdate((LoadedModuleFileContent)it) ? this.loadModuleFileContent(it.getFile()) : it);
        }
        List updatedModuleList = (List)destination$iv$iv2;
        return this.loadModuleList(updatedModuleList);
    }

    private final boolean checkForUpdate(LoadedModuleFileContent loadedModuleFileContent) {
        return new ModuleUpdateInstaller(loadedModuleFileContent).updateIfAvailable();
    }

    @Override
    @NotNull
    public List<LoadedModule> loadModuleList(@NotNull List<LoadedModuleFileContent> modulesToLoad) {
        LoadedModule it;
        Intrinsics.checkNotNullParameter(modulesToLoad, (String)"modulesToLoad");
        ModuleListLoader moduleListLoader = new ModuleListLoader(modulesToLoad, this.loadedModules, this.createModuleClassLoaderFunction, this.handleLoadError);
        List<LoadedModule> newModules = moduleListLoader.loadModules();
        this.loadedModules.addAll((Collection<LoadedModule>)newModules);
        Iterable $this$forEach$iv = newModules;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (LoadedModule)element$iv;
            boolean bl = false;
            this.registerLanguageFile(it);
        }
        $this$forEach$iv = newModules;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (LoadedModule)element$iv;
            boolean bl = false;
            this.enableModule(it);
        }
        return newModules;
    }

    private final void registerLanguageFile(LoadedModule loadedModule) {
        new ModuleLanguageFileLoader(this.currentLanguage, loadedModule.getFile(), loadedModule.getCloudModule()).registerLanguageFileIfExist();
    }

    private final void enableModule(LoadedModule module) {
        try {
            module.getCloudModule().onEnable();
        }
        catch (Exception e) {
            this.handleLoadError.invoke((Object)e);
        }
    }

    private final LoadedModuleFileContent loadModuleFileContent(File file) {
        ModuleFileContent moduleFileContent = this.loadModuleFileContent(file, "module.json");
        UpdaterFileContent updaterFileContent = this.checkPermissionAndLoadUpdaterFile(file, moduleFileContent);
        return new LoadedModuleFileContent(file, moduleFileContent, updaterFileContent);
    }

    private final /* synthetic */ <T> T loadJsonFileInJar(File file, String path) {
        boolean $i$f$loadJsonFileInJar = false;
        if (!file.exists()) {
            boolean $i$a$-require-ModuleHandler$loadJsonFileInJar$22 = false;
            String $i$a$-require-ModuleHandler$loadJsonFileInJar$22 = "Specified file to load " + path + " from does not exist: " + file.getPath();
            throw new IllegalArgumentException($i$a$-require-ModuleHandler$loadJsonFileInJar$22.toString());
        }
        try {
            JarFile jar = new JarFile(file);
            JarEntry jarEntry = jar.getJarEntry(path);
            if (jarEntry == null) {
                throw new ModuleLoadException(file.getPath() + ": No '" + path + "' found.");
            }
            JarEntry entry = jarEntry;
            InputStream fileStream = jar.getInputStream(entry);
            Intrinsics.checkNotNullExpressionValue((Object)fileStream, (String)"fileStream");
            JsonLib jsonLib = JsonLib.Companion.fromInputStream(fileStream);
            jar.close();
            Intrinsics.reifiedOperationMarker((int)4, (String)"T");
            Object object = jsonLib.getObjectOrNull(Object.class);
            if (object == null) {
                throw new ModuleLoadException(file.getPath() + ": Invalid '" + path + "'.");
            }
            return (T)object;
        }
        catch (Exception ex) {
            String string = file.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.path");
            throw new ModuleLoadException(string, ex);
        }
    }

    private final UpdaterFileContent checkPermissionAndLoadUpdaterFile(File file, ModuleFileContent moduleFileContent) {
        Object object;
        if (!this.modulesWithPermissionToUpdate.contains(moduleFileContent.getName())) {
            return null;
        }
        Object object2 = this;
        try {
            Object object3;
            ModuleHandler $this$checkPermissionAndLoadUpdaterFile_u24lambda_u2413 = object2;
            boolean bl = false;
            ModuleHandler moduleHandler = $this$checkPermissionAndLoadUpdaterFile_u24lambda_u2413;
            String path$iv = "updater.json";
            boolean $i$f$loadJsonFileInJar = false;
            if (!file.exists()) {
                boolean $i$a$-require-ModuleHandler$loadJsonFileInJar$1$iv22 = false;
                String $i$a$-require-ModuleHandler$loadJsonFileInJar$1$iv22 = "Specified file to load " + path$iv + " from does not exist: " + file.getPath();
                throw new IllegalArgumentException($i$a$-require-ModuleHandler$loadJsonFileInJar$1$iv22.toString());
            }
            try {
                JarFile jar$iv = new JarFile(file);
                JarEntry jarEntry = jar$iv.getJarEntry(path$iv);
                if (jarEntry == null) {
                    throw new ModuleLoadException(file.getPath() + ": No '" + path$iv + "' found.");
                }
                JarEntry entry$iv = jarEntry;
                InputStream fileStream$iv = jar$iv.getInputStream(entry$iv);
                Intrinsics.checkNotNullExpressionValue((Object)fileStream$iv, (String)"fileStream");
                JsonLib jsonLib$iv = JsonLib.Companion.fromInputStream(fileStream$iv);
                jar$iv.close();
                if (jsonLib$iv.getObjectOrNull(UpdaterFileContent.class) == null) {
                    throw new ModuleLoadException(file.getPath() + ": Invalid '" + path$iv + "'.");
                }
            }
            catch (Exception ex$iv) {
                String string = file.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.path");
                throw new ModuleLoadException(string, ex$iv);
            }
            object = Result.constructor-impl((Object)((UpdaterFileContent)object3));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        return (UpdaterFileContent)(Result.isFailure-impl((Object)object2) ? null : object2);
    }

    /*
     * WARNING - void declaration
     */
    private final List<File> getAllModuleJarFiles() {
        List list;
        File[] fileArray = new File(DirectoryPaths.Companion.getPaths().getModulesPath()).listFiles();
        if (fileArray != null) {
            void $this$filterTo$iv$iv;
            File[] $this$filter$iv = fileArray;
            boolean $i$f$filter = false;
            File[] fileArray2 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            int n = ((void)$this$filterTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void element$iv$iv;
                void it = element$iv$iv = $this$filterTo$iv$iv[i];
                boolean bl = false;
                String string = it.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
                if (!StringsKt.endsWith$default((String)string, (String)".jar", (boolean)false, (int)2, null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<LoadedModuleFileContent> getAllCloudModuleFileContents() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.getAllModuleJarFiles();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            File file = (File)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.loadModuleFileContent((File)it));
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public LoadedModule loadSingleModule(@NotNull LoadedModuleFileContent module) {
        return IModuleHandler.DefaultImpls.loadSingleModule(this, module);
    }

    @Override
    @NotNull
    public LoadedModule loadSingleModuleFromFile(@NotNull File file) {
        return IModuleHandler.DefaultImpls.loadSingleModuleFromFile(this, file);
    }

    public ModuleHandler() {
        this(null, null, null, false, null, 31, null);
    }

    public static final /* synthetic */ ClassLoader access$getParentClassLoader$p(ModuleHandler $this) {
        return $this.parentClassLoader;
    }
}

