/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.launcher.external.module.handler;

import eu.thesimplecloud.api.CloudAPI;
import eu.thesimplecloud.api.external.ICloudModule;
import eu.thesimplecloud.api.language.LoadedLanguageFile;
import eu.thesimplecloud.jsonlib.JsonLib;
import eu.thesimplecloud.launcher.exception.module.ModuleLoadException;
import eu.thesimplecloud.launcher.language.LanguageFileLoader;
import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u0005H\u0002J*\u0010\f\u001a\u0002H\r\"\n\b\u0000\u0010\r\u0018\u0001*\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0003H\u0082\b\u00a2\u0006\u0002\u0010\u000fJ\u0012\u0010\u0010\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u0005H\u0002J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0003H\u0002J\u0006\u0010\u0012\u001a\u00020\u0013R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Leu/thesimplecloud/launcher/external/module/handler/ModuleLanguageFileLoader;", "", "currentLanguage", "", "moduleFile", "Ljava/io/File;", "cloudModule", "Leu/thesimplecloud/api/external/ICloudModule;", "(Ljava/lang/String;Ljava/io/File;Leu/thesimplecloud/api/external/ICloudModule;)V", "loadFallbackLanguageFile", "Leu/thesimplecloud/api/language/LoadedLanguageFile;", "file", "loadJsonFileInJar", "T", "path", "(Ljava/io/File;Ljava/lang/String;)Ljava/lang/Object;", "loadLanguageFile", "language", "registerLanguageFileIfExist", "", "simplecloud-launcher"})
@SourceDebugExtension(value={"SMAP\nModuleLanguageFileLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModuleLanguageFileLoader.kt\neu/thesimplecloud/launcher/external/module/handler/ModuleLanguageFileLoader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,85:1\n70#1:87\n71#1,11:89\n1#2:86\n1#2:88\n*S KotlinDebug\n*F\n+ 1 ModuleLanguageFileLoader.kt\neu/thesimplecloud/launcher/external/module/handler/ModuleLanguageFileLoader\n*L\n65#1:87\n65#1:89,11\n65#1:88\n*E\n"})
public final class ModuleLanguageFileLoader {
    @NotNull
    private final String currentLanguage;
    @NotNull
    private final File moduleFile;
    @NotNull
    private final ICloudModule cloudModule;

    public ModuleLanguageFileLoader(@NotNull String currentLanguage, @NotNull File moduleFile, @NotNull ICloudModule cloudModule) {
        Intrinsics.checkNotNullParameter((Object)currentLanguage, (String)"currentLanguage");
        Intrinsics.checkNotNullParameter((Object)moduleFile, (String)"moduleFile");
        Intrinsics.checkNotNullParameter((Object)cloudModule, (String)"cloudModule");
        this.currentLanguage = currentLanguage;
        this.moduleFile = moduleFile;
        this.cloudModule = cloudModule;
    }

    public final void registerLanguageFileIfExist() {
        block0: {
            LoadedLanguageFile languageFile;
            LoadedLanguageFile loadedLanguageFile = languageFile = this.loadLanguageFile(this.moduleFile);
            if (loadedLanguageFile == null) break block0;
            LoadedLanguageFile it = loadedLanguageFile;
            boolean bl = false;
            CloudAPI.Companion.getInstance().getLanguageManager().registerLanguageFile(this.cloudModule, languageFile);
        }
    }

    private final LoadedLanguageFile loadLanguageFile(File file) {
        LoadedLanguageFile loadedLanguageFile = this.loadLanguageFile(file, this.currentLanguage);
        LoadedLanguageFile loadedLanguageFile2 = loadedLanguageFile;
        if (loadedLanguageFile2 == null) {
            loadedLanguageFile2 = this.loadFallbackLanguageFile(file);
        }
        return loadedLanguageFile2;
    }

    private final LoadedLanguageFile loadFallbackLanguageFile(File file) {
        return this.loadLanguageFile(file, "en");
    }

    private final LoadedLanguageFile loadLanguageFile(File file, String language) {
        LoadedLanguageFile loadedLanguageFile;
        Map map;
        Object $this$loadLanguageFile_u24lambda_u241;
        Object object = this;
        try {
            Object object2;
            $this$loadLanguageFile_u24lambda_u241 = object;
            boolean bl = false;
            Object object3 = $this$loadLanguageFile_u24lambda_u241;
            String path$iv = "languages/" + language + ".json";
            boolean $i$f$loadJsonFileInJar = false;
            if (!file.exists()) {
                boolean $i$a$-require-ModuleLanguageFileLoader$loadJsonFileInJar$1$iv22 = false;
                String $i$a$-require-ModuleLanguageFileLoader$loadJsonFileInJar$1$iv22 = "Specified file to load " + path$iv + " from does not exist: " + file.getPath();
                throw new IllegalArgumentException($i$a$-require-ModuleLanguageFileLoader$loadJsonFileInJar$1$iv22.toString());
            }
            try {
                JarFile jar$iv = new JarFile(file);
                JarEntry jarEntry = jar$iv.getJarEntry(path$iv);
                if (jarEntry == null) {
                    throw new ModuleLoadException(file.getPath() + ": No '" + path$iv + "' found.");
                }
                JarEntry entry$iv = jarEntry;
                InputStream fileStream$iv = jar$iv.getInputStream(entry$iv);
                Intrinsics.checkNotNullExpressionValue((Object)fileStream$iv, (String)"fileStream");
                JsonLib jsonLib$iv = JsonLib.Companion.fromInputStream(fileStream$iv);
                jar$iv.close();
                if (jsonLib$iv.getObjectOrNull(HashMap.class) == null) {
                    throw new ModuleLoadException(file.getPath() + ": Invalid '" + path$iv + "'.");
                }
            }
            catch (Exception ex$iv) {
                String string = file.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.path");
                throw new ModuleLoadException(string, ex$iv);
            }
            $this$loadLanguageFile_u24lambda_u241 = Result.constructor-impl((Object)((HashMap)object2));
        }
        catch (Throwable bl) {
            $this$loadLanguageFile_u24lambda_u241 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object = $this$loadLanguageFile_u24lambda_u241;
        Map map2 = map = (Map)(Result.isFailure-impl((Object)object) ? null : object);
        if (map2 != null) {
            Map it = map2;
            boolean bl = false;
            loadedLanguageFile = new LanguageFileLoader().buildFileFromMap(it);
        } else {
            loadedLanguageFile = null;
        }
        return loadedLanguageFile;
    }

    private final /* synthetic */ <T> T loadJsonFileInJar(File file, String path) {
        boolean $i$f$loadJsonFileInJar = false;
        if (!file.exists()) {
            boolean $i$a$-require-ModuleLanguageFileLoader$loadJsonFileInJar$22 = false;
            String $i$a$-require-ModuleLanguageFileLoader$loadJsonFileInJar$22 = "Specified file to load " + path + " from does not exist: " + file.getPath();
            throw new IllegalArgumentException($i$a$-require-ModuleLanguageFileLoader$loadJsonFileInJar$22.toString());
        }
        try {
            JarFile jar = new JarFile(file);
            JarEntry jarEntry = jar.getJarEntry(path);
            if (jarEntry == null) {
                throw new ModuleLoadException(file.getPath() + ": No '" + path + "' found.");
            }
            JarEntry entry = jarEntry;
            InputStream fileStream = jar.getInputStream(entry);
            Intrinsics.checkNotNullExpressionValue((Object)fileStream, (String)"fileStream");
            JsonLib jsonLib = JsonLib.Companion.fromInputStream(fileStream);
            jar.close();
            Intrinsics.reifiedOperationMarker((int)4, (String)"T");
            Object object = jsonLib.getObjectOrNull(Object.class);
            if (object == null) {
                throw new ModuleLoadException(file.getPath() + ": Invalid '" + path + "'.");
            }
            return (T)object;
        }
        catch (Exception ex) {
            String string = file.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.path");
            throw new ModuleLoadException(string, ex);
        }
    }
}

