/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.launcher.external.module.handler;

import eu.thesimplecloud.launcher.exception.module.ModuleLoadException;
import eu.thesimplecloud.launcher.extension.IterableExtensionKt;
import eu.thesimplecloud.launcher.external.module.LoadedModule;
import eu.thesimplecloud.launcher.external.module.LoadedModuleFileContent;
import eu.thesimplecloud.launcher.external.module.ModuleFileContent;
import eu.thesimplecloud.launcher.external.module.handler.RecursiveDependencyChecker;
import eu.thesimplecloud.launcher.external.module.handler.UnsafeModuleLoader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\u0018\u00002\u00020\u0001BW\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u0012\u001e\u0010\u0007\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\b\u0012\u0014\b\u0002\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e\u00a2\u0006\u0002\u0010\u0011J\u0010\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0004H\u0002J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0017\u001a\u00020\u000bH\u0002J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00040\u00192\u0006\u0010\u0015\u001a\u00020\u0004H\u0002J\u0018\u0010\u001a\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u00032\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u0010\u001d\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u00032\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0015\u001a\u00020\u0004H\u0002J\u0010\u0010 \u001a\u00020\u001f2\u0006\u0010\u0015\u001a\u00020\u0004H\u0002J\u0010\u0010!\u001a\u00020\u001f2\u0006\u0010\u0015\u001a\u00020\u0004H\u0002J\u0010\u0010\"\u001a\u00020\u001f2\u0006\u0010\u0015\u001a\u00020\u0004H\u0002J\u0010\u0010#\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0004H\u0002J\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003J\u0010\u0010%\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0004H\u0002J\u0010\u0010&\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0004H\u0002J\u0010\u0010'\u001a\u00020\u001f2\u0006\u0010\u0015\u001a\u00020\u0004H\u0002R&\u0010\u0007\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Leu/thesimplecloud/launcher/external/module/handler/ModuleListLoader;", "", "modulesToLoad", "", "Leu/thesimplecloud/launcher/external/module/LoadedModuleFileContent;", "loadedModuleList", "Leu/thesimplecloud/launcher/external/module/LoadedModule;", "classLoaderFunction", "Lkotlin/Function2;", "", "Ljava/net/URL;", "", "Ljava/lang/ClassLoader;", "handleLoadError", "Lkotlin/Function1;", "", "", "(Ljava/util/List;Ljava/util/List;Lkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function1;)V", "loadedModules", "", "checkRequirements", "module", "findModuleFileContentByName", "name", "getAllHardAndAvailableSoftDependencies", "", "getAllHardDependencies", "content", "Leu/thesimplecloud/launcher/external/module/ModuleFileContent;", "getAllSoftDependencies", "hasMissingDependencies", "", "hasRecursiveDependencies", "isModuleAlreadyLoaded", "isModuleLoaded", "loadModuleSafe", "loadModules", "loadSingleModule", "loadSingleModuleCatching", "wasModuleLoadedBefore", "simplecloud-launcher"})
@SourceDebugExtension(value={"SMAP\nModuleListLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModuleListLoader.kt\neu/thesimplecloud/launcher/external/module/handler/ModuleListLoader\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,127:1\n1855#2,2:128\n1855#2,2:130\n1549#2:132\n1620#2,3:133\n1549#2:136\n1620#2,3:137\n1549#2:140\n1620#2,3:141\n1549#2:144\n1620#2,3:145\n288#2,2:148\n*S KotlinDebug\n*F\n+ 1 ModuleListLoader.kt\neu/thesimplecloud/launcher/external/module/handler/ModuleListLoader\n*L\n48#1:128,2\n65#1:130,2\n90#1:132\n90#1:133,3\n94#1:136\n94#1:137,3\n116#1:140\n116#1:141,3\n120#1:144\n120#1:145,3\n124#1:148,2\n*E\n"})
public final class ModuleListLoader {
    @NotNull
    private final List<LoadedModuleFileContent> modulesToLoad;
    @NotNull
    private final List<LoadedModule> loadedModuleList;
    @NotNull
    private final Function2<URL[], String, ClassLoader> classLoaderFunction;
    @NotNull
    private final Function1<Throwable, Unit> handleLoadError;
    @NotNull
    private final List<LoadedModule> loadedModules;

    public ModuleListLoader(@NotNull List<LoadedModuleFileContent> modulesToLoad, @NotNull List<LoadedModule> loadedModuleList, @NotNull Function2<? super URL[], ? super String, ? extends ClassLoader> classLoaderFunction, @NotNull Function1<? super Throwable, Unit> handleLoadError) {
        Intrinsics.checkNotNullParameter(modulesToLoad, (String)"modulesToLoad");
        Intrinsics.checkNotNullParameter(loadedModuleList, (String)"loadedModuleList");
        Intrinsics.checkNotNullParameter(classLoaderFunction, (String)"classLoaderFunction");
        Intrinsics.checkNotNullParameter(handleLoadError, (String)"handleLoadError");
        this.modulesToLoad = modulesToLoad;
        this.loadedModuleList = loadedModuleList;
        this.classLoaderFunction = classLoaderFunction;
        this.handleLoadError = handleLoadError;
        this.loadedModules = new ArrayList();
    }

    public /* synthetic */ ModuleListLoader(List list, List list2, Function2 function2, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            function1 = 1.INSTANCE;
        }
        this(list, list2, (Function2<? super URL[], ? super String, ? extends ClassLoader>)function2, (Function1<? super Throwable, Unit>)function1);
    }

    @NotNull
    public final List<LoadedModule> loadModules() {
        Iterable $this$forEach$iv = this.modulesToLoad;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LoadedModuleFileContent it = (LoadedModuleFileContent)element$iv;
            boolean bl = false;
            this.loadSingleModuleCatching(it);
        }
        return this.loadedModules;
    }

    private final void loadSingleModuleCatching(LoadedModuleFileContent module) {
        try {
            this.loadSingleModule(module);
        }
        catch (Exception ex) {
            this.handleLoadError.invoke((Object)new ModuleLoadException(module.getContent().getName(), ex));
        }
    }

    private final void loadSingleModule(LoadedModuleFileContent module) {
        this.checkRequirements(module);
        Set<LoadedModuleFileContent> moduleDependencies = this.getAllHardAndAvailableSoftDependencies(module);
        Iterable $this$forEach$iv = moduleDependencies;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LoadedModuleFileContent it = (LoadedModuleFileContent)element$iv;
            boolean bl = false;
            this.loadSingleModule(it);
        }
        this.loadModuleSafe(module);
    }

    private final void checkRequirements(LoadedModuleFileContent module) {
        if (this.hasMissingDependencies(module)) {
            throw new ModuleLoadException("Missing dependency detected in module: " + module.getContent().getName());
        }
        if (this.hasRecursiveDependencies(module)) {
            throw new ModuleLoadException("Recursive dependency detected in module: " + module.getContent().getName());
        }
    }

    private final void loadModuleSafe(LoadedModuleFileContent module) {
        if (this.isModuleLoaded(module)) {
            return;
        }
        LoadedModule loadedModule = new UnsafeModuleLoader(this.classLoaderFunction).loadModule(module);
        this.loadedModules.add(loadedModule);
    }

    private final boolean isModuleLoaded(LoadedModuleFileContent module) {
        return this.isModuleAlreadyLoaded(module) || this.wasModuleLoadedBefore(module);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isModuleAlreadyLoaded(LoadedModuleFileContent module) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.loadedModules;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            LoadedModule loadedModule = (LoadedModule)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getFileContent().getName());
        }
        return ((List)destination$iv$iv).contains(module.getContent().getName());
    }

    /*
     * WARNING - void declaration
     */
    private final boolean wasModuleLoadedBefore(LoadedModuleFileContent module) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.loadedModuleList;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            LoadedModule loadedModule = (LoadedModule)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getFileContent().getName());
        }
        return ((List)destination$iv$iv).contains(module.getContent().getName());
    }

    private final boolean hasMissingDependencies(LoadedModuleFileContent module) {
        List<LoadedModuleFileContent> allHardDependencies = this.getAllHardDependencies(module.getContent());
        return IterableExtensionKt.hasNulls((Iterable)allHardDependencies);
    }

    private final boolean hasRecursiveDependencies(LoadedModuleFileContent module) {
        return new RecursiveDependencyChecker(module, (Function1<? super LoadedModuleFileContent, ? extends Collection<LoadedModuleFileContent>>)((Function1)new Function1<LoadedModuleFileContent, Set<? extends LoadedModuleFileContent>>((Object)this){

            @NotNull
            public final Set<LoadedModuleFileContent> invoke(@NotNull LoadedModuleFileContent p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ModuleListLoader.access$getAllHardAndAvailableSoftDependencies((ModuleListLoader)this.receiver, p0);
            }
        })).hasRecursiveDependencies();
    }

    private final Set<LoadedModuleFileContent> getAllHardAndAvailableSoftDependencies(LoadedModuleFileContent module) {
        List hardDependencies = CollectionsKt.requireNoNulls(this.getAllHardDependencies(module.getContent()));
        List availableSoftDependencies = CollectionsKt.filterNotNull((Iterable)this.getAllSoftDependencies(module.getContent()));
        return CollectionsKt.union((Iterable)hardDependencies, (Iterable)availableSoftDependencies);
    }

    /*
     * WARNING - void declaration
     */
    private final List<LoadedModuleFileContent> getAllHardDependencies(ModuleFileContent content) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = content.getDepend();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.findModuleFileContentByName((String)it));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<LoadedModuleFileContent> getAllSoftDependencies(ModuleFileContent content) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = content.getSoftDepend();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.findModuleFileContentByName((String)it));
        }
        return (List)destination$iv$iv;
    }

    private final LoadedModuleFileContent findModuleFileContentByName(String name) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = this.modulesToLoad;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                LoadedModuleFileContent it = (LoadedModuleFileContent)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getContent().getName(), (Object)name)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    public static final /* synthetic */ Set access$getAllHardAndAvailableSoftDependencies(ModuleListLoader $this, LoadedModuleFileContent module) {
        return $this.getAllHardAndAvailableSoftDependencies(module);
    }
}

