/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.launcher.external.module.handler;

import eu.thesimplecloud.api.CloudAPI;
import eu.thesimplecloud.api.eventapi.IEventManager;
import eu.thesimplecloud.api.external.ICloudModule;
import eu.thesimplecloud.api.player.ICloudPlayer;
import eu.thesimplecloud.api.property.IProperty;
import eu.thesimplecloud.api.property.Property;
import eu.thesimplecloud.api.service.ICloudService;
import eu.thesimplecloud.launcher.event.module.ModuleUnloadedEvent;
import eu.thesimplecloud.launcher.exception.module.ModuleLoadException;
import eu.thesimplecloud.launcher.external.module.LoadedModule;
import eu.thesimplecloud.launcher.external.module.ModuleClassLoader;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0007\u001a\u00020\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Leu/thesimplecloud/launcher/external/module/handler/UnsafeModuleUnloader;", "", "loadedModule", "Leu/thesimplecloud/launcher/external/module/LoadedModule;", "(Leu/thesimplecloud/launcher/external/module/LoadedModule;)V", "getLoadedModule", "()Leu/thesimplecloud/launcher/external/module/LoadedModule;", "unload", "", "simplecloud-launcher"})
@SourceDebugExtension(value={"SMAP\nUnsafeModuleUnloader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnsafeModuleUnloader.kt\neu/thesimplecloud/launcher/external/module/handler/UnsafeModuleUnloader\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,68:1\n1855#2:69\n1856#2:72\n1855#2:73\n1856#2:76\n215#3,2:70\n215#3,2:74\n*S KotlinDebug\n*F\n+ 1 UnsafeModuleUnloader.kt\neu/thesimplecloud/launcher/external/module/handler/UnsafeModuleUnloader\n*L\n58#1:69\n58#1:72\n61#1:73\n61#1:76\n59#1:70,2\n62#1:74,2\n*E\n"})
public final class UnsafeModuleUnloader {
    @NotNull
    private final LoadedModule loadedModule;

    public UnsafeModuleUnloader(@NotNull LoadedModule loadedModule) {
        Intrinsics.checkNotNullParameter((Object)loadedModule, (String)"loadedModule");
        this.loadedModule = loadedModule;
    }

    @NotNull
    public final LoadedModule getLoadedModule() {
        return this.loadedModule;
    }

    public final void unload() {
        Map.Entry<String, IProperty<?>> it;
        Map.Entry<String, IProperty<Object>> element$iv;
        Iterator<Map.Entry<String, IProperty<Object>>> iterator;
        boolean $i$f$forEach;
        Map $this$forEach$iv;
        ICloudModule cloudModule = this.loadedModule.getCloudModule();
        try {
            cloudModule.onDisable();
        }
        catch (Exception ex) {
            throw new ModuleLoadException("Error while unloading module " + this.loadedModule.getName(), ex);
        }
        CloudAPI.Companion.getInstance().getEventManager().unregisterAllListenersByCloudModule(cloudModule);
        ClassLoader classLoader = this.loadedModule.getModuleClassLoader();
        Intrinsics.checkNotNull((Object)classLoader, (String)"null cannot be cast to non-null type eu.thesimplecloud.launcher.external.module.ModuleClassLoader");
        ((ModuleClassLoader)classLoader).close();
        CloudAPI.Companion.getInstance().getMessageChannelManager().unregisterMessageChannel(cloudModule);
        IEventManager.DefaultImpls.call$default(CloudAPI.Companion.getInstance().getEventManager(), new ModuleUnloadedEvent(this.loadedModule), false, 2, null);
        Iterable $this$forEach$iv2 = CloudAPI.Companion.getInstance().getCloudPlayerManager().getAllCachedObjects();
        boolean $i$f$forEach2 = false;
        for (Object element$iv2 : $this$forEach$iv2) {
            ICloudPlayer player = (ICloudPlayer)element$iv2;
            boolean bl = false;
            $this$forEach$iv = player.getProperties();
            $i$f$forEach = false;
            iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                it = element$iv = iterator.next();
                boolean bl2 = false;
                IProperty<?> iProperty = it.getValue();
                Intrinsics.checkNotNull(iProperty, (String)"null cannot be cast to non-null type eu.thesimplecloud.api.property.Property<*>");
                ((Property)iProperty).resetValue();
            }
        }
        $this$forEach$iv2 = CloudAPI.Companion.getInstance().getCloudServiceManager().getAllCachedObjects();
        $i$f$forEach2 = false;
        for (Object element$iv2 : $this$forEach$iv2) {
            ICloudService group = (ICloudService)element$iv2;
            boolean bl = false;
            $this$forEach$iv = group.getProperties();
            $i$f$forEach = false;
            iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                it = element$iv = iterator.next();
                boolean bl3 = false;
                IProperty<?> iProperty = it.getValue();
                Intrinsics.checkNotNull(iProperty, (String)"null cannot be cast to non-null type eu.thesimplecloud.api.property.Property<*>");
                ((Property)iProperty).resetValue();
            }
        }
        CloudAPI.Companion.getInstance().getLanguageManager().unregisterLanguageFileByCloudModule(cloudModule);
    }
}

