/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.launcher.external.module.updater;

import eu.thesimplecloud.launcher.external.module.update.UpdateMethod;
import eu.thesimplecloud.launcher.external.module.update.UpdaterFileContent;
import eu.thesimplecloud.launcher.updater.AbstractUpdater;
import eu.thesimplecloud.runner.dependency.AdvancedCloudDependency;
import eu.thesimplecloud.runner.utils.Downloader;
import java.io.File;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0002J\b\u0010\t\u001a\u00020\bH\u0016J\b\u0010\n\u001a\u00020\bH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u000f\u001a\u00020\fH\u0016J\b\u0010\u0010\u001a\u00020\fH\u0016J\n\u0010\u0011\u001a\u0004\u0018\u00010\fH\u0016J\u0010\u0010\u0012\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Leu/thesimplecloud/launcher/external/module/updater/ModuleUpdater;", "Leu/thesimplecloud/launcher/updater/AbstractUpdater;", "updaterFileContent", "Leu/thesimplecloud/launcher/external/module/update/UpdaterFileContent;", "moduleFile", "Ljava/io/File;", "(Leu/thesimplecloud/launcher/external/module/update/UpdaterFileContent;Ljava/io/File;)V", "downloadFileWithoutAllExtension", "", "downloadJarsForUpdate", "executeJar", "getAllDownloadURL", "", "dependency", "Leu/thesimplecloud/runner/dependency/AdvancedCloudDependency;", "getCurrentVersion", "getRepositoryURL", "getVersionToInstall", "tryDownloadJarFromAllUrl", "simplecloud-launcher"})
public final class ModuleUpdater
extends AbstractUpdater {
    @NotNull
    private final UpdaterFileContent updaterFileContent;

    public ModuleUpdater(@NotNull UpdaterFileContent updaterFileContent, @NotNull File moduleFile) {
        Intrinsics.checkNotNullParameter((Object)updaterFileContent, (String)"updaterFileContent");
        Intrinsics.checkNotNullParameter((Object)moduleFile, (String)"moduleFile");
        super(updaterFileContent.getGroupId(), updaterFileContent.getArtifactId(), moduleFile);
        this.updaterFileContent = updaterFileContent;
    }

    @Override
    @NotNull
    public String getCurrentVersion() {
        return this.getVersionFromManifestFile(this.getUpdateFile());
    }

    @Override
    public void executeJar() {
    }

    @Override
    public void downloadJarsForUpdate() {
        String string = this.getVersionToInstall();
        if (string == null) {
            throw new RuntimeException("Cannot perform update. Is the server down? (repo: " + this.getRepositoryURL() + ')');
        }
        String latestVersion = string;
        AdvancedCloudDependency dependency = new AdvancedCloudDependency(this.getGroupId(), this.getArtifactId(), latestVersion);
        this.tryDownloadJarFromAllUrl(dependency);
    }

    private final void tryDownloadJarFromAllUrl(AdvancedCloudDependency dependency) {
        try {
            new Downloader().userAgentDownload(this.getAllDownloadURL(dependency), this.getUpdateFile());
        }
        catch (IOException e) {
            this.downloadFileWithoutAllExtension();
        }
    }

    private final void downloadFileWithoutAllExtension() {
        super.downloadJarsForUpdate();
    }

    private final String getAllDownloadURL(AdvancedCloudDependency dependency) {
        String downloadUrlWithoutExt = dependency.getUrlWithoutExtension(this.getRepositoryURL());
        return downloadUrlWithoutExt + "-all.jar";
    }

    @Override
    @Nullable
    public String getVersionToInstall() {
        String string;
        switch (WhenMappings.$EnumSwitchMapping$0[this.updaterFileContent.getUpdateMethod().ordinal()]) {
            case 1: {
                string = this.getCurrentLauncherVersion();
                break;
            }
            case 2: {
                string = super.getVersionToInstall();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    @Override
    @NotNull
    public String getRepositoryURL() {
        String repository = this.updaterFileContent.getRepository();
        if (StringsKt.equals((String)repository, (String)"CLOUD", (boolean)true)) {
            return super.getRepositoryURL();
        }
        return repository;
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[UpdateMethod.values().length];
            try {
                nArray[UpdateMethod.CLOUD.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UpdateMethod.WEB.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

