/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.launcher.language;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import eu.thesimplecloud.api.CloudAPI;
import eu.thesimplecloud.api.directorypaths.DirectoryPaths;
import eu.thesimplecloud.api.language.LanguageProperty;
import eu.thesimplecloud.api.language.LoadedLanguageFile;
import eu.thesimplecloud.jsonlib.JsonLib;
import eu.thesimplecloud.launcher.config.launcher.LauncherConfig;
import eu.thesimplecloud.launcher.utils.FileCopier;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0005H\u0002J\u001a\u0010\f\u001a\u00020\r2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u000fJ\b\u0010\u0010\u001a\u00020\tH\u0002J\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0005H\u0002J\u000e\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0014J\u0010\u0010\u0015\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u0005H\u0002J\u000e\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u0007R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Leu/thesimplecloud/launcher/language/LanguageFileLoader;", "", "()V", "allLanguages", "", "", "languageDir", "Ljava/io/File;", "addMissingPropertiesToLanguageFile", "", "languageFile", "language", "buildFileFromMap", "Leu/thesimplecloud/api/language/LoadedLanguageFile;", "map", "", "copyLanguageFiles", "getLanguageFileByLanguage", "loadFile", "launcherConfig", "Leu/thesimplecloud/launcher/config/launcher/LauncherConfig;", "loadLanguage", "loadLanguageFile", "file", "Companion", "simplecloud-launcher"})
@SourceDebugExtension(value={"SMAP\nLanguageFileLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LanguageFileLoader.kt\neu/thesimplecloud/launcher/language/LanguageFileLoader\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,115:1\n1855#2,2:116\n1549#2:118\n1620#2,3:119\n1549#2:122\n1620#2,3:123\n1855#2,2:126\n1549#2:128\n1620#2,3:129\n*S KotlinDebug\n*F\n+ 1 LanguageFileLoader.kt\neu/thesimplecloud/launcher/language/LanguageFileLoader\n*L\n57#1:116,2\n83#1:118\n83#1:119,3\n84#1:122\n84#1:123,3\n89#1:126,2\n101#1:128\n101#1:129,3\n*E\n"})
public final class LanguageFileLoader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final File languageDir = new File(DirectoryPaths.Companion.getPaths().getLanguagesPath());
    @NotNull
    private final List<String> allLanguages;
    @NotNull
    public static final String FALLBACK_LANGUAGE = "en";
    private static final boolean isFirstStart = !new LanguageFileLoader().getLanguageFileByLanguage("en").exists();

    public LanguageFileLoader() {
        Object[] objectArray = new String[]{FALLBACK_LANGUAGE, "de"};
        this.allLanguages = CollectionsKt.listOf((Object[])objectArray);
    }

    public final void loadFile(@NotNull LauncherConfig launcherConfig) {
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)launcherConfig, (String)"launcherConfig");
                if (!this.languageDir.exists()) break block2;
                File[] fileArray = this.languageDir.listFiles();
                Intrinsics.checkNotNullExpressionValue((Object)fileArray, (String)"languageDir.listFiles()");
                if (!(((Object[])fileArray).length == 0)) break block3;
            }
            this.languageDir.mkdirs();
            this.copyLanguageFiles();
        }
        String language = launcherConfig.getLanguage();
        this.loadLanguage(language);
    }

    private final void copyLanguageFiles() {
        Iterable $this$forEach$iv = this.allLanguages;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            FileCopier.Companion.copyFileOutOfJar(this.getLanguageFileByLanguage(it), "/language/" + it + ".json");
        }
    }

    private final void loadLanguage(String language) {
        File languageFile = this.getLanguageFileByLanguage(language);
        if (languageFile.exists()) {
            this.addMissingPropertiesToLanguageFile(languageFile, language);
        }
        if (!languageFile.exists() && !Intrinsics.areEqual((Object)languageFile, (Object)this.getLanguageFileByLanguage(FALLBACK_LANGUAGE))) {
            this.loadLanguage(FALLBACK_LANGUAGE);
            return;
        }
        CloudAPI.Companion.getInstance().getLanguageManager().registerLanguageFile(CloudAPI.Companion.getInstance().getThisSidesCloudModule(), this.loadLanguageFile(languageFile));
    }

    /*
     * WARNING - void declaration
     */
    private final void addMissingPropertiesToLanguageFile(File languageFile, String language) {
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        InputStream inputStream = this.getClass().getResourceAsStream("/language/" + language + ".json");
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"inputStream");
        JsonLib actualJson = JsonLib.Companion.fromInputStream(inputStream);
        JsonLib jsonLib = JsonLib.Companion.fromJsonFile$default((JsonLib.Companion)JsonLib.Companion, (File)languageFile, null, (int)2, null);
        Intrinsics.checkNotNull((Object)jsonLib);
        JsonLib copiedJson = jsonLib;
        JsonElement jsonElement = actualJson.getJsonElement();
        Intrinsics.checkNotNull((Object)jsonElement, (String)"null cannot be cast to non-null type com.google.gson.JsonObject");
        JsonObject actualJsonObject = (JsonObject)jsonElement;
        Set set = actualJsonObject.entrySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"actualJsonObject.entrySet()");
        Iterable $this$map$iv = set;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            Map.Entry entry = (Map.Entry)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add((String)it.getKey());
        }
        List allPropertiesActualJson = (List)destination$iv$iv;
        JsonElement jsonElement2 = copiedJson.getJsonElement();
        Intrinsics.checkNotNull((Object)jsonElement2, (String)"null cannot be cast to non-null type com.google.gson.JsonObject");
        Set set2 = ((JsonObject)jsonElement2).entrySet();
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"copiedJson.jsonElement as JsonObject).entrySet()");
        Iterable $this$map$iv2 = set2;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Map.Entry bl = (Map.Entry)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add((String)it.getKey());
        }
        List allPropertiesCopiedJson = (List)destination$iv$iv2;
        List missingProperties = CollectionsKt.toMutableList((Collection)allPropertiesActualJson);
        missingProperties.removeAll(allPropertiesCopiedJson);
        if (missingProperties.isEmpty()) {
            return;
        }
        Iterable $this$forEach$iv = missingProperties;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            copiedJson.append(it, (Object)actualJsonObject.get(it));
        }
        copiedJson.saveAsFile(languageFile);
    }

    @NotNull
    public final LoadedLanguageFile loadLanguageFile(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        JsonLib jsonLib = JsonLib.Companion.fromJsonFile$default((JsonLib.Companion)JsonLib.Companion, (File)file, null, (int)2, null);
        Intrinsics.checkNotNull((Object)jsonLib);
        Object object = jsonLib.getObject(HashMap.class);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.String>");
        Map map = (Map)object;
        return this.buildFileFromMap(map);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final LoadedLanguageFile buildFileFromMap(@NotNull Map<String, String> map) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(map, (String)"map");
        Iterable $this$map$iv = map.entrySet();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Map.Entry entry = (Map.Entry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new LanguageProperty((String)it.getKey(), (String)it.getValue()));
        }
        List properties = (List)destination$iv$iv;
        return new LoadedLanguageFile(properties);
    }

    private final File getLanguageFileByLanguage(String language) {
        return new File(this.languageDir, language + ".json");
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0007\u00a8\u0006\b"}, d2={"Leu/thesimplecloud/launcher/language/LanguageFileLoader$Companion;", "", "()V", "FALLBACK_LANGUAGE", "", "isFirstStart", "", "()Z", "simplecloud-launcher"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isFirstStart() {
            return isFirstStart;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

