/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.launcher.logging;

import eu.thesimplecloud.launcher.logging.AnsiColorHelper;
import eu.thesimplecloud.launcher.logging.ILoggerMessageListener;
import eu.thesimplecloud.launcher.logging.LogType;
import eu.thesimplecloud.launcher.screens.IScreenManager;
import eu.thesimplecloud.launcher.startup.Launcher;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jline.reader.LineReader;
import org.jline.utils.InfoCmp;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u0003\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\rJ\u000e\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\bJ\b\u0010\u0017\u001a\u00020\u0013H\u0002J\u000e\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\bJ\u000e\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001bJ\u0016\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\tJ\u0010\u0010\u001f\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\bH\u0016J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\tH\u0002J\u0010\u0010#\u001a\u00020!2\u0006\u0010$\u001a\u00020\u000fH\u0002J\u0006\u0010%\u001a\u00020\u0013J\"\u0010&\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\"\u001a\u00020\t2\b\b\u0002\u0010'\u001a\u00020!H\u0002J\u000e\u0010(\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\bJ\u0010\u0010)\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\bH\u0016J\u000e\u0010*\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\bJ\u0010\u0010+\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\bH\u0016R \u0010\u0005\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006,"}, d2={"Leu/thesimplecloud/launcher/logging/LoggerProvider;", "Ljava/util/logging/Logger;", "screenManager", "Leu/thesimplecloud/launcher/screens/IScreenManager;", "(Leu/thesimplecloud/launcher/screens/IScreenManager;)V", "cachedMessages", "Ljava/util/ArrayList;", "Lkotlin/Pair;", "", "Leu/thesimplecloud/launcher/logging/LogType;", "dataFormat", "Ljava/text/SimpleDateFormat;", "loggerMessageListeners", "Leu/thesimplecloud/launcher/logging/ILoggerMessageListener;", "logsDir", "Ljava/io/File;", "getScreenManager", "()Leu/thesimplecloud/launcher/screens/IScreenManager;", "addLoggerMessageListener", "", "loggerMessageListener", "console", "msg", "deleteOldLogs", "empty", "exception", "cause", "", "getColoredString", "text", "type", "info", "isMessageBlocked", "", "logType", "isOlderThanTenDays", "logFile", "printCachedMessages", "printMessage", "cache", "setup", "severe", "success", "warning", "simplecloud-launcher"})
@SourceDebugExtension(value={"SMAP\nLoggerProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LoggerProvider.kt\neu/thesimplecloud/launcher/logging/LoggerProvider\n+ 2 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,233:1\n26#2:234\n766#3:235\n857#3,2:236\n1855#3,2:238\n1855#3,2:240\n1855#3,2:242\n*S KotlinDebug\n*F\n+ 1 LoggerProvider.kt\neu/thesimplecloud/launcher/logging/LoggerProvider\n*L\n81#1:234\n82#1:235\n82#1:236,2\n82#1:238,2\n137#1:240,2\n156#1:242,2\n*E\n"})
public final class LoggerProvider
extends Logger {
    @NotNull
    private final IScreenManager screenManager;
    @NotNull
    private final SimpleDateFormat dataFormat;
    @NotNull
    private final ArrayList<ILoggerMessageListener> loggerMessageListeners;
    @NotNull
    private final File logsDir;
    @NotNull
    private final ArrayList<Pair<String, LogType>> cachedMessages;

    public LoggerProvider(@NotNull IScreenManager screenManager) {
        Intrinsics.checkNotNullParameter((Object)screenManager, (String)"screenManager");
        super("SimpleCloudLogger", null);
        this.screenManager = screenManager;
        this.dataFormat = new SimpleDateFormat("[HH:mm:ss]");
        this.loggerMessageListeners = new ArrayList();
        this.logsDir = new File("logs/");
        this.cachedMessages = new ArrayList();
        this.setLevel(Level.ALL);
        this.setUseParentHandlers(false);
        System.setProperty("java.util.logging.SimpleFormatter.format", "[%1$tT] [%4$-7s] %5$s %n");
        if (!this.logsDir.exists()) {
            this.logsDir.mkdirs();
        }
        File file = new File("logs/");
        SimpleFormatter simpleFormatter = new SimpleFormatter();
        FileHandler fileHandler = new FileHandler(file.getCanonicalPath() + "/simplecloud-log", 0x500000, 100, false);
        fileHandler.setEncoding(StandardCharsets.UTF_8.name());
        fileHandler.setLevel(Level.ALL);
        fileHandler.setFormatter(simpleFormatter);
        this.addHandler(fileHandler);
        this.deleteOldLogs();
    }

    @NotNull
    public final IScreenManager getScreenManager() {
        return this.screenManager;
    }

    /*
     * WARNING - void declaration
     */
    private final void deleteOldLogs() {
        void $this$filterTo$iv$iv;
        Object[] objectArray;
        Object[] objectArray2 = this.logsDir.listFiles();
        if (objectArray2 == null) {
            boolean $i$f$emptyArray = false;
            objectArray = new File[]{};
        } else {
            objectArray = objectArray2;
        }
        List allLogFiles = ArraysKt.filterNotNull((Object[])objectArray);
        Iterable $this$filter$iv = allLogFiles;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            File it = (File)element$iv$iv;
            boolean bl = false;
            if (!this.isOlderThanTenDays(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it = (File)element$iv;
            boolean bl = false;
            it.delete();
        }
    }

    private final boolean isOlderThanTenDays(File logFile) {
        long tenDaysInMillis = TimeUnit.DAYS.toMillis(10L);
        return System.currentTimeMillis() - logFile.lastModified() > tenDaysInMillis;
    }

    public final void addLoggerMessageListener(@NotNull ILoggerMessageListener loggerMessageListener) {
        Intrinsics.checkNotNullParameter((Object)loggerMessageListener, (String)"loggerMessageListener");
        this.loggerMessageListeners.add(loggerMessageListener);
    }

    public final synchronized void success(@NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        LoggerProvider.printMessage$default(this, msg, LogType.SUCCESS, false, 4, null);
    }

    @Override
    public synchronized void info(@NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        super.info(msg);
        LoggerProvider.printMessage$default(this, msg, LogType.INFO, false, 4, null);
    }

    @Override
    public synchronized void warning(@NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        super.warning(msg);
        LoggerProvider.printMessage$default(this, msg, LogType.WARNING, false, 4, null);
    }

    @Override
    public synchronized void severe(@NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        super.severe(msg);
        LoggerProvider.printMessage$default(this, msg, LogType.ERROR, false, 4, null);
    }

    public final synchronized void console(@NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        super.info(msg);
        LoggerProvider.printMessage$default(this, msg, LogType.CONSOLE, false, 4, null);
    }

    public final synchronized void setup(@NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        super.info(msg);
        LoggerProvider.printMessage$default(this, msg, LogType.SETUP, false, 4, null);
    }

    public final synchronized void empty(@NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        super.info(msg);
        LoggerProvider.printMessage$default(this, msg, LogType.EMPTY, false, 4, null);
    }

    public final synchronized void printCachedMessages() {
        Iterable $this$forEach$iv = this.cachedMessages;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair it = (Pair)element$iv;
            boolean bl = false;
            this.printMessage((String)it.getFirst(), (LogType)((Object)it.getSecond()), false);
        }
    }

    private final void printMessage(String msg, LogType logType, boolean cache) {
        if (cache && Launcher.Companion.getInstance().isBaseLoaded() && logType != LogType.SETUP && logType != LogType.EMPTY && logType != LogType.WARNING) {
            if (this.cachedMessages.size() == 50) {
                this.cachedMessages.remove(0);
            }
            this.cachedMessages.add((Pair<String, LogType>)new Pair((Object)msg, (Object)logType));
        }
        if (this.isMessageBlocked(logType)) {
            return;
        }
        String coloredMessage = this.getColoredString(msg, logType);
        Iterable $this$forEach$iv = this.loggerMessageListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ILoggerMessageListener it = (ILoggerMessageListener)element$iv;
            boolean bl = false;
            it.message(msg, logType);
        }
        LineReader lineReader = Launcher.Companion.getInstance().getConsoleManager().getLineReader();
        lineReader.getTerminal().puts(InfoCmp.Capability.carriage_return, new Object[0]);
        lineReader.getTerminal().writer().println(coloredMessage);
        lineReader.getTerminal().flush();
        if (lineReader.isReading()) {
            lineReader.callWidget("redraw-line");
            lineReader.callWidget("redisplay");
        }
    }

    static /* synthetic */ void printMessage$default(LoggerProvider loggerProvider, String string, LogType logType, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        loggerProvider.printMessage(string, logType, bl);
    }

    private final boolean isMessageBlocked(LogType logType) {
        if (logType == LogType.WARNING) {
            return false;
        }
        return this.screenManager.hasActiveScreen() && logType != LogType.EMPTY || Launcher.Companion.getInstance().getSetupManager().hasActiveSetup() && logType != LogType.SETUP;
    }

    @NotNull
    public final String getColoredString(@NotNull String text, @NotNull LogType type) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        String logType = "";
        switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: {
                logType = "\u00a7aSUCCESS\u00a77";
                break;
            }
            case 2: {
                logType = "\u00a73INFO\u00a77";
                break;
            }
            case 3: {
                logType = "\u00a76WARNING\u00a77";
                break;
            }
            case 4: {
                logType = "\u00a7cERROR\u00a77";
                break;
            }
            case 5: {
                logType = "\u00a73CONSOLE\u00a77";
                break;
            }
            case 6: {
                logType = "\u00a73SETUP\u00a77";
            }
        }
        String message = "\u00a7r" + text + "\u00a7r";
        if (type != LogType.EMPTY) {
            String time = this.dataFormat.format(Calendar.getInstance().getTime());
            message = time + ' ' + logType + ": \u00a7r" + text + "\u00a7r";
        }
        return AnsiColorHelper.Companion.toColoredString(message);
    }

    public final synchronized void exception(@NotNull Throwable cause) {
        Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        cause.printStackTrace(pw);
        String string = sw.getBuffer().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sw.buffer.toString()");
        String stackTraceMessage = string;
        this.severe(stackTraceMessage);
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LogType.values().length];
            try {
                nArray[LogType.SUCCESS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LogType.INFO.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LogType.WARNING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LogType.ERROR.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LogType.CONSOLE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LogType.SETUP.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

