/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.launcher.screens;

import eu.thesimplecloud.api.screen.ICommandExecutable;
import eu.thesimplecloud.launcher.screens.IScreen;
import eu.thesimplecloud.launcher.screens.IScreenManager;
import eu.thesimplecloud.launcher.screens.ScreenImpl;
import eu.thesimplecloud.launcher.screens.session.ScreenSession;
import eu.thesimplecloud.launcher.startup.Launcher;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\n\u0010\u000e\u001a\u0004\u0018\u00010\u0004H\u0016J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016J\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0004H\u0016J\u0010\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0011H\u0002J\b\u0010\u0016\u001a\u00020\tH\u0016J\u0010\u0010\u0017\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\rH\u0016R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Leu/thesimplecloud/launcher/screens/ScreenManagerImpl;", "Leu/thesimplecloud/launcher/screens/IScreenManager;", "()V", "activeSession", "Leu/thesimplecloud/launcher/screens/session/ScreenSession;", "screens", "Ljava/util/concurrent/CopyOnWriteArraySet;", "Leu/thesimplecloud/launcher/screens/ScreenImpl;", "addScreenMessage", "", "commandExecutable", "Leu/thesimplecloud/api/screen/ICommandExecutable;", "message", "", "getActiveScreenSession", "getAllScreens", "", "Leu/thesimplecloud/launcher/screens/IScreen;", "joinScreen", "screenSession", "joinScreenIfActive", "screen", "leaveActiveScreen", "registerScreen", "unregisterScreen", "name", "simplecloud-launcher"})
@SourceDebugExtension(value={"SMAP\nScreenManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScreenManagerImpl.kt\neu/thesimplecloud/launcher/screens/ScreenManagerImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,89:1\n1855#2,2:90\n*S KotlinDebug\n*F\n+ 1 ScreenManagerImpl.kt\neu/thesimplecloud/launcher/screens/ScreenManagerImpl\n*L\n69#1:90,2\n*E\n"})
public final class ScreenManagerImpl
implements IScreenManager {
    @NotNull
    private final CopyOnWriteArraySet<ScreenImpl> screens = new CopyOnWriteArraySet();
    @Nullable
    private ScreenSession activeSession;

    @Override
    @NotNull
    public IScreen registerScreen(@NotNull ICommandExecutable commandExecutable) {
        Intrinsics.checkNotNullParameter((Object)commandExecutable, (String)"commandExecutable");
        ScreenImpl screen = new ScreenImpl(commandExecutable);
        this.screens.add(screen);
        this.joinScreenIfActive(screen);
        return screen;
    }

    @Override
    public void unregisterScreen(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.screens.removeIf(arg_0 -> ScreenManagerImpl.unregisterScreen$lambda$0((Function1)new Function1<ScreenImpl, Boolean>(name){
            final /* synthetic */ String $name;
            {
                this.$name = $name;
                super(1);
            }

            @NotNull
            public final Boolean invoke(ScreenImpl it) {
                return StringsKt.equals((String)it.getName(), (String)this.$name, (boolean)true);
            }
        }, arg_0));
    }

    @Override
    public void addScreenMessage(@NotNull ICommandExecutable commandExecutable, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)commandExecutable, (String)"commandExecutable");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        IScreen iScreen = this.getScreen(commandExecutable.getName());
        if (iScreen == null) {
            iScreen = this.registerScreen(commandExecutable);
        }
        IScreen screen = iScreen;
        Intrinsics.checkNotNull((Object)screen, (String)"null cannot be cast to non-null type eu.thesimplecloud.launcher.screens.ScreenImpl");
        ScreenImpl cfr_ignored_0 = (ScreenImpl)screen;
        ((ScreenImpl)screen).addMessage(message);
        ScreenSession screenSession = this.activeSession;
        if (Intrinsics.areEqual((Object)(screenSession != null ? screenSession.getScreen() : null), (Object)screen)) {
            Launcher.Companion.getInstance().getLogger().empty(message);
        }
    }

    @Override
    @NotNull
    public Set<IScreen> getAllScreens() {
        return this.screens;
    }

    @Override
    @Nullable
    public ScreenSession getActiveScreenSession() {
        return this.activeSession;
    }

    @Override
    public void joinScreen(@NotNull ScreenSession screenSession) {
        Intrinsics.checkNotNullParameter((Object)screenSession, (String)"screenSession");
        this.activeSession = screenSession;
        Launcher.Companion.getInstance().clearConsole();
        IScreen screen = screenSession.getScreen();
        Iterable $this$forEach$iv = screen.getAllSavedMessages();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            Launcher.Companion.getInstance().getLogger().empty(it);
        }
        Launcher.Companion.getInstance().getLogger().empty("You joined the screen " + screen.getName() + ". To leave the screen write \"leave\"");
        Launcher.Companion.getInstance().getLogger().empty("All commands will be executed on the screen.");
    }

    @Override
    public void leaveActiveScreen() {
        this.activeSession = null;
        Launcher.Companion.getInstance().clearConsole();
        Launcher.Companion.getInstance().getLogger().printCachedMessages();
    }

    private final void joinScreenIfActive(IScreen screen) {
        ScreenSession screenSession = this.activeSession;
        if (screenSession == null) {
            return;
        }
        ScreenSession activeSession = screenSession;
        if (activeSession.getScreenCloseBehaviour() != ScreenSession.ScreenCloseBehaviour.REOPEN) {
            return;
        }
        if (StringsKt.equals((String)activeSession.getScreen().getName(), (String)screen.getName(), (boolean)true)) {
            this.joinScreen(new ScreenSession(screen, ScreenSession.ScreenCloseBehaviour.REOPEN));
        }
    }

    @Override
    @Nullable
    public IScreen getScreen(@NotNull String name) {
        return IScreenManager.DefaultImpls.getScreen(this, name);
    }

    @Override
    @Nullable
    public IScreen getActiveScreen() {
        return IScreenManager.DefaultImpls.getActiveScreen(this);
    }

    @Override
    public boolean hasActiveScreen() {
        return IScreenManager.DefaultImpls.hasActiveScreen(this);
    }

    private static final boolean unregisterScreen$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }
}

