/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.launcher.setups;

import eu.thesimplecloud.jsonlib.JsonLib;
import eu.thesimplecloud.launcher.config.launcher.LauncherConfig;
import eu.thesimplecloud.launcher.console.setup.ISetup;
import eu.thesimplecloud.launcher.console.setup.annotations.SetupQuestion;
import eu.thesimplecloud.launcher.console.setup.provider.BooleanSetupAnswerProvider;
import eu.thesimplecloud.launcher.setups.IpSetup;
import eu.thesimplecloud.launcher.startup.Launcher;
import eu.thesimplecloud.launcher.utils.IpValidator;
import eu.thesimplecloud.launcher.utils.WebsiteContentLoader;
import kotlin.Metadata;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a8\u0006\u0006"}, d2={"Leu/thesimplecloud/launcher/setups/AutoIpSetup;", "Leu/thesimplecloud/launcher/console/setup/ISetup;", "()V", "setup", "", "boolean", "simplecloud-launcher"})
public final class AutoIpSetup
implements ISetup {
    @SetupQuestion(number=0, property="Do you want to retrieve your ip automatically via `ipify.org`?", answerProvider=BooleanSetupAnswerProvider.class)
    public final boolean setup(boolean bl) {
        String data;
        if (!bl) {
            Launcher.Companion.getInstance().getSetupManager().queueSetup(new IpSetup(), true);
            return true;
        }
        try {
            data = new WebsiteContentLoader().loadContent("https://api.ipify.org?format=json");
            data = JsonLib.Companion.fromJsonString$default((JsonLib.Companion)JsonLib.Companion, (String)data, null, (int)2, null).getString("ip");
        }
        catch (Exception e) {
            Launcher.Companion.getInstance().getLogger().warning("Unable to connect to \"ipify.org\".");
            return false;
        }
        String ip = data;
        if (ip == null || !new IpValidator().validate(ip)) {
            Launcher.Companion.getInstance().getLogger().warning("Received response can not be parsed to an ip.");
            return false;
        }
        LauncherConfig launcherConfig = Launcher.Companion.getInstance().getLauncherConfig();
        LauncherConfig config = new LauncherConfig(ip, launcherConfig.getPort(), 50000, "https://haste.simplecloud.app", launcherConfig.getLanguage(), launcherConfig.getDirectoryPaths());
        Launcher.Companion.getInstance().replaceLauncherConfig(config);
        return true;
    }
}

