/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.launcher.startup;

import eu.thesimplecloud.api.directorypaths.DirectoryPaths;
import eu.thesimplecloud.api.external.ICloudModule;
import eu.thesimplecloud.jsonlib.JsonLib;
import eu.thesimplecloud.launcher.application.ApplicationStarter;
import eu.thesimplecloud.launcher.application.CloudApplicationType;
import eu.thesimplecloud.launcher.application.ICloudApplication;
import eu.thesimplecloud.launcher.config.java.JavaVersion;
import eu.thesimplecloud.launcher.config.java.JavaVersionConfigLoader;
import eu.thesimplecloud.launcher.config.launcher.LauncherConfig;
import eu.thesimplecloud.launcher.config.launcher.LauncherConfigLoader;
import eu.thesimplecloud.launcher.console.ConsoleManager;
import eu.thesimplecloud.launcher.console.ConsoleSender;
import eu.thesimplecloud.launcher.console.command.CommandManager;
import eu.thesimplecloud.launcher.console.setup.SetupManager;
import eu.thesimplecloud.launcher.language.LanguageFileLoader;
import eu.thesimplecloud.launcher.logging.LoggerProvider;
import eu.thesimplecloud.launcher.screens.IScreenManager;
import eu.thesimplecloud.launcher.screens.ScreenManagerImpl;
import eu.thesimplecloud.launcher.setups.AutoIpSetup;
import eu.thesimplecloud.launcher.setups.LanguageSetup;
import eu.thesimplecloud.launcher.setups.StartSetup;
import eu.thesimplecloud.launcher.startup.Launcher;
import eu.thesimplecloud.launcher.startup.LauncherStartArguments;
import eu.thesimplecloud.launcher.updater.RunnerUpdater;
import eu.thesimplecloud.launcher.updater.UpdateExecutor;
import eu.thesimplecloud.loader.dependency.DependencyLoader;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Locale;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00ad\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002*\u0001\"\u0018\u0000 U2\u00020\u0001:\u0001UB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010>\u001a\u00020?J\u000e\u0010@\u001a\u00020?2\u0006\u0010A\u001a\u00020BJ\b\u0010C\u001a\u00020\u001cH\u0002J\u0006\u0010D\u001a\u00020EJ\u0006\u0010F\u001a\u00020BJ\u0006\u0010G\u001a\u00020EJ\u0006\u0010H\u001a\u00020IJ\u0006\u0010J\u001a\u00020=J\u0006\u0010K\u001a\u00020\u001cJ\u0006\u0010L\u001a\u00020\u001cJ\b\u0010M\u001a\u00020?H\u0002J\u000e\u0010N\u001a\u00020?2\u0006\u0010O\u001a\u00020$J\u0006\u0010P\u001a\u00020?J\u0006\u0010Q\u001a\u00020?J\u000e\u0010R\u001a\u00020?2\u0006\u0010S\u001a\u00020TR\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u001e\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001b\u001a\u00020\u001c@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010#R\u001e\u0010%\u001a\u00020$2\u0006\u0010\u001b\u001a\u00020$@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u000e\u0010(\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u0011\u0010,\u001a\u00020-\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R\u0011\u00100\u001a\u000201\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00103R\u0011\u00104\u001a\u000205\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u00107R\u0011\u00108\u001a\u000209\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u0010;R\u000e\u0010<\u001a\u00020=X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006V"}, d2={"Leu/thesimplecloud/launcher/startup/Launcher;", "", "launcherStartArguments", "Leu/thesimplecloud/launcher/startup/LauncherStartArguments;", "(Leu/thesimplecloud/launcher/startup/LauncherStartArguments;)V", "activeApplication", "Leu/thesimplecloud/launcher/application/ICloudApplication;", "getActiveApplication", "()Leu/thesimplecloud/launcher/application/ICloudApplication;", "setActiveApplication", "(Leu/thesimplecloud/launcher/application/ICloudApplication;)V", "commandManager", "Leu/thesimplecloud/launcher/console/command/CommandManager;", "getCommandManager", "()Leu/thesimplecloud/launcher/console/command/CommandManager;", "consoleManager", "Leu/thesimplecloud/launcher/console/ConsoleManager;", "getConsoleManager", "()Leu/thesimplecloud/launcher/console/ConsoleManager;", "consoleSender", "Leu/thesimplecloud/launcher/console/ConsoleSender;", "getConsoleSender", "()Leu/thesimplecloud/launcher/console/ConsoleSender;", "currentClassLoader", "Ljava/lang/ClassLoader;", "getCurrentClassLoader", "()Ljava/lang/ClassLoader;", "<set-?>", "", "isBaseLoaded", "()Z", "javaVersionConfigLoader", "Leu/thesimplecloud/launcher/config/java/JavaVersionConfigLoader;", "launcherCloudModule", "eu/thesimplecloud/launcher/startup/Launcher$launcherCloudModule$1", "Leu/thesimplecloud/launcher/startup/Launcher$launcherCloudModule$1;", "Leu/thesimplecloud/launcher/config/launcher/LauncherConfig;", "launcherConfig", "getLauncherConfig", "()Leu/thesimplecloud/launcher/config/launcher/LauncherConfig;", "launcherConfigLoader", "Leu/thesimplecloud/launcher/config/launcher/LauncherConfigLoader;", "getLauncherStartArguments", "()Leu/thesimplecloud/launcher/startup/LauncherStartArguments;", "logger", "Leu/thesimplecloud/launcher/logging/LoggerProvider;", "getLogger", "()Leu/thesimplecloud/launcher/logging/LoggerProvider;", "scheduler", "Ljava/util/concurrent/ScheduledExecutorService;", "getScheduler", "()Ljava/util/concurrent/ScheduledExecutorService;", "screenManager", "Leu/thesimplecloud/launcher/screens/IScreenManager;", "getScreenManager", "()Leu/thesimplecloud/launcher/screens/IScreenManager;", "setupManager", "Leu/thesimplecloud/launcher/console/setup/SetupManager;", "getSetupManager", "()Leu/thesimplecloud/launcher/console/setup/SetupManager;", "startedTime", "", "clearConsole", "", "executeCommand", "command", "", "executeUpdateIfAvailable", "getBaseFile", "Ljava/io/File;", "getCurrentVersion", "getLauncherFile", "getNewClassLoaderWithLauncherAndBase", "Ljava/net/URLClassLoader;", "getUpTime", "isSnapshotBuild", "isWindows", "migrateOldLauncherFile", "replaceLauncherConfig", "config", "shutdown", "start", "startApplication", "cloudApplicationType", "Leu/thesimplecloud/launcher/application/CloudApplicationType;", "Companion", "simplecloud-launcher"})
@SourceDebugExtension(value={"SMAP\nLauncher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Launcher.kt\neu/thesimplecloud/launcher/startup/Launcher\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,249:1\n1#2:250\n*E\n"})
public final class Launcher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LauncherStartArguments launcherStartArguments;
    @NotNull
    private final launcherCloudModule.1 launcherCloudModule;
    private volatile boolean isBaseLoaded;
    @Nullable
    private ICloudApplication activeApplication;
    @NotNull
    private final IScreenManager screenManager;
    @NotNull
    private final LoggerProvider logger;
    @NotNull
    private final CommandManager commandManager;
    @NotNull
    private final ConsoleSender consoleSender;
    @NotNull
    private final ConsoleManager consoleManager;
    @NotNull
    private final SetupManager setupManager;
    @NotNull
    private final LauncherConfigLoader launcherConfigLoader;
    @NotNull
    private final JavaVersionConfigLoader javaVersionConfigLoader;
    @NotNull
    private final ScheduledExecutorService scheduler;
    @NotNull
    private final ClassLoader currentClassLoader;
    @NotNull
    private LauncherConfig launcherConfig;
    private final long startedTime;
    private static Launcher instance;

    public Launcher(@NotNull LauncherStartArguments launcherStartArguments) {
        Intrinsics.checkNotNullParameter((Object)((Object)launcherStartArguments), (String)"launcherStartArguments");
        this.launcherStartArguments = launcherStartArguments;
        this.launcherCloudModule = new ICloudModule(){

            public void onEnable() {
            }

            public void onDisable() {
            }

            public boolean isReloadable() {
                return ICloudModule.DefaultImpls.isReloadable(this);
            }
        };
        this.screenManager = new ScreenManagerImpl();
        this.logger = new LoggerProvider(this.screenManager);
        this.consoleSender = new ConsoleSender();
        this.setupManager = new SetupManager(this);
        this.launcherConfigLoader = new LauncherConfigLoader();
        this.javaVersionConfigLoader = new JavaVersionConfigLoader();
        ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1);
        Intrinsics.checkNotNullExpressionValue((Object)scheduledExecutorService, (String)"newScheduledThreadPool(1)");
        this.scheduler = scheduledExecutorService;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Intrinsics.checkNotNullExpressionValue((Object)classLoader, (String)"currentThread().contextClassLoader");
        this.currentClassLoader = classLoader;
        this.startedTime = System.currentTimeMillis();
        instance = this;
        if (System.getProperty("simplecloud.version") == null) {
            System.setProperty("simplecloud.version", Launcher.class.getPackage().getImplementationVersion());
        }
        Thread.setDefaultUncaughtExceptionHandler((arg_0, arg_1) -> Launcher._init_$lambda$0(this, arg_0, arg_1));
        System.setProperty("user.language", "en");
        this.migrateOldLauncherFile();
        this.launcherConfig = (LauncherConfig)this.launcherConfigLoader.loadConfig();
        DirectoryPaths.Companion.setPaths(this.launcherConfig.getDirectoryPaths());
        JavaVersion.Companion.setPaths((JavaVersion)this.javaVersionConfigLoader.loadConfig());
        this.commandManager = new CommandManager();
        this.consoleManager = new ConsoleManager(this.commandManager, this.consoleSender);
    }

    @NotNull
    public final LauncherStartArguments getLauncherStartArguments() {
        return this.launcherStartArguments;
    }

    public final boolean isBaseLoaded() {
        return this.isBaseLoaded;
    }

    @Nullable
    public final ICloudApplication getActiveApplication() {
        return this.activeApplication;
    }

    public final void setActiveApplication(@Nullable ICloudApplication iCloudApplication) {
        this.activeApplication = iCloudApplication;
    }

    @NotNull
    public final IScreenManager getScreenManager() {
        return this.screenManager;
    }

    @NotNull
    public final LoggerProvider getLogger() {
        return this.logger;
    }

    @NotNull
    public final CommandManager getCommandManager() {
        return this.commandManager;
    }

    @NotNull
    public final ConsoleSender getConsoleSender() {
        return this.consoleSender;
    }

    @NotNull
    public final ConsoleManager getConsoleManager() {
        return this.consoleManager;
    }

    @NotNull
    public final SetupManager getSetupManager() {
        return this.setupManager;
    }

    @NotNull
    public final ScheduledExecutorService getScheduler() {
        return this.scheduler;
    }

    @NotNull
    public final ClassLoader getCurrentClassLoader() {
        return this.currentClassLoader;
    }

    @NotNull
    public final LauncherConfig getLauncherConfig() {
        return this.launcherConfig;
    }

    public final void start() {
        block6: {
            DependencyLoader.Companion.getINSTANCE().disableLogger();
            this.clearConsole();
            if (!this.launcherStartArguments.getDisableAutoUpdater()) {
                if (this.executeUpdateIfAvailable()) {
                    return;
                }
            } else {
                this.logger.warning("Auto updater is disabled.");
            }
            String[] stringArray = new String[]{"eu.thesimplecloud.launcher.commands"};
            this.commandManager.registerAllCommands(this.launcherCloudModule, this.currentClassLoader, stringArray);
            this.consoleManager.startThread();
            if (LanguageFileLoader.Companion.isFirstStart()) {
                SetupManager.queueSetup$default(this.setupManager, new LanguageSetup(), false, 2, null);
            }
            if (!this.launcherConfigLoader.doesConfigFileExist()) {
                SetupManager.queueSetup$default(this.setupManager, new AutoIpSetup(), false, 2, null);
            }
            if (this.launcherStartArguments.getStartApplication() == null) {
                SetupManager.queueSetup$default(this.setupManager, new StartSetup(), false, 2, null);
            }
            this.setupManager.waitForAllSetups();
            CloudApplicationType cloudApplicationType = this.launcherStartArguments.getStartApplication();
            if (cloudApplicationType == null) break block6;
            CloudApplicationType it = cloudApplicationType;
            boolean bl = false;
            this.startApplication(it);
        }
    }

    private final void migrateOldLauncherFile() {
        JsonLib jsonLib = JsonLib.Companion.fromJsonFile$default((JsonLib.Companion)JsonLib.Companion, (File)new File("launcher.json"), null, (int)2, null);
        if (jsonLib == null) {
            return;
        }
        JsonLib jsonLib2 = jsonLib;
        if (jsonLib2.getInt("startServicePort") == null) {
            jsonLib2.append("startServicePort", (Number)50000);
        }
        if (jsonLib2.getString("uploadDumpFileUrl") == null) {
            jsonLib2.append("uploadDumpFileUrl", "https://haste.simplecloud.app");
        }
        jsonLib2.saveAsFile("launcher.json");
    }

    private final boolean executeUpdateIfAvailable() {
        RunnerUpdater updater2 = new RunnerUpdater(this.launcherStartArguments.getUpdateChannel());
        if (updater2.isUpdateAvailable()) {
            StringBuilder stringBuilder = new StringBuilder().append("Found a new runner version: ");
            String string = updater2.getVersionToInstall();
            Intrinsics.checkNotNull((Object)string);
            this.consoleSender.sendMessage(stringBuilder.append(string).toString());
            new UpdateExecutor().executeUpdate(updater2);
            return true;
        }
        this.consoleSender.sendMessage("You are running on the latest version of SimpleCloud.");
        return false;
    }

    public final void startApplication(@NotNull CloudApplicationType cloudApplicationType) {
        Intrinsics.checkNotNullParameter((Object)((Object)cloudApplicationType), (String)"cloudApplicationType");
        this.isBaseLoaded = true;
        this.clearConsole();
        this.logger.info("Starting " + cloudApplicationType.getApplicationName() + "...");
        new ApplicationStarter().startApplication(cloudApplicationType);
    }

    public final void clearConsole() {
        if (this.isWindows()) {
            try {
                String[] stringArray = new String[]{"cmd", "/c", "cls"};
                new ProcessBuilder(stringArray).inheritIO().start().waitFor();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            System.out.print((Object)"\u001b[H\u001b[2J");
            System.out.flush();
        }
    }

    public final void executeCommand(@NotNull String command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        if (StringsKt.isBlank((CharSequence)command)) {
            return;
        }
        this.commandManager.handleCommand(command, this.consoleSender);
    }

    public final void shutdown() {
        ICloudApplication iCloudApplication = this.activeApplication;
        if (iCloudApplication != null) {
            iCloudApplication.onDisable();
        }
        System.exit(0);
        throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
    }

    public final boolean isWindows() {
        String string = System.getProperty("os.name");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(\"os.name\")");
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        return StringsKt.contains$default((CharSequence)string2, (CharSequence)"windows", (boolean)false, (int)2, null);
    }

    @NotNull
    public final File getLauncherFile() {
        if (System.getProperty("simplecloud.launcher.update-mode") != null) {
            return new File("launcher-update.jar");
        }
        return new File(Launcher.class.getProtectionDomain().getCodeSource().getLocation().toURI());
    }

    @NotNull
    public final File getBaseFile() {
        return new File("storage/base.jar");
    }

    @NotNull
    public final URLClassLoader getNewClassLoaderWithLauncherAndBase() {
        URLClassLoader uRLClassLoader;
        URL launcherFileURL = this.getLauncherFile().toURI().toURL();
        ClassLoader currentContextClassLoader = Thread.currentThread().getContextClassLoader();
        if (this.isBaseLoaded) {
            URL baseFileURL = this.getBaseFile().toURI().toURL();
            URL[] uRLArray = new URL[]{baseFileURL, launcherFileURL};
            URLClassLoader uRLClassLoader2 = new URLClassLoader(uRLArray, currentContextClassLoader);
            uRLClassLoader = uRLClassLoader2;
        } else {
            URL[] uRLArray = new URL[]{launcherFileURL};
            URLClassLoader uRLClassLoader3 = new URLClassLoader(uRLArray, currentContextClassLoader);
            uRLClassLoader = uRLClassLoader3;
        }
        return uRLClassLoader;
    }

    public final boolean isSnapshotBuild() {
        String string = System.getProperty("simplecloud.version");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(\"simplecloud.version\")");
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        return StringsKt.contains$default((CharSequence)string2, (CharSequence)"snapshot", (boolean)false, (int)2, null);
    }

    @NotNull
    public final String getCurrentVersion() {
        String string = System.getProperty("simplecloud.version");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(\"simplecloud.version\")");
        return string;
    }

    public final void replaceLauncherConfig(@NotNull LauncherConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.launcherConfig = config;
        this.launcherConfigLoader.saveConfig(config);
    }

    public final long getUpTime() {
        return System.currentTimeMillis() - this.startedTime;
    }

    private static final void _init_$lambda$0(Launcher this$0, Thread thread, Throwable cause) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        try {
            LoggerProvider loggerProvider = this$0.logger;
            Intrinsics.checkNotNullExpressionValue((Object)cause, (String)"cause");
            loggerProvider.exception(cause);
        }
        catch (Exception e) {
            System.out.println((Object)"An error occurred logging an exception");
            System.out.println((Object)"Exception while logging:");
            e.printStackTrace();
            System.out.println((Object)"Exception to log:");
            cause.printStackTrace();
        }
    }

    @NotNull
    public static final Launcher getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R&\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00048\u0006@BX\u0087.\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0006\u0010\u0002\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Leu/thesimplecloud/launcher/startup/Launcher$Companion;", "", "()V", "<set-?>", "Leu/thesimplecloud/launcher/startup/Launcher;", "instance", "getInstance$annotations", "getInstance", "()Leu/thesimplecloud/launcher/startup/Launcher;", "simplecloud-launcher"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Launcher getInstance() {
            Launcher launcher = instance;
            if (launcher != null) {
                return launcher;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"instance");
            return null;
        }

        @JvmStatic
        public static /* synthetic */ void getInstance$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

