/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.launcher.updater;

import eu.thesimplecloud.launcher.updater.IUpdater;
import eu.thesimplecloud.loader.dependency.DependencyResolver;
import eu.thesimplecloud.runner.dependency.AdvancedCloudDependency;
import java.io.File;
import java.util.jar.JarFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u000e\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0006J\n\u0010\u0014\u001a\u0004\u0018\u00010\u0003H\u0016R\u0014\u0010\u0004\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0014\u0010\u0005\u001a\u00020\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0010\u0010\r\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Leu/thesimplecloud/launcher/updater/AbstractUpdater;", "Leu/thesimplecloud/launcher/updater/IUpdater;", "groupId", "", "artifactId", "updateFile", "Ljava/io/File;", "(Ljava/lang/String;Ljava/lang/String;Ljava/io/File;)V", "getArtifactId", "()Ljava/lang/String;", "getGroupId", "getUpdateFile", "()Ljava/io/File;", "versionToInstall", "wasVersionToInstallCalled", "", "downloadJarsForUpdate", "", "getVersionFromManifestFile", "file", "getVersionToInstall", "simplecloud-launcher"})
public abstract class AbstractUpdater
implements IUpdater {
    @NotNull
    private final String groupId;
    @NotNull
    private final String artifactId;
    @NotNull
    private final File updateFile;
    @Nullable
    private String versionToInstall;
    private boolean wasVersionToInstallCalled;

    public AbstractUpdater(@NotNull String groupId, @NotNull String artifactId, @NotNull File updateFile) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
        Intrinsics.checkNotNullParameter((Object)updateFile, (String)"updateFile");
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.updateFile = updateFile;
    }

    @NotNull
    protected final String getGroupId() {
        return this.groupId;
    }

    @NotNull
    protected final String getArtifactId() {
        return this.artifactId;
    }

    @NotNull
    protected final File getUpdateFile() {
        return this.updateFile;
    }

    @Override
    @Nullable
    public String getVersionToInstall() {
        if (!this.wasVersionToInstallCalled) {
            this.wasVersionToInstallCalled = true;
            DefaultArtifact aetherArtifact = new DefaultArtifact(this.groupId + ':' + this.artifactId + ":(0,]");
            this.versionToInstall = new DependencyResolver(this.getRepositoryURL(), aetherArtifact).determineLatestVersion();
        }
        return this.versionToInstall;
    }

    @Override
    public void downloadJarsForUpdate() {
        String string = this.getVersionToInstall();
        if (string == null) {
            throw new RuntimeException("Cannot perform update. Is the server down? (repo: " + this.getRepositoryURL() + ')');
        }
        String latestVersion = string;
        AdvancedCloudDependency dependency = new AdvancedCloudDependency(this.groupId, this.artifactId, latestVersion);
        dependency.download(this.getRepositoryURL(), this.updateFile);
    }

    @NotNull
    public final String getVersionFromManifestFile(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        JarFile jarFile = new JarFile(file);
        String version = jarFile.getManifest().getMainAttributes().getValue("Implementation-Version");
        jarFile.close();
        Intrinsics.checkNotNullExpressionValue((Object)version, (String)"version");
        return version;
    }

    @Override
    public boolean isUpdateAvailable() {
        return IUpdater.DefaultImpls.isUpdateAvailable(this);
    }

    @Override
    @NotNull
    public String getCurrentLauncherVersion() {
        return IUpdater.DefaultImpls.getCurrentLauncherVersion(this);
    }

    @Override
    @NotNull
    public String getRepositoryURL() {
        return IUpdater.DefaultImpls.getRepositoryURL(this);
    }
}

