/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.launcher.updater;

import eu.thesimplecloud.jsonlib.JsonLib;
import eu.thesimplecloud.launcher.startup.Launcher;
import eu.thesimplecloud.launcher.updater.AbstractUpdater;
import eu.thesimplecloud.launcher.updater.UpdateChannel;
import eu.thesimplecloud.runner.RunnerFileProvider;
import eu.thesimplecloud.runner.dependency.AdvancedCloudDependency;
import eu.thesimplecloud.runner.utils.WebContentLoader;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\t\u001a\u00020\nH\u0002J\b\u0010\u000b\u001a\u00020\nH\u0016J\b\u0010\f\u001a\u00020\bH\u0016J\n\u0010\r\u001a\u0004\u0018\u00010\bH\u0016J\u0018\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0006H\u0002J\u0018\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0006H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Leu/thesimplecloud/launcher/updater/RunnerUpdater;", "Leu/thesimplecloud/launcher/updater/AbstractUpdater;", "updateChannel", "Leu/thesimplecloud/launcher/updater/UpdateChannel;", "(Leu/thesimplecloud/launcher/updater/UpdateChannel;)V", "dependencyLoaderFile", "Ljava/io/File;", "versionToInstall", "", "deleteLauncherAndDependencyLoader", "", "executeJar", "getCurrentVersion", "getVersionToInstall", "performLinuxUpdate", "currentRunnerFile", "file", "performWindowsUpdate", "updateRunnerFile", "simplecloud-launcher"})
public final class RunnerUpdater
extends AbstractUpdater {
    @NotNull
    private final UpdateChannel updateChannel;
    @NotNull
    private final File dependencyLoaderFile;
    @Nullable
    private String versionToInstall;

    public RunnerUpdater(@NotNull UpdateChannel updateChannel) {
        Intrinsics.checkNotNullParameter((Object)((Object)updateChannel), (String)"updateChannel");
        super("eu.thesimplecloud.simplecloud", "simplecloud-runner", new File("runner-update.jar"));
        this.updateChannel = updateChannel;
        this.dependencyLoaderFile = new File("storage", "dependency-loader.jar");
    }

    @Override
    @NotNull
    public String getCurrentVersion() {
        return this.getCurrentLauncherVersion();
    }

    @Override
    @Nullable
    public String getVersionToInstall() {
        if (this.versionToInstall != null) {
            return this.versionToInstall;
        }
        String urlstring = "https://update.thesimplecloud.eu/latestVersion/" + this.getCurrentVersion() + "?channel=" + this.updateChannel.toChannelString();
        String string = new WebContentLoader().loadContent(urlstring);
        if (string == null) {
            return null;
        }
        String content = string;
        this.versionToInstall = JsonLib.Companion.fromJsonString$default((JsonLib.Companion)JsonLib.Companion, (String)content, null, (int)2, null).getString("latestVersion");
        return this.versionToInstall;
    }

    @Override
    public void executeJar() {
        File file = new File("runner-update.jar");
        File currentRunnerFile = RunnerFileProvider.INSTANCE.getRUNNER_FILE();
        URL[] uRLArray = new URL[]{file.toURI().toURL()};
        URLClassLoader newClassLoader = new URLClassLoader(uRLArray);
        Thread.currentThread().setContextClassLoader(newClassLoader);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> RunnerUpdater.executeJar$lambda$0(this, currentRunnerFile, file)));
        Launcher.Companion.getInstance().shutdown();
    }

    private final void performWindowsUpdate(File currentRunnerFile, File updateRunnerFile) {
        File updaterFile = new File("storage/updater.jar");
        String string = this.getVersionToInstall();
        Intrinsics.checkNotNull((Object)string);
        AdvancedCloudDependency dependency = new AdvancedCloudDependency("eu.thesimplecloud.simplecloud", "simplecloud-updater", string);
        dependency.download(this.getRepositoryURL(), updaterFile);
        String[] stringArray = new String[]{"java", "-jar", "storage/updater.jar", "300", currentRunnerFile.getAbsolutePath(), updateRunnerFile.getAbsolutePath(), Launcher.Companion.getInstance().getLauncherFile().getAbsolutePath(), this.dependencyLoaderFile.getAbsolutePath()};
        ProcessBuilder processBuilder = new ProcessBuilder(stringArray);
        processBuilder.directory(new File("."));
        processBuilder.start();
    }

    private final void performLinuxUpdate(File currentRunnerFile, File file) {
        CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
        Files.move(file.toPath(), currentRunnerFile.toPath(), copyOptionArray);
        this.deleteLauncherAndDependencyLoader();
    }

    private final void deleteLauncherAndDependencyLoader() {
        Launcher.Companion.getInstance().getLauncherFile().delete();
        this.dependencyLoaderFile.delete();
    }

    private static final void executeJar$lambda$0(RunnerUpdater this$0, File $currentRunnerFile, File $file) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$currentRunnerFile, (String)"$currentRunnerFile");
        Intrinsics.checkNotNullParameter((Object)$file, (String)"$file");
        Thread.sleep(200L);
        if (Launcher.Companion.getInstance().isWindows()) {
            this$0.performWindowsUpdate($currentRunnerFile, $file);
        } else {
            this$0.performLinuxUpdate($currentRunnerFile, $file);
        }
        System.out.println((Object)"Update installed. Stopping in 5 seconds...");
        Thread.sleep(5000L);
    }
}

