/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.module.prefix.service.tablist;

import eu.thesimplecloud.module.permission.PermissionPool;
import eu.thesimplecloud.module.permission.player.IPermissionPlayer;
import eu.thesimplecloud.module.permission.player.manager.IPermissionPlayerManager;
import eu.thesimplecloud.module.prefix.config.Config;
import eu.thesimplecloud.module.prefix.config.TablistInformation;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.ScoreboardManager;
import org.bukkit.scoreboard.Team;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0006\u0010\u000b\u001a\u00020\bJ\u0018\u0010\f\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0002J\u0006\u0010\r\u001a\u00020\bJ\u000e\u0010\u000e\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u000f"}, d2={"Leu/thesimplecloud/module/prefix/service/tablist/TablistHelper;", "", "()V", "getTablistInformationByPlayer", "Leu/thesimplecloud/module/prefix/config/TablistInformation;", "player", "Lorg/bukkit/entity/Player;", "initScoreboard", "", "scoreboard", "Lorg/bukkit/scoreboard/Scoreboard;", "load", "setPlayerInScoreboard", "updateScoreboardForAllPlayers", "updateScoreboardForPlayer", "simplecloud-module-chat-tab"})
public final class TablistHelper {
    @NotNull
    public static final TablistHelper INSTANCE;

    public final void load() {
        ScoreboardManager scoreboardManager = Bukkit.getScoreboardManager();
        if (scoreboardManager == null || (scoreboardManager = scoreboardManager.getMainScoreboard()) == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)scoreboardManager, (String)"Bukkit.getScoreboardMana\u2026.mainScoreboard ?: return");
        ScoreboardManager scoreboard = scoreboardManager;
        this.initScoreboard((Scoreboard)scoreboard);
        Collection collection = Bukkit.getOnlinePlayers();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"Bukkit.getOnlinePlayers()");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Player it = (Player)element$iv;
            boolean bl = false;
            Player player = it;
            Intrinsics.checkNotNullExpressionValue((Object)player, (String)"it");
            INSTANCE.updateScoreboardForPlayer(player);
        }
    }

    private final void initScoreboard(Scoreboard scoreboard) {
        Iterable $this$forEach$iv = Config.Companion.getConfig().getInformationList();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TablistInformation it = (TablistInformation)element$iv;
            boolean bl = false;
            Team team = scoreboard.getTeam(String.valueOf(it.getPriority()));
            if (team == null) {
                team = scoreboard.registerNewTeam(String.valueOf(it.getPriority()));
            }
            Intrinsics.checkNotNullExpressionValue((Object)team, (String)"scoreboard.getTeam(it.pr\u2026m(it.priority.toString())");
            Team team2 = team;
            ChatColor chatColor = ChatColor.valueOf((String)it.getColor());
            team2.setPrefix(ChatColor.translateAlternateColorCodes((char)'&', (String)it.getPrefix()) + chatColor.toString());
            team2.setSuffix(ChatColor.translateAlternateColorCodes((char)'&', (String)it.getSuffix()));
            try {
                team2.setColor(chatColor);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (NoSuchMethodError noSuchMethodError) {
            }
        }
    }

    public final void updateScoreboardForAllPlayers() {
        Collection collection = Bukkit.getOnlinePlayers();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"Bukkit.getOnlinePlayers()");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Player it = (Player)element$iv;
            boolean bl = false;
            Player player = it;
            Intrinsics.checkNotNullExpressionValue((Object)player, (String)"it");
            INSTANCE.updateScoreboardForPlayer(player);
        }
    }

    public final void updateScoreboardForPlayer(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Scoreboard scoreboard = player.getScoreboard();
        Intrinsics.checkNotNullExpressionValue((Object)scoreboard, (String)"player.scoreboard");
        Scoreboard scoreboard2 = scoreboard;
        this.initScoreboard(scoreboard2);
        Collection collection = Bukkit.getOnlinePlayers();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"Bukkit.getOnlinePlayers()");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Player it = (Player)element$iv;
            boolean bl = false;
            Player player2 = it;
            Intrinsics.checkNotNullExpressionValue((Object)player2, (String)"it");
            INSTANCE.setPlayerInScoreboard(player2, scoreboard2);
        }
    }

    private final void setPlayerInScoreboard(Player player, Scoreboard scoreboard) {
        Set set = scoreboard.getTeams();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"scoreboard.teams");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Team it = (Team)element$iv;
            boolean bl = false;
            it.removeEntry(player.getName());
        }
        TablistInformation tablistInformation = this.getTablistInformationByPlayer(player);
        if (tablistInformation == null) {
            return;
        }
        TablistInformation tablistInformation2 = tablistInformation;
        String teamName = String.valueOf(tablistInformation2.getPriority());
        Team team = scoreboard.getTeam(teamName);
        if (team == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)team, (String)"scoreboard.getTeam(teamName) ?: return");
        Team team2 = team;
        team2.addEntry(player.getName());
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final TablistInformation getTablistInformationByPlayer(@NotNull Player player) {
        Object element$iv2;
        block2: {
            void $this$first$iv;
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            IPermissionPlayerManager iPermissionPlayerManager = PermissionPool.Companion.getInstance().getPermissionPlayerManager();
            UUID uUID = player.getUniqueId();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"player.uniqueId");
            IPermissionPlayer iPermissionPlayer = iPermissionPlayerManager.getCachedPermissionPlayer(uUID);
            if (iPermissionPlayer == null) {
                return null;
            }
            IPermissionPlayer permissionPlayer = iPermissionPlayer;
            List<TablistInformation> informationList = Config.Companion.getConfig().getInformationList();
            Iterable $this$sortedBy$iv = informationList;
            boolean $i$f$sortedBy = false;
            boolean bl = false;
            $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

                public final int compare(T a, T b) {
                    boolean bl = false;
                    TablistInformation it = (TablistInformation)a;
                    boolean bl2 = false;
                    Comparable comparable = Integer.valueOf(it.getPriority());
                    it = (TablistInformation)b;
                    Comparable comparable2 = comparable;
                    bl2 = false;
                    Integer n = it.getPriority();
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
                }
            });
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                TablistInformation it = (TablistInformation)element$iv2;
                boolean bl2 = false;
                if (!permissionPlayer.hasPermissionGroup(it.getGroupName())) continue;
                break block2;
            }
            throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        TablistInformation tablistInformation = (TablistInformation)element$iv2;
        return tablistInformation;
    }

    private TablistHelper() {
    }

    static {
        TablistHelper tablistHelper;
        INSTANCE = tablistHelper = new TablistHelper();
    }
}

