/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.module.notify;

import eu.thesimplecloud.api.CloudAPI;
import eu.thesimplecloud.api.event.service.CloudServiceRegisteredEvent;
import eu.thesimplecloud.api.event.service.CloudServiceStartedEvent;
import eu.thesimplecloud.api.event.service.CloudServiceUnregisteredEvent;
import eu.thesimplecloud.api.eventapi.CloudEventHandler;
import eu.thesimplecloud.api.eventapi.IListener;
import eu.thesimplecloud.api.player.ICloudPlayer;
import eu.thesimplecloud.api.player.text.CloudText;
import eu.thesimplecloud.api.service.ICloudService;
import eu.thesimplecloud.module.notify.NotifyModule;
import java.math.BigDecimal;
import java.math.RoundingMode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\n\u001a\u00020\bH\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000fH\u0007J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0010H\u0007J\u0018\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\bH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Leu/thesimplecloud/module/notify/CloudListener;", "Leu/thesimplecloud/api/eventapi/IListener;", "module", "Leu/thesimplecloud/module/notify/NotifyModule;", "(Leu/thesimplecloud/module/notify/NotifyModule;)V", "cloudText", "Leu/thesimplecloud/api/player/text/CloudText;", "message", "", "permission", "getMessage", "on", "", "event", "Leu/thesimplecloud/api/event/service/CloudServiceRegisteredEvent;", "Leu/thesimplecloud/api/event/service/CloudServiceStartedEvent;", "Leu/thesimplecloud/api/event/service/CloudServiceUnregisteredEvent;", "sendCloudMessage", "service", "Leu/thesimplecloud/api/service/ICloudService;", "addClick", "", "setText", "simplecloud-module-notify"})
@SourceDebugExtension(value={"SMAP\nCloudListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CloudListener.kt\neu/thesimplecloud/module/notify/CloudListener\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,106:1\n1#2:107\n1855#3,2:108\n*S KotlinDebug\n*F\n+ 1 CloudListener.kt\neu/thesimplecloud/module/notify/CloudListener\n*L\n98#1:108,2\n*E\n"})
public final class CloudListener
implements IListener {
    @NotNull
    private final NotifyModule module;
    private String message;
    private CloudText cloudText;
    @NotNull
    private final String permission;

    public CloudListener(@NotNull NotifyModule module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        this.module = module;
        this.permission = "cloud.module.notify.messages";
    }

    @CloudEventHandler
    public final void on(@NotNull CloudServiceRegisteredEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.setText(this.module.getConfig().getServiceStartingMessage());
        this.sendCloudMessage(event.getCloudService(), false);
    }

    @CloudEventHandler
    public final void on(@NotNull CloudServiceStartedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.setText(this.module.getConfig().getServiceStartedMessage());
        String cpuUsage = String.valueOf(event.getCloudService().getWrapper().getCpuUsage() * (float)100);
        BigDecimal decimal = new BigDecimal(cpuUsage).setScale(2, RoundingMode.HALF_EVEN);
        String string = event.getCloudService().getWrapperName();
        if (string != null) {
            String it = string;
            boolean bl = false;
            String string2 = StringsKt.replace$default((String)StringsKt.replace$default((String)this.getMessage(), (String)"%WRAPPER%", (String)it, (boolean)false, (int)4, null), (String)"%CPUUSAGE%", (String)("" + decimal + '%'), (boolean)false, (int)4, null);
            if (string2 != null) {
                it = string2;
                boolean bl2 = false;
                this.setText(it);
            }
        }
        this.sendCloudMessage(event.getCloudService(), true);
    }

    @CloudEventHandler
    public final void on(@NotNull CloudServiceUnregisteredEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.setText(this.module.getConfig().getServiceStoppedMessage());
        String cpuUsage = String.valueOf(event.getCloudService().getWrapper().getCpuUsage() * (float)100);
        BigDecimal decimal = new BigDecimal(cpuUsage).setScale(2, RoundingMode.HALF_EVEN);
        String string = event.getCloudService().getWrapperName();
        if (string != null) {
            String it = string;
            boolean bl = false;
            String string2 = StringsKt.replace$default((String)StringsKt.replace$default((String)this.getMessage(), (String)"%WRAPPER%", (String)it, (boolean)false, (int)4, null), (String)"%CPUUSAGE%", (String)("" + decimal + '%'), (boolean)false, (int)4, null);
            if (string2 != null) {
                it = string2;
                boolean bl2 = false;
                this.setText(it);
            }
        }
        this.sendCloudMessage(event.getCloudService(), false);
    }

    private final void setText(String message) {
        this.message = message;
    }

    private final String getMessage() {
        String string = this.message;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"message");
            string = null;
        }
        return string;
    }

    private final void sendCloudMessage(ICloudService service, boolean addClick) {
        String replacedMessage = StringsKt.replace$default((String)StringsKt.replace$default((String)this.getMessage(), (String)"%SERVICE%", (String)service.getName(), (boolean)false, (int)4, null), (String)"%DISPLAYNAME%", (String)service.getDisplayName(), (boolean)false, (int)4, null);
        this.cloudText = new CloudText(replacedMessage);
        if (addClick) {
            CloudText cloudText = this.cloudText;
            if (cloudText == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"cloudText");
                cloudText = null;
            }
            cloudText.addHover(this.module.getConfig().getHoverMessage());
            CloudText cloudText2 = this.cloudText;
            if (cloudText2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"cloudText");
                cloudText2 = null;
            }
            cloudText2.addClickEvent(CloudText.ClickEventType.RUN_COMMAND, "/server " + service.getName());
        }
        Iterable $this$forEach$iv = CloudAPI.Companion.getInstance().getCloudPlayerManager().getAllCachedObjects();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ICloudPlayer cloudPlayer = (ICloudPlayer)element$iv;
            boolean bl = false;
            cloudPlayer.hasPermission(this.permission).then((Function1)new Function1<Boolean, Unit>(cloudPlayer, this){
                final /* synthetic */ ICloudPlayer $cloudPlayer;
                final /* synthetic */ CloudListener this$0;
                {
                    this.$cloudPlayer = $cloudPlayer;
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(boolean it) {
                    if (it) {
                        CloudText cloudText = CloudListener.access$getCloudText$p(this.this$0);
                        if (cloudText == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"cloudText");
                            cloudText = null;
                        }
                        this.$cloudPlayer.sendMessage(cloudText);
                    }
                }
            });
        }
    }

    public static final /* synthetic */ CloudText access$getCloudText$p(CloudListener $this) {
        return $this.cloudText;
    }
}

