/*
 * Decompiled with CFR 0.152.
 */
package com.github.juliarn.npclib.api.profile;

import com.github.juliarn.npclib.api.profile.Profile;
import com.github.juliarn.npclib.api.profile.ProfileResolver;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class DefaultCachedProfileResolver
implements ProfileResolver.Cached {
    private static final long ENTRY_KEEP_ALIVE_TIME = TimeUnit.HOURS.toMillis(3L);
    private final ProfileResolver delegate;
    private final Map<String, CacheEntry<UUID>> nameToUniqueIdCache = new HashMap<String, CacheEntry<UUID>>();
    private final Map<UUID, CacheEntry<Profile.Resolved>> uuidToProfileCache = new HashMap<UUID, CacheEntry<Profile.Resolved>>();

    public DefaultCachedProfileResolver(@NotNull ProfileResolver delegate) {
        this.delegate = delegate;
    }

    @Override
    @NotNull
    public CompletableFuture<Profile.Resolved> resolveProfile(@NotNull Profile profile) {
        Profile.Resolved cached = this.fromCache(profile);
        if (cached != null) {
            return CompletableFuture.completedFuture(cached);
        }
        return this.delegate.resolveProfile(profile).whenComplete((resolvedProfile, exception) -> {
            if (exception == null && resolvedProfile != null) {
                this.nameToUniqueIdCache.put(resolvedProfile.name(), new CacheEntry<UUID>(resolvedProfile.uniqueId(), ENTRY_KEEP_ALIVE_TIME));
                this.uuidToProfileCache.put(resolvedProfile.uniqueId(), new CacheEntry<Profile.Resolved>((Profile.Resolved)resolvedProfile, ENTRY_KEEP_ALIVE_TIME));
            }
        });
    }

    @Override
    @Nullable
    public Profile.Resolved fromCache(@NotNull String name) {
        UUID cachedUniqueId = DefaultCachedProfileResolver.findCacheEntry(this.nameToUniqueIdCache, name);
        return cachedUniqueId == null ? null : this.fromCache(cachedUniqueId);
    }

    @Override
    @Nullable
    public Profile.Resolved fromCache(@NotNull UUID uniqueId) {
        return DefaultCachedProfileResolver.findCacheEntry(this.uuidToProfileCache, uniqueId);
    }

    @Override
    @Nullable
    public Profile.Resolved fromCache(@NotNull Profile profile) {
        Profile.Resolved cached;
        UUID profileId = profile.uniqueId();
        if (profileId != null && (cached = this.fromCache(profileId)) != null) {
            return cached;
        }
        String name = profile.name();
        if (name != null) {
            return this.fromCache(name);
        }
        return null;
    }

    @Nullable
    private static <K, V> V findCacheEntry(@NotNull Map<K, CacheEntry<V>> cache, @NotNull K key) {
        CacheEntry<V> entry = cache.get(key);
        if (entry == null) {
            return null;
        }
        if (((CacheEntry)entry).timeoutTime <= System.currentTimeMillis()) {
            cache.remove(key);
            return null;
        }
        return (V)((CacheEntry)entry).value;
    }

    private static final class CacheEntry<T> {
        private final T value;
        private final long timeoutTime;

        public CacheEntry(@Nullable T value, long keepMillis) {
            this.value = value;
            this.timeoutTime = System.currentTimeMillis() + keepMillis;
        }
    }
}

