/*
 * Decompiled with CFR 0.152.
 */
package com.github.juliarn.npclib.api.profile;

import com.github.juliarn.npclib.api.profile.Profile;
import com.github.juliarn.npclib.api.profile.ProfileProperty;
import com.github.juliarn.npclib.api.profile.ProfileResolver;
import com.github.juliarn.npclib.api.util.Util;
import com.github.juliarn.npclib.relocate.gson.Gson;
import com.github.juliarn.npclib.relocate.gson.GsonBuilder;
import com.github.juliarn.npclib.relocate.gson.JsonObject;
import com.github.juliarn.npclib.relocate.gson.JsonParser;
import com.github.juliarn.npclib.relocate.gson.TypeAdapter;
import com.github.juliarn.npclib.relocate.gson.reflect.TypeToken;
import com.github.juliarn.npclib.relocate.gson.stream.JsonReader;
import com.github.juliarn.npclib.relocate.gson.stream.JsonToken;
import com.github.juliarn.npclib.relocate.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class MojangProfileResolver
implements ProfileResolver {
    public static final MojangProfileResolver INSTANCE = new MojangProfileResolver();
    private static final int DEFAULT_TIMEOUT = (int)TimeUnit.SECONDS.toMillis(10L);
    private static final Type PROFILE_PROPERTIES_TYPE = TypeToken.getParameterized(Set.class, new Type[]{ProfileProperty.class}).getType();
    private static final Gson GSON = new GsonBuilder().disableJdkUnsafe().disableHtmlEscaping().registerTypeAdapter((Type)((Object)ProfileProperty.class), new ProfilePropertyTypeAdapter()).create();
    private static final Pattern UUID_NO_DASH_PATTERN = Pattern.compile("-", 16);
    private static final Pattern UUID_DASHER_PATTERN = Pattern.compile("(\\w{8})(\\w{4})(\\w{4})(\\w{4})(\\w{12})");
    private static final String NAME_TO_UUID_ENDPOINT = "https://api.mojang.com/users/profiles/minecraft/%s";
    private static final String UUID_TO_PROFILE_ENDPOINT = "https://sessionserver.mojang.com/session/minecraft/profile/%s";

    MojangProfileResolver() {
    }

    @Override
    @NotNull
    public CompletableFuture<Profile.Resolved> resolveProfile(@NotNull Profile profile) {
        return CompletableFuture.supplyAsync(Util.callableToSupplier(() -> {
            UUID uniqueId = profile.uniqueId();
            if (uniqueId == null) {
                JsonObject responseData = MojangProfileResolver.makeRequest(String.format(NAME_TO_UUID_ENDPOINT, profile.name()));
                String rawUniqueId = responseData.get("id").getAsString();
                String dashedId = UUID_DASHER_PATTERN.matcher(rawUniqueId).replaceAll("$1-$2-$3-$4-$5");
                uniqueId = UUID.fromString(dashedId);
            }
            String profileId = UUID_NO_DASH_PATTERN.matcher(uniqueId.toString()).replaceAll("");
            JsonObject responseData = MojangProfileResolver.makeRequest(String.format(UUID_TO_PROFILE_ENDPOINT, profileId));
            String name = responseData.get("name").getAsString();
            Set properties = (Set)GSON.fromJson(responseData.get("properties"), PROFILE_PROPERTIES_TYPE);
            return Profile.resolved(name, uniqueId, properties);
        }));
    }

    @NotNull
    private static JsonObject makeRequest(@NotNull String endpoint) throws IOException {
        HttpURLConnection connection = MojangProfileResolver.createBaseConnection(endpoint);
        int redirectCount = 0;
        do {
            boolean redirect;
            connection.connect();
            int status = connection.getResponseCode();
            boolean bl = redirect = status == 302 || status == 301 || status == 303;
            if (!redirect) {
                if (status == 200) {
                    try (InputStreamReader reader = new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8);){
                        JsonObject jsonObject = JsonParser.parseReader(reader).getAsJsonObject();
                        return jsonObject;
                    }
                }
                throw new IllegalArgumentException("Unable to fetch data, server responded with " + status);
            }
            String cookies = connection.getHeaderField("Set-Cookie");
            String redirectTarget = connection.getHeaderField("Location");
            connection = MojangProfileResolver.createBaseConnection(redirectTarget);
            connection.setRequestProperty("Cookie", cookies);
        } while (redirectCount++ < 10);
        throw new IllegalStateException("Endpoint request redirected more than 10 times!");
    }

    @NotNull
    private static HttpURLConnection createBaseConnection(@NotNull String endpoint) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)new URL(endpoint).openConnection();
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Connection", "close");
        connection.setRequestProperty("Accept", "application/json");
        connection.setRequestProperty("User-Agent", "juliarn/npc-lib2");
        connection.setReadTimeout(DEFAULT_TIMEOUT);
        connection.setConnectTimeout(DEFAULT_TIMEOUT);
        connection.setUseCaches(true);
        connection.setInstanceFollowRedirects(true);
        return connection;
    }

    private static final class ProfilePropertyTypeAdapter
    extends TypeAdapter<ProfileProperty> {
        private ProfilePropertyTypeAdapter() {
        }

        @Override
        public void write(@NotNull JsonWriter out, @Nullable ProfileProperty property) throws IOException {
            if (property != null) {
                out.beginObject().name("name").value(property.name()).name("value").value(property.value()).name("signature").value(property.signature()).endObject();
            }
        }

        @Override
        @Nullable
        public ProfileProperty read(@NotNull JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            String name = null;
            String value = null;
            String signature = null;
            in.beginObject();
            block10: while (in.peek() != JsonToken.END_OBJECT) {
                String fieldName = in.nextName();
                switch (fieldName.toLowerCase()) {
                    case "name": {
                        name = in.nextString();
                        continue block10;
                    }
                    case "value": {
                        value = in.nextString();
                        continue block10;
                    }
                    case "signature": {
                        if (in.peek() == JsonToken.NULL) {
                            in.nextNull();
                            continue block10;
                        }
                        signature = in.nextString();
                        continue block10;
                    }
                }
                in.skipValue();
            }
            in.endObject();
            return name != null && value != null ? ProfileProperty.property(name, value, signature) : null;
        }
    }
}

