/*
 * Decompiled with CFR 0.152.
 */
package com.github.juliarn.npclib.api.profile;

import com.github.juliarn.npclib.api.profile.DefaultCachedProfileResolver;
import com.github.juliarn.npclib.api.profile.MojangProfileResolver;
import com.github.juliarn.npclib.api.profile.Profile;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@FunctionalInterface
public interface ProfileResolver {
    @NotNull
    public static ProfileResolver mojang() {
        return MojangProfileResolver.INSTANCE;
    }

    @NotNull
    public static Cached caching(@NotNull ProfileResolver delegate) {
        Objects.requireNonNull(delegate, "delegate");
        return new DefaultCachedProfileResolver(delegate);
    }

    @NotNull
    public CompletableFuture<Profile.Resolved> resolveProfile(@NotNull Profile var1);

    public static interface Cached
    extends ProfileResolver {
        @Nullable
        public Profile.Resolved fromCache(@NotNull String var1);

        @Nullable
        public Profile.Resolved fromCache(@NotNull UUID var1);

        @Nullable
        public Profile.Resolved fromCache(@NotNull Profile var1);
    }
}

