/*
 * Decompiled with CFR 0.152.
 */
package com.github.juliarn.npclib.api.protocol.meta;

import com.github.juliarn.npclib.api.PlatformVersionAccessor;
import com.github.juliarn.npclib.api.protocol.meta.EntityMetadata;
import com.github.juliarn.npclib.api.protocol.meta.EntityMetadataFactory;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

final class DefaultEntityMetadataFactory<I, O>
implements EntityMetadataFactory<I, O> {
    private final int baseIndex;
    private final int[] indexShitVersions;
    private final Type type;
    private final Function<I, O> inputConverter;
    private final Collection<EntityMetadataFactory<I, Object>> relatedMetadata;
    private final Function<PlatformVersionAccessor, Boolean> availabilityChecker;

    public DefaultEntityMetadataFactory(int baseIndex, int[] indexShitVersions, @NotNull Type type, @NotNull Function<I, O> inputConverter, @NotNull Collection<EntityMetadataFactory<I, Object>> relatedMetadata, @NotNull Function<PlatformVersionAccessor, Boolean> availabilityChecker) {
        this.baseIndex = baseIndex;
        this.indexShitVersions = indexShitVersions;
        this.type = type;
        this.inputConverter = inputConverter;
        this.relatedMetadata = Collections.unmodifiableCollection(relatedMetadata);
        this.availabilityChecker = availabilityChecker;
    }

    @Override
    public @Unmodifiable @NotNull Collection<EntityMetadataFactory<I, Object>> relatedMetadata() {
        return this.relatedMetadata;
    }

    @Override
    @NotNull
    public EntityMetadata<O> create(@NotNull I input, @NotNull PlatformVersionAccessor versionAccessor) {
        O value;
        if (this.availabilityChecker.apply(versionAccessor).booleanValue() && (value = this.inputConverter.apply(input)) != null) {
            int index = this.baseIndex + this.calcIndexShift(versionAccessor);
            return new AvailableEntityMetadata(index, value, this.type);
        }
        return UnavailableEntityMetadata.INSTANCE;
    }

    private int calcIndexShift(@NotNull PlatformVersionAccessor versionAccessor) {
        int shift = 0;
        for (int version : this.indexShitVersions) {
            if (versionAccessor.minor() < version) continue;
            ++shift;
        }
        return shift;
    }

    private static final class AvailableEntityMetadata<O>
    implements EntityMetadata<O> {
        private final int index;
        private final O value;
        private final Type type;

        private AvailableEntityMetadata(int index, @NotNull O value, @NotNull Type type) {
            this.index = index;
            this.value = value;
            this.type = type;
        }

        @Override
        public int index() {
            return this.index;
        }

        @Override
        public boolean available() {
            return true;
        }

        @Override
        @NotNull
        public O value() {
            return this.value;
        }

        @Override
        @NotNull
        public Type type() {
            return this.type;
        }
    }

    private static final class UnavailableEntityMetadata
    implements EntityMetadata<Object> {
        private static final UnavailableEntityMetadata INSTANCE = new UnavailableEntityMetadata();

        private UnavailableEntityMetadata() {
        }

        @Override
        public int index() {
            throw new UnsupportedOperationException("Unavailable entity metadata cannot be accessed");
        }

        @Override
        public boolean available() {
            return false;
        }

        @Override
        @NotNull
        public Object value() {
            throw new UnsupportedOperationException("Unavailable entity metadata cannot be accessed");
        }

        @Override
        @NotNull
        public Class<Object> type() {
            throw new UnsupportedOperationException("Unavailable entity metadata cannot be accessed");
        }
    }
}

