/*
 * Decompiled with CFR 0.152.
 */
package com.github.juliarn.npclib.api.protocol.meta;

import com.github.juliarn.npclib.api.PlatformVersionAccessor;
import com.github.juliarn.npclib.api.protocol.meta.DefaultEntityMetadataFactory;
import com.github.juliarn.npclib.api.protocol.meta.EntityMetadataFactory;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

final class DefaultEntityMetadataFactoryBuilder<I, O>
implements EntityMetadataFactory.Builder<I, O> {
    private int baseIndex = 0;
    private int[] indexShitVersions = new int[0];
    private Type type;
    private Function<I, O> inputConverter;
    private Collection<EntityMetadataFactory<I, Object>> relatedMetadata;
    private Function<PlatformVersionAccessor, Boolean> availabilityChecker;

    DefaultEntityMetadataFactoryBuilder() {
    }

    @Override
    @NotNull
    public EntityMetadataFactory.Builder<I, O> baseIndex(int index) {
        this.baseIndex = index;
        return this;
    }

    @Override
    @NotNull
    public EntityMetadataFactory.Builder<I, O> indexShiftVersions(int ... versions) {
        this.indexShitVersions = versions;
        return this;
    }

    @Override
    @NotNull
    public EntityMetadataFactory.Builder<I, O> type(@NotNull Type type) {
        this.type = Objects.requireNonNull(type, "type");
        return this;
    }

    @Override
    @NotNull
    public EntityMetadataFactory.Builder<I, O> inputConverter(@NotNull Function<I, O> mapper) {
        this.inputConverter = Objects.requireNonNull(mapper, "mapper");
        return this;
    }

    @Override
    @NotNull
    public EntityMetadataFactory.Builder<I, O> addRelatedMetadata(@NotNull EntityMetadataFactory<I, Object> relatedMetadata) {
        if (this.relatedMetadata == null) {
            this.relatedMetadata = new HashSet<EntityMetadataFactory<I, Object>>();
        }
        this.relatedMetadata.add(relatedMetadata);
        return this;
    }

    @Override
    @NotNull
    public EntityMetadataFactory.Builder<I, O> availabilityChecker(@NotNull Function<PlatformVersionAccessor, Boolean> checker) {
        this.availabilityChecker = Objects.requireNonNull(checker, "checker");
        return this;
    }

    @Override
    @NotNull
    public EntityMetadataFactory<I, O> build() {
        if (this.relatedMetadata == null) {
            this.relatedMetadata = Collections.emptySet();
        }
        if (this.availabilityChecker == null) {
            this.availabilityChecker = accessor -> true;
        }
        return new DefaultEntityMetadataFactory<I, O>(this.baseIndex, this.indexShitVersions, Objects.requireNonNull(this.type, "type"), Objects.requireNonNull(this.inputConverter, "inputConverter"), this.relatedMetadata, this.availabilityChecker);
    }
}

