/*
 * Decompiled with CFR 0.152.
 */
package com.github.juliarn.npclib.api.protocol.meta;

import com.github.juliarn.npclib.api.PlatformVersionAccessor;
import com.github.juliarn.npclib.api.protocol.enums.EntityStatus;
import com.github.juliarn.npclib.api.protocol.meta.DefaultEntityMetadata;
import com.github.juliarn.npclib.api.protocol.meta.DefaultEntityMetadataFactoryBuilder;
import com.github.juliarn.npclib.api.protocol.meta.EntityMetadata;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public interface EntityMetadataFactory<I, O> {
    @NotNull
    public static <I, O> Builder<I, O> metaFactoryBuilder() {
        return new DefaultEntityMetadataFactoryBuilder();
    }

    @NotNull
    public static EntityMetadataFactory<Boolean, Byte> sneakingMetaFactory() {
        return DefaultEntityMetadata.SNEAKING;
    }

    @NotNull
    public static EntityMetadataFactory<Boolean, Byte> skinLayerMetaFactory() {
        return DefaultEntityMetadata.SKIN_LAYERS;
    }

    @NotNull
    public static EntityMetadataFactory<Collection<EntityStatus>, Byte> entityStatusMetaFactory() {
        return DefaultEntityMetadata.ENTITY_STATUS;
    }

    public @Unmodifiable @NotNull Collection<EntityMetadataFactory<I, Object>> relatedMetadata();

    @NotNull
    public EntityMetadata<O> create(@NotNull I var1, @NotNull PlatformVersionAccessor var2);

    public static interface Builder<I, O> {
        @NotNull
        public Builder<I, O> baseIndex(int var1);

        @NotNull
        public Builder<I, O> indexShiftVersions(int ... var1);

        @NotNull
        public Builder<I, O> type(@NotNull Type var1);

        @NotNull
        public Builder<I, O> inputConverter(@NotNull Function<I, O> var1);

        @NotNull
        public Builder<I, O> addRelatedMetadata(@NotNull EntityMetadataFactory<I, Object> var1);

        @NotNull
        public Builder<I, O> availabilityChecker(@NotNull Function<PlatformVersionAccessor, Boolean> var1);

        @NotNull
        public EntityMetadataFactory<I, O> build();
    }
}

