/*
 * Decompiled with CFR 0.152.
 */
package com.github.juliarn.npclib.api.settings;

import com.github.juliarn.npclib.api.Npc;
import org.jetbrains.annotations.NotNull;

@FunctionalInterface
public interface NpcTrackingRule<P> {
    @NotNull
    public static <P> NpcTrackingRule<P> allPlayers() {
        return (npc, player) -> true;
    }

    @NotNull
    public static <P> NpcTrackingRule<P> onlyUnspecifiedPlayers() {
        return (npc, player) -> !npc.includedPlayers().contains(player);
    }

    @NotNull
    public static <P> NpcTrackingRule<P> onlyExplicitlyIncludedPlayers() {
        return (npc, player) -> npc.includedPlayers().contains(player);
    }

    public boolean shouldTrack(@NotNull Npc<?, P, ?, ?> var1, @NotNull P var2);
}

