/*
 * Decompiled with CFR 0.152.
 */
package com.github.juliarn.npclib.bukkit.protocol;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.ProtocolManager;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.events.PacketListener;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.comphenix.protocol.utility.MinecraftVersion;
import com.comphenix.protocol.wrappers.AbstractWrapper;
import com.comphenix.protocol.wrappers.EnumWrappers;
import com.comphenix.protocol.wrappers.MinecraftKey;
import com.comphenix.protocol.wrappers.Pair;
import com.comphenix.protocol.wrappers.PlayerInfoData;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import com.comphenix.protocol.wrappers.WrappedDataValue;
import com.comphenix.protocol.wrappers.WrappedDataWatcher;
import com.comphenix.protocol.wrappers.WrappedEnumEntityUseAction;
import com.comphenix.protocol.wrappers.WrappedGameProfile;
import com.comphenix.protocol.wrappers.WrappedSignedProperty;
import com.comphenix.protocol.wrappers.WrappedWatchableObject;
import com.github.juliarn.npclib.api.Npc;
import com.github.juliarn.npclib.api.Platform;
import com.github.juliarn.npclib.api.PlatformVersionAccessor;
import com.github.juliarn.npclib.api.event.InteractNpcEvent;
import com.github.juliarn.npclib.api.profile.ProfileProperty;
import com.github.juliarn.npclib.api.protocol.OutboundPacket;
import com.github.juliarn.npclib.api.protocol.PlatformPacketAdapter;
import com.github.juliarn.npclib.api.protocol.chat.Component;
import com.github.juliarn.npclib.api.protocol.enums.EntityAnimation;
import com.github.juliarn.npclib.api.protocol.enums.EntityPose;
import com.github.juliarn.npclib.api.protocol.enums.ItemSlot;
import com.github.juliarn.npclib.api.protocol.enums.PlayerInfoAction;
import com.github.juliarn.npclib.api.protocol.meta.EntityMetadata;
import com.github.juliarn.npclib.api.protocol.meta.EntityMetadataFactory;
import com.github.juliarn.npclib.bukkit.protocol.ProtocolUtil;
import com.github.juliarn.npclib.common.event.DefaultAttackNpcEvent;
import com.github.juliarn.npclib.common.event.DefaultInteractNpcEvent;
import com.github.juliarn.npclib.common.util.EventDispatcher;
import com.github.juliarn.npclib.relocate.gson.reflect.TypeToken;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiFunction;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ProtocolLibPacketAdapter
implements PlatformPacketAdapter<World, Player, ItemStack, Plugin> {
    static final ProtocolLibPacketAdapter INSTANCE = new ProtocolLibPacketAdapter();
    private static final Type OPTIONAL_COMPONENT_TYPE = TypeToken.getParameterized(Optional.class, new Type[]{MinecraftReflection.getIChatBaseComponentClass()}).getType();
    private static final ProtocolManager PROTOCOL_MANAGER = ProtocolLibrary.getProtocolManager();
    private static final MinecraftVersion SERVER_VERSION = MinecraftVersion.fromServerVersion((String)Bukkit.getVersion());
    private static final EnumMap<EntityPose, Object> ENTITY_POSE_CONVERTER;
    private static final EnumMap<ItemSlot, EnumWrappers.ItemSlot> ITEM_SLOT_CONVERTER;
    private static final EnumMap<EnumWrappers.Hand, InteractNpcEvent.Hand> HAND_CONVERTER;
    private static final EnumMap<PlayerInfoAction, EnumWrappers.PlayerInfoAction> PLAYER_INFO_ACTION_CONVERTER;
    private static final Map<Type, BiFunction<PlatformVersionAccessor, Object, Map.Entry<Type, Object>>> SERIALIZER_CONVERTERS;
    private static final EnumSet<EnumWrappers.PlayerInfoAction> ADD_ACTIONS;

    ProtocolLibPacketAdapter() {
    }

    @Nullable
    private static WrappedWatchableObject createWatchableObject(int index, @NotNull Type type, @NotNull Object value, @NotNull PlatformVersionAccessor versionAccessor) {
        BiFunction<PlatformVersionAccessor, Object, Map.Entry<Type, Object>> converter = SERIALIZER_CONVERTERS.get(type);
        if (converter != null) {
            Map.Entry<Type, Object> converted = converter.apply(versionAccessor, value);
            type = converted.getKey();
            value = converted.getValue();
            if (value == null) {
                return null;
            }
        }
        if (MinecraftVersion.COMBAT_UPDATE.atOrAbove()) {
            WrappedDataWatcher.Serializer serializer = WrappedDataWatcher.Registry.get(ProtocolUtil.extractRawType(type), (boolean)(type instanceof ParameterizedType));
            return new WrappedWatchableObject(new WrappedDataWatcher.WrappedDataWatcherObject(index, serializer), value);
        }
        return new WrappedWatchableObject(index, value);
    }

    @Override
    @NotNull
    public OutboundPacket<World, Player, ItemStack, Plugin> createEntitySpawnPacket() {
        return (player, npc) -> {
            PacketContainer container = new PacketContainer(PacketType.Play.Server.NAMED_ENTITY_SPAWN);
            container.getIntegers().write(0, (Object)npc.entityId());
            container.getUUIDs().write(0, (Object)npc.profile().uniqueId());
            if (MinecraftVersion.COMBAT_UPDATE.atOrAbove()) {
                container.getDoubles().write(0, (Object)npc.position().x()).write(1, (Object)npc.position().y()).write(2, (Object)npc.position().z());
            } else {
                container.getIntegers().write(1, (Object)((int)Math.floor(npc.position().x() * 32.0))).write(2, (Object)((int)Math.floor(npc.position().y() * 32.0))).write(3, (Object)((int)Math.floor(npc.position().z() * 32.0)));
            }
            container.getBytes().write(0, (Object)((byte)(npc.position().yaw() * 256.0f / 360.0f))).write(1, (Object)((byte)(npc.position().pitch() * 256.0f / 360.0f)));
            if (MinecraftVersion.VILLAGE_UPDATE.isAtLeast(SERVER_VERSION)) {
                container.getDataWatcherModifier().write(0, (Object)new WrappedDataWatcher());
            }
            PROTOCOL_MANAGER.sendServerPacket(player, container, false);
        };
    }

    @Override
    @NotNull
    public OutboundPacket<World, Player, ItemStack, Plugin> createEntityRemovePacket() {
        return (player, npc) -> {
            PacketContainer container = new PacketContainer(PacketType.Play.Server.ENTITY_DESTROY);
            if (MinecraftVersion.CAVES_CLIFFS_1.atOrAbove()) {
                container.getIntLists().write(0, (Object)Lists.newArrayList((Object[])new Integer[]{npc.entityId()}));
            } else {
                container.getIntegerArrays().write(0, (Object)new int[]{npc.entityId()});
            }
            PROTOCOL_MANAGER.sendServerPacket(player, container, false);
        };
    }

    @Override
    @NotNull
    public OutboundPacket<World, Player, ItemStack, Plugin> createPlayerInfoPacket(@NotNull PlayerInfoAction action) {
        return (player, npc) -> npc.settings().profileResolver().resolveNpcProfile((Player)player, npc).thenAcceptAsync(profile -> {
            if (action == PlayerInfoAction.REMOVE_PLAYER && MinecraftVersion.FEATURE_PREVIEW_UPDATE.atOrAbove()) {
                PacketContainer container = new PacketContainer(PacketType.Play.Server.PLAYER_INFO_REMOVE);
                List<UUID> uuidsToRemove = Collections.singletonList(profile.uniqueId());
                container.getUUIDLists().write(0, uuidsToRemove);
                PROTOCOL_MANAGER.sendServerPacket(player, container, false);
                return;
            }
            PacketContainer container = new PacketContainer(PacketType.Play.Server.PLAYER_INFO);
            int playerInfoDataIndex = 0;
            if (MinecraftVersion.FEATURE_PREVIEW_UPDATE.atOrAbove()) {
                playerInfoDataIndex = 1;
                container.getPlayerInfoActions().write(0, ADD_ACTIONS);
            } else {
                EnumWrappers.PlayerInfoAction playerInfoAction = PLAYER_INFO_ACTION_CONVERTER.get((Object)action);
                container.getPlayerInfoAction().write(0, (Object)playerInfoAction);
            }
            WrappedGameProfile wrappedGameProfile = new WrappedGameProfile(profile.uniqueId(), profile.name());
            for (ProfileProperty prop : profile.properties()) {
                WrappedSignedProperty wrapped = new WrappedSignedProperty(prop.name(), prop.value(), prop.signature());
                wrappedGameProfile.getProperties().put((Object)prop.name(), (Object)wrapped);
            }
            PlayerInfoData playerInfoData = new PlayerInfoData(profile.uniqueId(), 20, false, EnumWrappers.NativeGameMode.CREATIVE, wrappedGameProfile, null, null);
            container.getPlayerInfoDataLists().write(playerInfoDataIndex, (Object)Lists.newArrayList((Object[])new PlayerInfoData[]{playerInfoData}));
            PROTOCOL_MANAGER.sendServerPacket(player, container, false);
        });
    }

    @Override
    @NotNull
    public OutboundPacket<World, Player, ItemStack, Plugin> createRotationPacket(float yaw, float pitch) {
        return (player, npc) -> {
            PacketContainer rotation;
            byte yawAngle = (byte)(yaw * 256.0f / 360.0f);
            byte pitchAngle = (byte)(pitch * 256.0f / 360.0f);
            PacketContainer headRotation = new PacketContainer(PacketType.Play.Server.ENTITY_HEAD_ROTATION);
            headRotation.getBytes().write(0, (Object)yawAngle);
            headRotation.getIntegers().write(0, (Object)npc.entityId());
            if (MinecraftVersion.COMBAT_UPDATE.atOrAbove()) {
                rotation = new PacketContainer(PacketType.Play.Server.ENTITY_LOOK);
            } else {
                rotation = new PacketContainer(PacketType.Play.Server.ENTITY_TELEPORT);
                rotation.getIntegers().write(1, (Object)((int)Math.floor(npc.position().x() * 32.0))).write(2, (Object)((int)Math.floor(npc.position().y() * 32.0))).write(3, (Object)((int)Math.floor(npc.position().z() * 32.0)));
            }
            rotation.getIntegers().write(0, (Object)npc.entityId());
            rotation.getBytes().write(0, (Object)yawAngle).write(1, (Object)pitchAngle);
            rotation.getBooleans().write(0, (Object)true);
            PROTOCOL_MANAGER.sendServerPacket(player, rotation, false);
            PROTOCOL_MANAGER.sendServerPacket(player, headRotation, false);
        };
    }

    @Override
    @NotNull
    public OutboundPacket<World, Player, ItemStack, Plugin> createAnimationPacket(@NotNull EntityAnimation animation) {
        return (player, npc) -> {
            PacketContainer container = new PacketContainer(PacketType.Play.Server.ANIMATION);
            container.getIntegers().write(0, (Object)npc.entityId()).write(1, (Object)animation.id());
            PROTOCOL_MANAGER.sendServerPacket(player, container, false);
        };
    }

    @Override
    @NotNull
    public OutboundPacket<World, Player, ItemStack, Plugin> createEquipmentPacket(@NotNull ItemSlot slot, @NotNull ItemStack item) {
        return (player, npc) -> {
            PacketContainer container = new PacketContainer(PacketType.Play.Server.ENTITY_EQUIPMENT);
            container.getIntegers().write(0, (Object)npc.entityId());
            if (MinecraftVersion.NETHER_UPDATE.atOrAbove()) {
                EnumWrappers.ItemSlot itemSlot = ITEM_SLOT_CONVERTER.get((Object)slot);
                container.getSlotStackPairLists().write(0, (Object)Lists.newArrayList((Object[])new Pair[]{new Pair((Object)itemSlot, (Object)item)}));
            } else {
                if (MinecraftVersion.COMBAT_UPDATE.atOrAbove()) {
                    container.getItemSlots().write(0, (Object)ITEM_SLOT_CONVERTER.get((Object)slot));
                } else {
                    int slotId = slot.ordinal();
                    if (slotId > 0) {
                        --slotId;
                    }
                    container.getIntegers().write(1, (Object)slotId);
                }
                container.getItemModifier().write(0, (Object)item);
            }
            PROTOCOL_MANAGER.sendServerPacket(player, container, false);
        };
    }

    @Override
    @NotNull
    public OutboundPacket<World, Player, ItemStack, Plugin> createCustomPayloadPacket(@NotNull String channelId, byte[] payload) {
        return (player, npc) -> {
            PacketContainer container = new PacketContainer(PacketType.Play.Server.CUSTOM_PAYLOAD);
            if (MinecraftVersion.AQUATIC_UPDATE.atOrAbove()) {
                String[] parts = channelId.split(":", 2);
                MinecraftKey key = parts.length == 1 ? new MinecraftKey(channelId) : new MinecraftKey(parts[0], parts[1]);
                container.getMinecraftKeys().write(0, (Object)key);
            } else {
                container.getStrings().write(0, (Object)channelId);
            }
            ByteBuf buffer = Unpooled.copiedBuffer((byte[])payload);
            Object wrappedSerializableBuffer = MinecraftReflection.getPacketDataSerializer((Object)buffer);
            container.getModifier().withType(ByteBuf.class).write(0, wrappedSerializableBuffer);
            PROTOCOL_MANAGER.sendServerPacket(player, container, false);
        };
    }

    @Override
    @NotNull
    public <T, O> OutboundPacket<World, Player, ItemStack, Plugin> createEntityMetaPacket(@NotNull T value, @NotNull EntityMetadataFactory<T, O> metadata) {
        return (player, npc) -> {
            PlatformVersionAccessor versionAcc = npc.platform().versionAccessor();
            EntityMetadata entityMetadata = metadata.create(value, versionAcc);
            if (!entityMetadata.available()) {
                return;
            }
            ArrayList<WrappedWatchableObject> watchableObjects = new ArrayList<WrappedWatchableObject>();
            watchableObjects.add(ProtocolLibPacketAdapter.createWatchableObject(entityMetadata.index(), entityMetadata.type(), entityMetadata.value(), versionAcc));
            for (EntityMetadataFactory<Object, Object> entityMetadataFactory : metadata.relatedMetadata()) {
                WrappedWatchableObject watchableObject;
                EntityMetadata<Object> related = entityMetadataFactory.create(value, versionAcc);
                if (!related.available() || (watchableObject = ProtocolLibPacketAdapter.createWatchableObject(related.index(), related.type(), related.value(), versionAcc)) == null) continue;
                watchableObjects.add(watchableObject);
            }
            PacketContainer container = new PacketContainer(PacketType.Play.Server.ENTITY_METADATA);
            container.getIntegers().write(0, (Object)npc.entityId());
            if (MinecraftVersion.FEATURE_PREVIEW_UPDATE.atOrAbove()) {
                ArrayList<WrappedDataValue> arrayList = new ArrayList<WrappedDataValue>(watchableObjects.size());
                for (WrappedWatchableObject object : watchableObjects) {
                    WrappedDataValue dataValue = new WrappedDataValue(object.getIndex(), object.getWatcherObject().getSerializer(), object.getRawValue());
                    arrayList.add(dataValue);
                }
                container.getDataValueCollectionModifier().write(0, arrayList);
            } else {
                container.getWatchableCollectionModifier().write(0, watchableObjects);
            }
            PROTOCOL_MANAGER.sendServerPacket(player, container, false);
        };
    }

    @Override
    public void initialize(@NotNull Platform<World, Player, ItemStack, Plugin> platform) {
        PROTOCOL_MANAGER.addPacketListener((PacketListener)new NpcUsePacketAdapter(platform));
    }

    static {
        ADD_ACTIONS = EnumSet.of(EnumWrappers.PlayerInfoAction.ADD_PLAYER, EnumWrappers.PlayerInfoAction.UPDATE_LISTED, EnumWrappers.PlayerInfoAction.UPDATE_LATENCY, EnumWrappers.PlayerInfoAction.UPDATE_GAME_MODE, EnumWrappers.PlayerInfoAction.UPDATE_DISPLAY_NAME);
        ITEM_SLOT_CONVERTER = new EnumMap(ItemSlot.class);
        ITEM_SLOT_CONVERTER.put(ItemSlot.MAIN_HAND, EnumWrappers.ItemSlot.MAINHAND);
        ITEM_SLOT_CONVERTER.put(ItemSlot.OFF_HAND, EnumWrappers.ItemSlot.OFFHAND);
        ITEM_SLOT_CONVERTER.put(ItemSlot.FEET, EnumWrappers.ItemSlot.FEET);
        ITEM_SLOT_CONVERTER.put(ItemSlot.LEGS, EnumWrappers.ItemSlot.LEGS);
        ITEM_SLOT_CONVERTER.put(ItemSlot.CHEST, EnumWrappers.ItemSlot.CHEST);
        ITEM_SLOT_CONVERTER.put(ItemSlot.HEAD, EnumWrappers.ItemSlot.HEAD);
        HAND_CONVERTER = new EnumMap(EnumWrappers.Hand.class);
        HAND_CONVERTER.put(EnumWrappers.Hand.MAIN_HAND, InteractNpcEvent.Hand.MAIN_HAND);
        HAND_CONVERTER.put(EnumWrappers.Hand.OFF_HAND, InteractNpcEvent.Hand.OFF_HAND);
        ENTITY_POSE_CONVERTER = new EnumMap(EntityPose.class);
        if (EnumWrappers.getEntityPoseClass() != null) {
            ENTITY_POSE_CONVERTER.put(EntityPose.STANDING, EnumWrappers.EntityPose.STANDING.toNms());
            ENTITY_POSE_CONVERTER.put(EntityPose.FALL_FLYING, EnumWrappers.EntityPose.FALL_FLYING.toNms());
            ENTITY_POSE_CONVERTER.put(EntityPose.SLEEPING, EnumWrappers.EntityPose.SLEEPING.toNms());
            ENTITY_POSE_CONVERTER.put(EntityPose.SWIMMING, EnumWrappers.EntityPose.SWIMMING.toNms());
            ENTITY_POSE_CONVERTER.put(EntityPose.SPIN_ATTACK, EnumWrappers.EntityPose.SPIN_ATTACK.toNms());
            ENTITY_POSE_CONVERTER.put(EntityPose.CROUCHING, EnumWrappers.EntityPose.CROUCHING.toNms());
            ENTITY_POSE_CONVERTER.put(EntityPose.DYING, EnumWrappers.EntityPose.DYING.toNms());
            if (MinecraftVersion.CAVES_CLIFFS_1.atOrAbove()) {
                ENTITY_POSE_CONVERTER.put(EntityPose.LONG_JUMPING, EnumWrappers.EntityPose.LONG_JUMPING.toNms());
            }
            if (MinecraftVersion.WILD_UPDATE.atOrAbove()) {
                ENTITY_POSE_CONVERTER.put(EntityPose.CROAKING, EnumWrappers.EntityPose.CROAKING.toNms());
                ENTITY_POSE_CONVERTER.put(EntityPose.USING_TONGUE, EnumWrappers.EntityPose.USING_TONGUE.toNms());
                ENTITY_POSE_CONVERTER.put(EntityPose.ROARING, EnumWrappers.EntityPose.ROARING.toNms());
                ENTITY_POSE_CONVERTER.put(EntityPose.SNIFFING, EnumWrappers.EntityPose.SNIFFING.toNms());
                ENTITY_POSE_CONVERTER.put(EntityPose.EMERGING, EnumWrappers.EntityPose.EMERGING.toNms());
                ENTITY_POSE_CONVERTER.put(EntityPose.DIGGING, EnumWrappers.EntityPose.DIGGING.toNms());
            }
            if (MinecraftVersion.FEATURE_PREVIEW_UPDATE.atOrAbove()) {
                ENTITY_POSE_CONVERTER.put(EntityPose.SITTING, EnumWrappers.EntityPose.SITTING.toNms());
            }
        }
        PLAYER_INFO_ACTION_CONVERTER = new EnumMap(PlayerInfoAction.class);
        PLAYER_INFO_ACTION_CONVERTER.put(PlayerInfoAction.ADD_PLAYER, EnumWrappers.PlayerInfoAction.ADD_PLAYER);
        PLAYER_INFO_ACTION_CONVERTER.put(PlayerInfoAction.REMOVE_PLAYER, EnumWrappers.PlayerInfoAction.REMOVE_PLAYER);
        SERIALIZER_CONVERTERS = ImmutableMap.builder().put(EntityPose.class, ($, value) -> new AbstractMap.SimpleEntry<Class, Object>(EnumWrappers.getEntityPoseClass(), ENTITY_POSE_CONVERTER.get(value))).put((Object)TypeToken.getParameterized(Optional.class, new Type[]{Component.class}).getType(), (versionAccess, value) -> {
            Optional optionalComponent = (Optional)value;
            if (versionAccess.atLeast(1, 13, 0)) {
                return new AbstractMap.SimpleImmutableEntry<Type, Optional<Object>>(OPTIONAL_COMPONENT_TYPE, optionalComponent.map(component -> {
                    if (component.rawMessage() != null) {
                        return WrappedChatComponent.fromLegacyText((String)component.rawMessage());
                    }
                    return WrappedChatComponent.fromJson((String)component.encodedJsonMessage());
                }).map(AbstractWrapper::getHandle));
            }
            return new AbstractMap.SimpleImmutableEntry<Class<String>, Object>(String.class, optionalComponent.map(component -> Objects.requireNonNull(component.rawMessage(), "Versions older than 1.13 don't support json component")).orElse(null));
        }).build();
    }

    private static final class NpcUsePacketAdapter
    extends PacketAdapter {
        private final Platform<World, Player, ItemStack, Plugin> platform;

        public NpcUsePacketAdapter(@NotNull Platform<World, Player, ItemStack, Plugin> platform) {
            super(PacketAdapter.params((Plugin)platform.extension(), (PacketType[])new PacketType[]{PacketType.Play.Client.USE_ENTITY}).optionAsync());
            this.platform = platform;
        }

        public void onPacketReceiving(@NotNull PacketEvent event) {
            Player player = event.getPlayer();
            PacketContainer packet = event.getPacket();
            int entityId = (Integer)packet.getIntegers().read(0);
            Npc<World, Player, ItemStack, Plugin> npc = this.platform.npcTracker().npcById(entityId);
            if (npc != null) {
                EnumWrappers.EntityUseAction action;
                EnumWrappers.Hand hand = EnumWrappers.Hand.MAIN_HAND;
                if (MinecraftVersion.CAVES_CLIFFS_1.atOrAbove()) {
                    WrappedEnumEntityUseAction useAction = (WrappedEnumEntityUseAction)packet.getEnumEntityUseActions().read(0);
                    action = useAction.getAction();
                    if (action != EnumWrappers.EntityUseAction.ATTACK) {
                        hand = useAction.getHand();
                    }
                } else {
                    action = (EnumWrappers.EntityUseAction)packet.getEntityUseActions().read(0);
                    if (action != EnumWrappers.EntityUseAction.ATTACK && MinecraftVersion.COMBAT_UPDATE.atOrAbove()) {
                        hand = (EnumWrappers.Hand)packet.getHands().read(0);
                    }
                }
                switch (action) {
                    case ATTACK: {
                        EventDispatcher.dispatch(this.platform, DefaultAttackNpcEvent.attackNpc(npc, player));
                        break;
                    }
                    case INTERACT: {
                        InteractNpcEvent.Hand usedHand = (InteractNpcEvent.Hand)((Object)HAND_CONVERTER.get(hand));
                        EventDispatcher.dispatch(this.platform, DefaultInteractNpcEvent.interactNpc(npc, player, usedHand));
                        break;
                    }
                }
                event.setCancelled(true);
            }
        }
    }
}

