/*
 * Decompiled with CFR 0.152.
 */
package com.github.juliarn.npclib.common.npc;

import com.github.juliarn.npclib.api.Npc;
import com.github.juliarn.npclib.api.Platform;
import com.github.juliarn.npclib.api.Position;
import com.github.juliarn.npclib.api.profile.Profile;
import com.github.juliarn.npclib.api.profile.ProfileResolver;
import com.github.juliarn.npclib.api.settings.NpcSettings;
import com.github.juliarn.npclib.common.flag.CommonNpcFlaggedBuilder;
import com.github.juliarn.npclib.common.npc.CommonNpc;
import com.github.juliarn.npclib.common.settings.CommonNpcSettingsBuilder;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommonNpcBuilder<W, P, I, E>
extends CommonNpcFlaggedBuilder<Npc.Builder<W, P, I, E>>
implements Npc.Builder<W, P, I, E> {
    protected final Platform<W, P, I, E> platform;
    protected int entityId = ThreadLocalRandom.current().nextInt(0, Integer.MAX_VALUE);
    protected W world;
    protected Position pos;
    protected Profile.Resolved profile;
    protected NpcSettings<P> npcSettings;

    public CommonNpcBuilder(@NotNull Platform<W, P, I, E> platform) {
        this.platform = platform;
    }

    @Override
    @NotNull
    public Npc.Builder<W, P, I, E> entityId(int id) {
        if (id < 0) {
            throw new IllegalArgumentException("NPC entity id must be positive");
        }
        this.entityId = id;
        return this;
    }

    @Override
    @NotNull
    public Npc.Builder<W, P, I, E> position(@NotNull Position position) {
        Objects.requireNonNull(position, "position");
        W world = this.platform.worldAccessor().resolveWorldFromIdentifier(position.worldId());
        if (world == null) {
            throw new IllegalArgumentException("Could not resolve world from identifier: " + position.worldId());
        }
        this.world = world;
        this.pos = position;
        return this;
    }

    @Override
    @NotNull
    public Npc.Builder<W, P, I, E> profile(@NotNull Profile.Resolved profile) {
        this.profile = Objects.requireNonNull(profile, "profile");
        return this;
    }

    @Override
    @NotNull
    public CompletableFuture<Npc.Builder<W, P, I, E>> profile(@Nullable ProfileResolver resolver, @NotNull Profile profile) {
        if (resolver == null) {
            resolver = this.platform.profileResolver();
        }
        return resolver.resolveProfile(profile).thenApply(this::profile);
    }

    @Override
    @NotNull
    public Npc.Builder<W, P, I, E> npcSettings(@NotNull Consumer<NpcSettings.Builder<P>> decorator) {
        CommonNpcSettingsBuilder builder = new CommonNpcSettingsBuilder();
        decorator.accept(builder);
        this.npcSettings = builder.build();
        return this;
    }

    @Override
    @NotNull
    public Npc<W, P, I, E> build() {
        if (this.npcSettings == null) {
            this.npcSettings(builder -> {});
        }
        return new CommonNpc<W, P, I, E>(this.flags, this.entityId, Objects.requireNonNull(this.profile, "profile must be given"), Objects.requireNonNull(this.world, "world and position must be given"), Objects.requireNonNull(this.pos, "world and position must be given"), this.platform, Objects.requireNonNull(this.npcSettings, "npc settings must be given"));
    }

    @Override
    @NotNull
    public Npc<W, P, I, E> buildAndTrack() {
        Npc<W, P, I, E> npc = this.build();
        this.platform.npcTracker().trackNpc(npc);
        return npc;
    }
}

