/*
 * Decompiled with CFR 0.152.
 */
package com.github.juliarn.npclib.common.util;

import com.github.juliarn.npclib.api.Platform;
import com.github.juliarn.npclib.api.event.NpcEvent;
import java.util.Map;
import net.kyori.event.EventSubscriber;
import net.kyori.event.PostResult;
import org.jetbrains.annotations.NotNull;

public final class EventDispatcher {
    private EventDispatcher() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public static <W, P, I, E, N extends NpcEvent> N dispatch(@NotNull Platform<W, P, I, E> platform, @NotNull N event) {
        PostResult result = platform.eventBus().post(event);
        Map<EventSubscriber<?>, Throwable> exceptions = result.exceptions();
        if (!exceptions.isEmpty()) {
            for (Map.Entry<EventSubscriber<?>, Throwable> entry : exceptions.entrySet()) {
                Throwable thrown = entry.getValue();
                if (EventDispatcher.isFatal(thrown)) {
                    EventDispatcher.throwUnchecked(thrown);
                }
                if (!platform.debug()) continue;
                platform.logger().error(String.format("Subscriber %s was unable to handle %s:", entry.getKey().getClass().getName(), event.getClass().getSimpleName()), thrown);
            }
        }
        return event;
    }

    private static boolean isFatal(@NotNull Throwable throwable) {
        return throwable instanceof InterruptedException || throwable instanceof LinkageError || throwable instanceof ThreadDeath || throwable instanceof VirtualMachineError;
    }

    private static <T extends Throwable> void throwUnchecked(@NotNull Throwable throwable) throws T {
        throw throwable;
    }
}

