/*
 * Decompiled with CFR 0.152.
 */
package com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.potion;

import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.potion.PotionType;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.resources.ResourceLocation;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class PotionTypes {
    private static final Map<String, PotionType> POTION_TYPE_MAP = new HashMap<String, PotionType>();
    private static final Map<Byte, PotionType> POTION_TYPE_ID_MAP = new HashMap<Byte, PotionType>();
    public static final PotionType SPEED = PotionTypes.define("speed", 1);
    public static final PotionType SLOWNESS = PotionTypes.define("slowness", 2);
    public static final PotionType HASTE = PotionTypes.define("haste", 3);
    public static final PotionType MINING_FATIGUE = PotionTypes.define("mining_fatigue", 4);
    public static final PotionType STRENGTH = PotionTypes.define("strength", 5);
    public static final PotionType INSTANT_HEALTH = PotionTypes.define("instant_health", 6);
    public static final PotionType INSTANT_DAMAGE = PotionTypes.define("instant_damage", 7);
    public static final PotionType JUMP_BOOST = PotionTypes.define("jump_boost", 8);
    public static final PotionType NAUSEA = PotionTypes.define("nausea", 9);
    public static final PotionType REGENERATION = PotionTypes.define("regeneration", 10);
    public static final PotionType RESISTANCE = PotionTypes.define("resistance", 11);
    public static final PotionType FIRE_RESISTANCE = PotionTypes.define("fire_resistance", 12);
    public static final PotionType WATER_BREATHING = PotionTypes.define("water_breathing", 13);
    public static final PotionType INVISIBILITY = PotionTypes.define("invisibility", 14);
    public static final PotionType BLINDNESS = PotionTypes.define("blindness", 15);
    public static final PotionType NIGHT_VISION = PotionTypes.define("night_vision", 16);
    public static final PotionType HUNGER = PotionTypes.define("hunger", 17);
    public static final PotionType WEAKNESS = PotionTypes.define("weakness", 18);
    public static final PotionType POISON = PotionTypes.define("poison", 19);
    public static final PotionType WITHER = PotionTypes.define("wither", 20);
    public static final PotionType HEALTH_BOOST = PotionTypes.define("health_boost", 21);
    public static final PotionType ABSORPTION = PotionTypes.define("absorption", 22);
    public static final PotionType SATURATION = PotionTypes.define("saturation", 23);
    public static final PotionType GLOWING = PotionTypes.define("glowing", 24);
    public static final PotionType LEVITATION = PotionTypes.define("levitation", 25);
    public static final PotionType LUCK = PotionTypes.define("luck", 26);
    public static final PotionType UNLUCK = PotionTypes.define("unluck", 27);
    public static final PotionType SLOW_FALLING = PotionTypes.define("slow_falling", 28);
    public static final PotionType CONDUIT_POWER = PotionTypes.define("conduit_power", 29);
    public static final PotionType DOLPHINS_GRACE = PotionTypes.define("dolphins_grace", 30);
    public static final PotionType BAD_OMEN = PotionTypes.define("bad_omen", 31);
    public static final PotionType HERO_OF_THE_VILLAGE = PotionTypes.define("hero_of_the_village", 32);
    public static final PotionType DARKNESS = PotionTypes.define("darkness", 33);

    public static PotionType define(String key, final int id) {
        final ResourceLocation identifier = ResourceLocation.minecraft(key);
        PotionType potionType = new PotionType(){

            @Override
            public ResourceLocation getName() {
                return identifier;
            }

            @Override
            public int getId() {
                return id;
            }

            public boolean equals(Object obj) {
                if (obj instanceof PotionType) {
                    return this.getId() == ((PotionType)obj).getId();
                }
                return false;
            }
        };
        POTION_TYPE_MAP.put(potionType.getName().toString(), potionType);
        POTION_TYPE_ID_MAP.put((byte)potionType.getId(), potionType);
        return potionType;
    }

    @Nullable
    public static PotionType getByName(String name) {
        return POTION_TYPE_MAP.get(name);
    }

    @Nullable
    public static PotionType getById(int id) {
        return POTION_TYPE_ID_MAP.get((byte)id);
    }
}

