/*
 * Decompiled with CFR 0.152.
 */
package com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.world.chunk.palette;

import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.stream.NetStreamInput;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.world.chunk.palette.Palette;
import java.util.HashMap;

public class MapPalette
implements Palette {
    private final int maxId;
    private final int[] idToState;
    private final HashMap<Object, Integer> stateToId = new HashMap();
    private int nextId = 0;

    public MapPalette(int bitsPerEntry) {
        this.maxId = (1 << bitsPerEntry) - 1;
        this.idToState = new int[this.maxId + 1];
    }

    public MapPalette(int bitsPerEntry, NetStreamInput in) {
        this(bitsPerEntry);
        int paletteLength = in.readVarInt();
        for (int i = 0; i < paletteLength; ++i) {
            int state;
            this.idToState[i] = state = in.readVarInt();
            this.stateToId.putIfAbsent(state, i);
        }
        this.nextId = paletteLength;
    }

    @Override
    public int size() {
        return this.nextId;
    }

    @Override
    public int stateToId(int state) {
        Integer id = this.stateToId.get(state);
        if (id == null && this.size() < this.maxId + 1) {
            id = this.nextId++;
            this.idToState[id.intValue()] = state;
            this.stateToId.put(state, id);
        }
        if (id != null) {
            return id;
        }
        return -1;
    }

    @Override
    public int idToState(int id) {
        if (id >= 0 && id < this.size()) {
            return this.idToState[id];
        }
        return 0;
    }
}

