/*
 * Decompiled with CFR 0.152.
 */
package com.github.juliarn.npclib.relocate.com.packetevents.packetevents.wrapper.login.client;

import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.event.PacketReceiveEvent;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.manager.server.ServerVersion;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.netty.buffer.ByteBufHelper;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.packettype.PacketType;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.player.ClientVersion;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.util.crypto.MinecraftEncryptionUtil;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.util.crypto.SaltSignature;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.wrapper.PacketWrapper;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Optional;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.jetbrains.annotations.Nullable;

public class WrapperLoginClientEncryptionResponse
extends PacketWrapper<WrapperLoginClientEncryptionResponse> {
    private byte[] encryptedSharedSecret;
    private byte[] encryptedVerifyToken;
    private SaltSignature saltSignature;

    public WrapperLoginClientEncryptionResponse(PacketReceiveEvent event) {
        super(event);
    }

    public WrapperLoginClientEncryptionResponse(ClientVersion clientVersion, byte[] encryptedSharedSecret, byte[] encryptedVerifyToken) {
        super(PacketType.Login.Client.ENCRYPTION_RESPONSE.getId(), clientVersion);
        this.encryptedSharedSecret = encryptedSharedSecret;
        this.encryptedVerifyToken = encryptedVerifyToken;
    }

    public WrapperLoginClientEncryptionResponse(ClientVersion clientVersion, SaltSignature saltSignature) {
        super(PacketType.Login.Client.ENCRYPTION_RESPONSE.getId(), clientVersion);
        this.saltSignature = saltSignature;
    }

    @Override
    public void read() {
        this.encryptedSharedSecret = this.readByteArray(ByteBufHelper.readableBytes(this.buffer));
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_19) && !this.readBoolean()) {
            this.saltSignature = this.readSaltSignature();
        } else {
            this.encryptedVerifyToken = this.readByteArray();
        }
    }

    @Override
    public void write() {
        this.writeByteArray(this.encryptedSharedSecret);
        if (this.clientVersion.isNewerThanOrEquals(ClientVersion.V_1_19) && this.saltSignature != null) {
            this.writeBoolean(false);
            this.writeSaltSignature(this.saltSignature);
        } else {
            this.writeByteArray(this.encryptedVerifyToken);
        }
    }

    @Override
    public void copy(WrapperLoginClientEncryptionResponse wrapper) {
        this.encryptedSharedSecret = wrapper.encryptedSharedSecret;
        this.encryptedVerifyToken = wrapper.encryptedVerifyToken;
        this.saltSignature = wrapper.saltSignature;
    }

    public byte[] getEncryptedSharedSecret() {
        return this.encryptedSharedSecret;
    }

    public void setEncryptedSharedSecret(byte[] encryptedSharedSecret) {
        this.encryptedSharedSecret = encryptedSharedSecret;
    }

    public SecretKey getSecretKey(PrivateKey key) {
        byte[] data = this.getEncryptedSharedSecret();
        byte[] decryptedData = MinecraftEncryptionUtil.decrypt(key.getAlgorithm(), key, data);
        if (decryptedData != null) {
            return new SecretKeySpec(decryptedData, "AES");
        }
        return null;
    }

    public void setSharedKey(SecretKey key, PublicKey publicKey) {
        this.encryptedSharedSecret = MinecraftEncryptionUtil.encrypt(publicKey.getAlgorithm(), publicKey, key.getEncoded());
    }

    public Optional<byte[]> getEncryptedVerifyToken() {
        return Optional.ofNullable(this.encryptedVerifyToken);
    }

    public void setEncryptedVerifyToken(byte[] encryptedVerifyToken) {
        this.encryptedVerifyToken = encryptedVerifyToken;
    }

    public Optional<SaltSignature> getSaltSignature() {
        return Optional.ofNullable(this.saltSignature);
    }

    public void setSaltSignature(@Nullable SaltSignature saltSignature) {
        this.saltSignature = saltSignature;
    }
}

