/*
 * Decompiled with CFR 0.152.
 */
package com.github.juliarn.npclib.relocate.com.packetevents.packetevents.wrapper.login.client;

import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.event.PacketReceiveEvent;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.manager.server.ServerVersion;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.packettype.PacketType;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.player.ClientVersion;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.util.crypto.SignatureData;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.wrapper.PacketWrapper;
import java.util.Optional;
import java.util.UUID;
import org.jetbrains.annotations.Nullable;

public class WrapperLoginClientLoginStart
extends PacketWrapper<WrapperLoginClientLoginStart> {
    private String username;
    @Nullable
    private SignatureData signatureData;
    @Nullable
    private UUID playerUUID;

    public WrapperLoginClientLoginStart(PacketReceiveEvent event) {
        super(event);
    }

    public WrapperLoginClientLoginStart(ClientVersion clientVersion, String username) {
        this(clientVersion, username, null, null);
    }

    public WrapperLoginClientLoginStart(ClientVersion clientVersion, String username, @Nullable SignatureData signatureData) {
        this(clientVersion, username, signatureData, null);
    }

    public WrapperLoginClientLoginStart(ClientVersion clientVersion, String username, @Nullable SignatureData signatureData, @Nullable UUID playerUUID) {
        super(PacketType.Login.Client.LOGIN_START.getId(), clientVersion);
        this.username = username;
        this.signatureData = signatureData;
        this.playerUUID = playerUUID;
    }

    @Override
    public void read() {
        this.username = this.readString(16);
        if (this.clientVersion.isNewerThanOrEquals(ClientVersion.V_1_19)) {
            if (this.serverVersion.isOlderThanOrEquals(ServerVersion.V_1_19_3)) {
                this.signatureData = (SignatureData)this.readOptional(PacketWrapper::readSignatureData);
            }
            if (this.clientVersion.isNewerThanOrEquals(ClientVersion.V_1_19_1)) {
                this.playerUUID = (UUID)this.readOptional(PacketWrapper::readUUID);
            }
        }
    }

    @Override
    public void write() {
        this.writeString(this.username, 16);
        if (this.clientVersion.isNewerThanOrEquals(ClientVersion.V_1_19)) {
            if (this.clientVersion.isOlderThanOrEquals(ClientVersion.V_1_19_3)) {
                this.writeOptional(this.signatureData, PacketWrapper::writeSignatureData);
            }
            if (this.clientVersion.isNewerThanOrEquals(ClientVersion.V_1_19_1)) {
                this.writeOptional(this.playerUUID, PacketWrapper::writeUUID);
            }
        }
    }

    @Override
    public void copy(WrapperLoginClientLoginStart wrapper) {
        this.username = wrapper.username;
        this.signatureData = wrapper.signatureData;
        this.playerUUID = wrapper.playerUUID;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public Optional<SignatureData> getSignatureData() {
        return Optional.ofNullable(this.signatureData);
    }

    public void setSignatureData(@Nullable SignatureData signatureData) {
        this.signatureData = signatureData;
    }

    public Optional<UUID> getPlayerUUID() {
        return Optional.ofNullable(this.playerUUID);
    }

    public void setPlayerUUID(@Nullable UUID playerUUID) {
        this.playerUUID = playerUUID;
    }
}

