/*
 * Decompiled with CFR 0.152.
 */
package com.github.juliarn.npclib.relocate.com.packetevents.packetevents.wrapper.play.client;

import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.event.PacketReceiveEvent;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.manager.server.ServerVersion;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.chat.LastSeenMessages;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.packettype.PacketType;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.util.crypto.MessageSignData;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.util.crypto.SaltSignature;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.wrapper.PacketWrapper;
import java.time.Instant;
import org.jetbrains.annotations.Nullable;

public class WrapperPlayClientChatCommand
extends PacketWrapper<WrapperPlayClientChatCommand> {
    private String command;
    private MessageSignData messageSignData;
    @Nullable
    private LastSeenMessages.Update lastSeenMessages;
    @Nullable
    private LastSeenMessages.LegacyUpdate legacyLastSeenMessages;

    public WrapperPlayClientChatCommand(PacketReceiveEvent event) {
        super(event);
    }

    public WrapperPlayClientChatCommand(String command, MessageSignData messageSignData, @Nullable LastSeenMessages.LegacyUpdate lastSeenMessages) {
        super(PacketType.Play.Client.CHAT_COMMAND);
        this.command = command;
        this.messageSignData = messageSignData;
        this.legacyLastSeenMessages = lastSeenMessages;
    }

    public WrapperPlayClientChatCommand(String command, MessageSignData messageSignData, @Nullable LastSeenMessages.Update lastSeenMessages) {
        super(PacketType.Play.Client.CHAT_MESSAGE);
        this.command = command;
        this.messageSignData = messageSignData;
        this.lastSeenMessages = lastSeenMessages;
    }

    @Override
    public void read() {
        int maxMessageLength = this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_11) ? 256 : 100;
        this.command = this.readString(maxMessageLength);
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_19)) {
            Instant timestamp = this.readTimestamp();
            SaltSignature saltSignature = this.readSaltSignature();
            boolean signedPreview = this.readBoolean();
            this.messageSignData = new MessageSignData(saltSignature, timestamp, signedPreview);
            if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_19_3)) {
                this.lastSeenMessages = this.readLastSeenMessagesUpdate();
            } else if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_19_1)) {
                this.legacyLastSeenMessages = this.readLegacyLastSeenMessagesUpdate();
            }
        }
    }

    @Override
    public void write() {
        this.writeString(this.command);
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_19)) {
            this.writeTimestamp(this.messageSignData.getTimestamp());
            this.writeSaltSignature(this.messageSignData.getSaltSignature());
            this.writeBoolean(this.messageSignData.isSignedPreview());
            if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_19_3) && this.lastSeenMessages != null) {
                this.writeLastSeenMessagesUpdate(this.lastSeenMessages);
            } else if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_19_1) && this.serverVersion.isOlderThanOrEquals(ServerVersion.V_1_19_2) && this.legacyLastSeenMessages != null) {
                this.writeLegacyLastSeenMessagesUpdate(this.legacyLastSeenMessages);
            }
        }
    }

    @Override
    public void copy(WrapperPlayClientChatCommand wrapper) {
        this.command = wrapper.command;
        this.messageSignData = wrapper.messageSignData;
        this.lastSeenMessages = wrapper.lastSeenMessages;
        this.legacyLastSeenMessages = wrapper.legacyLastSeenMessages;
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public MessageSignData getMessageSignData() {
        return this.messageSignData;
    }

    public void setMessageSignData(MessageSignData messageSignData) {
        this.messageSignData = messageSignData;
    }

    public @Nullable LastSeenMessages.Update getLastSeenMessages() {
        return this.lastSeenMessages;
    }

    public void setLastSeenMessages(@Nullable LastSeenMessages.Update lastSeenMessages) {
        this.lastSeenMessages = lastSeenMessages;
    }

    public @Nullable LastSeenMessages.LegacyUpdate getLegacyLastSeenMessages() {
        return this.legacyLastSeenMessages;
    }

    public void setLegacyLastSeenMessages(@Nullable LastSeenMessages.LegacyUpdate legacyLastSeenMessages) {
        this.legacyLastSeenMessages = legacyLastSeenMessages;
    }
}

