/*
 * Decompiled with CFR 0.152.
 */
package com.github.juliarn.npclib.relocate.com.packetevents.packetevents.wrapper.play.client;

import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.event.PacketReceiveEvent;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.manager.server.ServerVersion;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.chat.LastSeenMessages;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.packettype.PacketType;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.util.crypto.MessageSignData;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.util.crypto.SaltSignature;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.wrapper.PacketWrapper;
import java.time.Instant;
import java.util.Optional;
import org.jetbrains.annotations.Nullable;

public class WrapperPlayClientChatMessage
extends PacketWrapper<WrapperPlayClientChatMessage> {
    private String message;
    private MessageSignData messageSignData;
    @Nullable
    private LastSeenMessages.Update lastSeenMessages;
    @Nullable
    private LastSeenMessages.LegacyUpdate legacyLastSeenMessages;

    public WrapperPlayClientChatMessage(PacketReceiveEvent event) {
        super(event);
    }

    public WrapperPlayClientChatMessage(String message, @Nullable MessageSignData messageSignData, @Nullable LastSeenMessages.LegacyUpdate lastSeenMessages) {
        super(PacketType.Play.Client.CHAT_MESSAGE);
        this.message = message;
        this.messageSignData = messageSignData;
        this.legacyLastSeenMessages = lastSeenMessages;
    }

    public WrapperPlayClientChatMessage(String message, @Nullable MessageSignData messageSignData, @Nullable LastSeenMessages.Update lastSeenMessages) {
        super(PacketType.Play.Client.CHAT_MESSAGE);
        this.message = message;
        this.messageSignData = messageSignData;
        this.lastSeenMessages = lastSeenMessages;
    }

    @Override
    public void read() {
        int maxMessageLength = this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_11) ? 256 : 100;
        this.message = this.readString(maxMessageLength);
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_19)) {
            Instant timestamp = this.readTimestamp();
            SaltSignature saltSignature = this.readSaltSignature();
            this.messageSignData = new MessageSignData(saltSignature, timestamp);
            if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_19_3)) {
                this.lastSeenMessages = this.readLastSeenMessagesUpdate();
            } else if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_19_1)) {
                boolean signedPreview = this.readBoolean();
                this.messageSignData.setSignedPreview(signedPreview);
                this.legacyLastSeenMessages = this.readLegacyLastSeenMessagesUpdate();
            }
        }
    }

    @Override
    public void write() {
        int maxMessageLength = this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_11) ? 256 : 100;
        this.writeString(this.message, maxMessageLength);
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_19)) {
            this.writeTimestamp(this.messageSignData.getTimestamp());
            this.writeSaltSignature(this.messageSignData.getSaltSignature());
            if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_19_3) && this.lastSeenMessages != null) {
                this.writeLastSeenMessagesUpdate(this.lastSeenMessages);
            } else if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_19_1) && this.serverVersion.isOlderThanOrEquals(ServerVersion.V_1_19_2) && this.legacyLastSeenMessages != null) {
                this.writeBoolean(this.messageSignData.isSignedPreview());
                this.writeLegacyLastSeenMessagesUpdate(this.legacyLastSeenMessages);
            }
        }
    }

    @Override
    public void copy(WrapperPlayClientChatMessage wrapper) {
        this.message = wrapper.message;
        this.messageSignData = wrapper.messageSignData;
        this.lastSeenMessages = wrapper.lastSeenMessages;
        this.legacyLastSeenMessages = wrapper.legacyLastSeenMessages;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Optional<MessageSignData> getMessageSignData() {
        return Optional.ofNullable(this.messageSignData);
    }

    public void setMessageSignData(@Nullable MessageSignData messageSignData) {
        this.messageSignData = messageSignData;
    }

    @Nullable
    public LastSeenMessages.Update getLastSeenMessages() {
        return this.lastSeenMessages;
    }

    public void setLastSeenMessages(@Nullable LastSeenMessages.Update lastSeenMessages) {
        this.lastSeenMessages = lastSeenMessages;
    }

    @Nullable
    public LastSeenMessages.LegacyUpdate getLegacyLastSeenMessages() {
        return this.legacyLastSeenMessages;
    }

    public void setLegacyLastSeenMessages(@Nullable LastSeenMessages.LegacyUpdate lastSeenMessages) {
        this.legacyLastSeenMessages = lastSeenMessages;
    }
}

