/*
 * Decompiled with CFR 0.152.
 */
package com.github.juliarn.npclib.relocate.com.packetevents.packetevents.wrapper.play.client;

import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.event.PacketReceiveEvent;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.manager.server.ServerVersion;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.item.ItemStack;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.packettype.PacketType;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.wrapper.PacketWrapper;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class WrapperPlayClientClickWindow
extends PacketWrapper<WrapperPlayClientClickWindow> {
    private int windowID;
    private Optional<Integer> stateID;
    private int slot;
    private int button;
    private Optional<Integer> actionNumber;
    private WindowClickType windowClickType;
    private Optional<Map<Integer, ItemStack>> slots;
    private ItemStack carriedItemStack;

    public WrapperPlayClientClickWindow(PacketReceiveEvent event) {
        super(event);
    }

    public WrapperPlayClientClickWindow(int windowID, Optional<Integer> stateID, int slot, int button, Optional<Integer> actionNumber, WindowClickType windowClickType, Optional<Map<Integer, ItemStack>> slots, ItemStack carriedItemStack) {
        super(PacketType.Play.Client.CLICK_WINDOW);
        this.windowID = windowID;
        this.stateID = stateID;
        this.slot = slot;
        this.button = button;
        this.actionNumber = actionNumber;
        this.windowClickType = windowClickType;
        this.slots = slots;
        this.carriedItemStack = carriedItemStack;
    }

    @Override
    public void read() {
        boolean v1_17 = this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_17);
        this.windowID = this.readUnsignedByte();
        this.stateID = this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_17_1) ? Optional.of(this.readVarInt()) : Optional.empty();
        this.slot = this.readShort();
        this.button = this.readByte();
        this.actionNumber = !v1_17 ? Optional.of(Integer.valueOf(this.readShort())) : Optional.empty();
        int clickTypeIndex = this.readVarInt();
        this.windowClickType = WindowClickType.VALUES[clickTypeIndex];
        this.slots = v1_17 ? Optional.of(this.readMap(packetWrapper -> Math.toIntExact(packetWrapper.readShort()), PacketWrapper::readItemStack)) : Optional.empty();
        this.carriedItemStack = this.readItemStack();
    }

    @Override
    public void copy(WrapperPlayClientClickWindow wrapper) {
        this.windowID = wrapper.windowID;
        this.stateID = wrapper.stateID;
        this.slot = wrapper.slot;
        this.button = wrapper.button;
        this.actionNumber = wrapper.actionNumber;
        this.windowClickType = wrapper.windowClickType;
        this.slots = wrapper.slots;
        this.carriedItemStack = wrapper.carriedItemStack;
    }

    @Override
    public void write() {
        boolean v1_17 = this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_17);
        this.writeByte(this.windowID);
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_17_1)) {
            this.writeVarInt(this.stateID.orElse(-1));
        }
        this.writeShort(this.slot);
        this.writeByte(this.button);
        if (!v1_17) {
            this.writeShort(this.actionNumber.orElse(-1));
        }
        this.writeVarInt(this.windowClickType.ordinal());
        if (v1_17) {
            this.writeMap(this.slots.orElse(new HashMap()), PacketWrapper::writeShort, PacketWrapper::writeItemStack);
        }
        this.writeItemStack(this.carriedItemStack);
    }

    public int getWindowId() {
        return this.windowID;
    }

    public void setWindowId(int windowID) {
        this.windowID = windowID;
    }

    public Optional<Integer> getStateId() {
        return this.stateID;
    }

    public void setStateID(Optional<Integer> stateID) {
        this.stateID = stateID;
    }

    public int getSlot() {
        return this.slot;
    }

    public void setSlot(int slot) {
        this.slot = slot;
    }

    public int getButton() {
        return this.button;
    }

    public void setButton(int button) {
        this.button = button;
    }

    public Optional<Integer> getActionNumber() {
        return this.actionNumber;
    }

    public void setActionNumber(int button) {
        this.actionNumber = Optional.of(button);
    }

    public WindowClickType getWindowClickType() {
        return this.windowClickType;
    }

    public void setWindowClickType(WindowClickType windowClickType) {
        this.windowClickType = windowClickType;
    }

    public Optional<Map<Integer, ItemStack>> getSlots() {
        return this.slots;
    }

    public void setSlots(Optional<Map<Integer, ItemStack>> slots) {
        this.slots = slots;
    }

    public ItemStack getCarriedItemStack() {
        return this.carriedItemStack;
    }

    public void setCarriedItemStack(ItemStack carriedItemStack) {
        this.carriedItemStack = carriedItemStack;
    }

    public static enum WindowClickType {
        PICKUP,
        QUICK_MOVE,
        SWAP,
        CLONE,
        THROW,
        QUICK_CRAFT,
        PICKUP_ALL;

        public static final WindowClickType[] VALUES;

        static {
            VALUES = WindowClickType.values();
        }
    }
}

